// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhubstrategy.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains detailed information about an application component.
 */
public class ApplicationComponentDetail private constructor(builder: Builder) {
    /**
     * The status of analysis, if the application component has source code or an associated database.
     */
    public val analysisStatus: aws.sdk.kotlin.services.migrationhubstrategy.model.SrcCodeOrDbAnalysisStatus? = builder.analysisStatus
    /**
     * The S3 bucket name and the Amazon S3 key name for the anti-pattern report.
     */
    public val antipatternReportS3Object: aws.sdk.kotlin.services.migrationhubstrategy.model.S3Object? = builder.antipatternReportS3Object
    /**
     * The status of the anti-pattern report generation.
     */
    public val antipatternReportStatus: aws.sdk.kotlin.services.migrationhubstrategy.model.AntipatternReportStatus? = builder.antipatternReportStatus
    /**
     * The status message for the anti-pattern.
     */
    public val antipatternReportStatusMessage: kotlin.String? = builder.antipatternReportStatusMessage
    /**
     * The type of application component.
     */
    public val appType: aws.sdk.kotlin.services.migrationhubstrategy.model.AppType? = builder.appType
    /**
     * The error in the analysis of the source code or database.
     */
    public val appUnitError: aws.sdk.kotlin.services.migrationhubstrategy.model.AppUnitError? = builder.appUnitError
    /**
     * The ID of the server that the application component is running on.
     */
    public val associatedServerId: kotlin.String? = builder.associatedServerId
    /**
     * Configuration details for the database associated with the application component.
     */
    public val databaseConfigDetail: aws.sdk.kotlin.services.migrationhubstrategy.model.DatabaseConfigDetail? = builder.databaseConfigDetail
    /**
     * The ID of the application component.
     */
    public val id: kotlin.String? = builder.id
    /**
     * Indicates whether the application component has been included for server recommendation or not.
     */
    public val inclusionStatus: aws.sdk.kotlin.services.migrationhubstrategy.model.InclusionStatus? = builder.inclusionStatus
    /**
     * The timestamp of when the application component was assessed.
     */
    public val lastAnalyzedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = builder.lastAnalyzedTimestamp
    /**
     * A list of anti-pattern severity summaries.
     */
    public val listAntipatternSeveritySummary: List<AntipatternSeveritySummary>? = builder.listAntipatternSeveritySummary
    /**
     * Set to true if the application component is running on multiple servers.
     */
    public val moreServerAssociationExists: kotlin.Boolean? = builder.moreServerAssociationExists
    /**
     * The name of application component.
     */
    public val name: kotlin.String? = builder.name
    /**
     * OS driver.
     */
    public val osDriver: kotlin.String? = builder.osDriver
    /**
     * OS version.
     */
    public val osVersion: kotlin.String? = builder.osVersion
    /**
     * The top recommendation set for the application component.
     */
    public val recommendationSet: aws.sdk.kotlin.services.migrationhubstrategy.model.RecommendationSet? = builder.recommendationSet
    /**
     * The application component subtype.
     */
    public val resourceSubType: aws.sdk.kotlin.services.migrationhubstrategy.model.ResourceSubType? = builder.resourceSubType
    /**
     * A list of the analysis results.
     */
    public val resultList: List<Result>? = builder.resultList
    /**
     * The status of the application unit.
     */
    public val runtimeStatus: aws.sdk.kotlin.services.migrationhubstrategy.model.RuntimeAnalysisStatus? = builder.runtimeStatus
    /**
     * The status message for the application unit.
     */
    public val runtimeStatusMessage: kotlin.String? = builder.runtimeStatusMessage
    /**
     * Details about the source code repository associated with the application component.
     */
    public val sourceCodeRepositories: List<SourceCodeRepository>? = builder.sourceCodeRepositories
    /**
     * A detailed description of the analysis status and any failure message.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.migrationhubstrategy.model.ApplicationComponentDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApplicationComponentDetail(")
        append("analysisStatus=$analysisStatus,")
        append("antipatternReportS3Object=$antipatternReportS3Object,")
        append("antipatternReportStatus=$antipatternReportStatus,")
        append("antipatternReportStatusMessage=$antipatternReportStatusMessage,")
        append("appType=$appType,")
        append("appUnitError=$appUnitError,")
        append("associatedServerId=$associatedServerId,")
        append("databaseConfigDetail=$databaseConfigDetail,")
        append("id=$id,")
        append("inclusionStatus=$inclusionStatus,")
        append("lastAnalyzedTimestamp=$lastAnalyzedTimestamp,")
        append("listAntipatternSeveritySummary=$listAntipatternSeveritySummary,")
        append("moreServerAssociationExists=$moreServerAssociationExists,")
        append("name=$name,")
        append("osDriver=$osDriver,")
        append("osVersion=$osVersion,")
        append("recommendationSet=$recommendationSet,")
        append("resourceSubType=$resourceSubType,")
        append("resultList=$resultList,")
        append("runtimeStatus=$runtimeStatus,")
        append("runtimeStatusMessage=$runtimeStatusMessage,")
        append("sourceCodeRepositories=$sourceCodeRepositories,")
        append("statusMessage=$statusMessage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = analysisStatus?.hashCode() ?: 0
        result = 31 * result + (antipatternReportS3Object?.hashCode() ?: 0)
        result = 31 * result + (antipatternReportStatus?.hashCode() ?: 0)
        result = 31 * result + (antipatternReportStatusMessage?.hashCode() ?: 0)
        result = 31 * result + (appType?.hashCode() ?: 0)
        result = 31 * result + (appUnitError?.hashCode() ?: 0)
        result = 31 * result + (associatedServerId?.hashCode() ?: 0)
        result = 31 * result + (databaseConfigDetail?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (inclusionStatus?.hashCode() ?: 0)
        result = 31 * result + (lastAnalyzedTimestamp?.hashCode() ?: 0)
        result = 31 * result + (listAntipatternSeveritySummary?.hashCode() ?: 0)
        result = 31 * result + (moreServerAssociationExists?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (osDriver?.hashCode() ?: 0)
        result = 31 * result + (osVersion?.hashCode() ?: 0)
        result = 31 * result + (recommendationSet?.hashCode() ?: 0)
        result = 31 * result + (resourceSubType?.hashCode() ?: 0)
        result = 31 * result + (resultList?.hashCode() ?: 0)
        result = 31 * result + (runtimeStatus?.hashCode() ?: 0)
        result = 31 * result + (runtimeStatusMessage?.hashCode() ?: 0)
        result = 31 * result + (sourceCodeRepositories?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApplicationComponentDetail

        if (analysisStatus != other.analysisStatus) return false
        if (antipatternReportS3Object != other.antipatternReportS3Object) return false
        if (antipatternReportStatus != other.antipatternReportStatus) return false
        if (antipatternReportStatusMessage != other.antipatternReportStatusMessage) return false
        if (appType != other.appType) return false
        if (appUnitError != other.appUnitError) return false
        if (associatedServerId != other.associatedServerId) return false
        if (databaseConfigDetail != other.databaseConfigDetail) return false
        if (id != other.id) return false
        if (inclusionStatus != other.inclusionStatus) return false
        if (lastAnalyzedTimestamp != other.lastAnalyzedTimestamp) return false
        if (listAntipatternSeveritySummary != other.listAntipatternSeveritySummary) return false
        if (moreServerAssociationExists != other.moreServerAssociationExists) return false
        if (name != other.name) return false
        if (osDriver != other.osDriver) return false
        if (osVersion != other.osVersion) return false
        if (recommendationSet != other.recommendationSet) return false
        if (resourceSubType != other.resourceSubType) return false
        if (resultList != other.resultList) return false
        if (runtimeStatus != other.runtimeStatus) return false
        if (runtimeStatusMessage != other.runtimeStatusMessage) return false
        if (sourceCodeRepositories != other.sourceCodeRepositories) return false
        if (statusMessage != other.statusMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.migrationhubstrategy.model.ApplicationComponentDetail = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The status of analysis, if the application component has source code or an associated database.
         */
        public var analysisStatus: aws.sdk.kotlin.services.migrationhubstrategy.model.SrcCodeOrDbAnalysisStatus? = null
        /**
         * The S3 bucket name and the Amazon S3 key name for the anti-pattern report.
         */
        public var antipatternReportS3Object: aws.sdk.kotlin.services.migrationhubstrategy.model.S3Object? = null
        /**
         * The status of the anti-pattern report generation.
         */
        public var antipatternReportStatus: aws.sdk.kotlin.services.migrationhubstrategy.model.AntipatternReportStatus? = null
        /**
         * The status message for the anti-pattern.
         */
        public var antipatternReportStatusMessage: kotlin.String? = null
        /**
         * The type of application component.
         */
        public var appType: aws.sdk.kotlin.services.migrationhubstrategy.model.AppType? = null
        /**
         * The error in the analysis of the source code or database.
         */
        public var appUnitError: aws.sdk.kotlin.services.migrationhubstrategy.model.AppUnitError? = null
        /**
         * The ID of the server that the application component is running on.
         */
        public var associatedServerId: kotlin.String? = null
        /**
         * Configuration details for the database associated with the application component.
         */
        public var databaseConfigDetail: aws.sdk.kotlin.services.migrationhubstrategy.model.DatabaseConfigDetail? = null
        /**
         * The ID of the application component.
         */
        public var id: kotlin.String? = null
        /**
         * Indicates whether the application component has been included for server recommendation or not.
         */
        public var inclusionStatus: aws.sdk.kotlin.services.migrationhubstrategy.model.InclusionStatus? = null
        /**
         * The timestamp of when the application component was assessed.
         */
        public var lastAnalyzedTimestamp: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of anti-pattern severity summaries.
         */
        public var listAntipatternSeveritySummary: List<AntipatternSeveritySummary>? = null
        /**
         * Set to true if the application component is running on multiple servers.
         */
        public var moreServerAssociationExists: kotlin.Boolean? = null
        /**
         * The name of application component.
         */
        public var name: kotlin.String? = null
        /**
         * OS driver.
         */
        public var osDriver: kotlin.String? = null
        /**
         * OS version.
         */
        public var osVersion: kotlin.String? = null
        /**
         * The top recommendation set for the application component.
         */
        public var recommendationSet: aws.sdk.kotlin.services.migrationhubstrategy.model.RecommendationSet? = null
        /**
         * The application component subtype.
         */
        public var resourceSubType: aws.sdk.kotlin.services.migrationhubstrategy.model.ResourceSubType? = null
        /**
         * A list of the analysis results.
         */
        public var resultList: List<Result>? = null
        /**
         * The status of the application unit.
         */
        public var runtimeStatus: aws.sdk.kotlin.services.migrationhubstrategy.model.RuntimeAnalysisStatus? = null
        /**
         * The status message for the application unit.
         */
        public var runtimeStatusMessage: kotlin.String? = null
        /**
         * Details about the source code repository associated with the application component.
         */
        public var sourceCodeRepositories: List<SourceCodeRepository>? = null
        /**
         * A detailed description of the analysis status and any failure message.
         */
        public var statusMessage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.migrationhubstrategy.model.ApplicationComponentDetail) : this() {
            this.analysisStatus = x.analysisStatus
            this.antipatternReportS3Object = x.antipatternReportS3Object
            this.antipatternReportStatus = x.antipatternReportStatus
            this.antipatternReportStatusMessage = x.antipatternReportStatusMessage
            this.appType = x.appType
            this.appUnitError = x.appUnitError
            this.associatedServerId = x.associatedServerId
            this.databaseConfigDetail = x.databaseConfigDetail
            this.id = x.id
            this.inclusionStatus = x.inclusionStatus
            this.lastAnalyzedTimestamp = x.lastAnalyzedTimestamp
            this.listAntipatternSeveritySummary = x.listAntipatternSeveritySummary
            this.moreServerAssociationExists = x.moreServerAssociationExists
            this.name = x.name
            this.osDriver = x.osDriver
            this.osVersion = x.osVersion
            this.recommendationSet = x.recommendationSet
            this.resourceSubType = x.resourceSubType
            this.resultList = x.resultList
            this.runtimeStatus = x.runtimeStatus
            this.runtimeStatusMessage = x.runtimeStatusMessage
            this.sourceCodeRepositories = x.sourceCodeRepositories
            this.statusMessage = x.statusMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.migrationhubstrategy.model.ApplicationComponentDetail = ApplicationComponentDetail(this)

        /**
         * construct an [aws.sdk.kotlin.services.migrationhubstrategy.model.S3Object] inside the given [block]
         */
        public fun antipatternReportS3Object(block: aws.sdk.kotlin.services.migrationhubstrategy.model.S3Object.Builder.() -> kotlin.Unit) {
            this.antipatternReportS3Object = aws.sdk.kotlin.services.migrationhubstrategy.model.S3Object.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.migrationhubstrategy.model.AppUnitError] inside the given [block]
         */
        public fun appUnitError(block: aws.sdk.kotlin.services.migrationhubstrategy.model.AppUnitError.Builder.() -> kotlin.Unit) {
            this.appUnitError = aws.sdk.kotlin.services.migrationhubstrategy.model.AppUnitError.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.migrationhubstrategy.model.DatabaseConfigDetail] inside the given [block]
         */
        public fun databaseConfigDetail(block: aws.sdk.kotlin.services.migrationhubstrategy.model.DatabaseConfigDetail.Builder.() -> kotlin.Unit) {
            this.databaseConfigDetail = aws.sdk.kotlin.services.migrationhubstrategy.model.DatabaseConfigDetail.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.migrationhubstrategy.model.RecommendationSet] inside the given [block]
         */
        public fun recommendationSet(block: aws.sdk.kotlin.services.migrationhubstrategy.model.RecommendationSet.Builder.() -> kotlin.Unit) {
            this.recommendationSet = aws.sdk.kotlin.services.migrationhubstrategy.model.RecommendationSet.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
