// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhubstrategy.serde

import aws.sdk.kotlin.services.migrationhubstrategy.model.ApplicationComponentDetail
import aws.sdk.kotlin.services.migrationhubstrategy.model.AssociatedApplication
import aws.sdk.kotlin.services.migrationhubstrategy.model.GetApplicationComponentDetailsResponse
import aws.sdk.kotlin.services.migrationhubstrategy.model.MigrationHubStrategyException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetApplicationComponentDetailsOperationDeserializer: HttpDeserialize<GetApplicationComponentDetailsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetApplicationComponentDetailsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetApplicationComponentDetailsError(context, call)
        }
        val builder = GetApplicationComponentDetailsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetApplicationComponentDetailsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetApplicationComponentDetailsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MigrationHubStrategyException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        else -> MigrationHubStrategyException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetApplicationComponentDetailsOperationBody(builder: GetApplicationComponentDetailsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPLICATIONCOMPONENTDETAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("applicationComponentDetail"))
    val ASSOCIATEDAPPLICATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("associatedApplications"))
    val ASSOCIATEDSERVERIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("associatedServerIds"))
    val MOREAPPLICATIONRESOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("moreApplicationResource"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPLICATIONCOMPONENTDETAIL_DESCRIPTOR)
        field(ASSOCIATEDAPPLICATIONS_DESCRIPTOR)
        field(ASSOCIATEDSERVERIDS_DESCRIPTOR)
        field(MOREAPPLICATIONRESOURCE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPLICATIONCOMPONENTDETAIL_DESCRIPTOR.index -> builder.applicationComponentDetail = deserializeApplicationComponentDetailDocument(deserializer)
                ASSOCIATEDAPPLICATIONS_DESCRIPTOR.index -> builder.associatedApplications =
                    deserializer.deserializeList(ASSOCIATEDAPPLICATIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<AssociatedApplication>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeAssociatedApplicationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ASSOCIATEDSERVERIDS_DESCRIPTOR.index -> builder.associatedServerIds =
                    deserializer.deserializeList(ASSOCIATEDSERVERIDS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                MOREAPPLICATIONRESOURCE_DESCRIPTOR.index -> builder.moreApplicationResource = deserializeBoolean()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
