// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhubstrategy.model



public class UpdateApplicationComponentConfigRequest private constructor(builder: Builder) {
    /**
     * The type of known component.
     */
    public val appType: aws.sdk.kotlin.services.migrationhubstrategy.model.AppType? = builder.appType
    /**
     * The ID of the application component. The ID is unique within an AWS account.
     */
    public val applicationComponentId: kotlin.String = requireNotNull(builder.applicationComponentId) { "A non-null value must be provided for applicationComponentId" }
    /**
     * Update the configuration request of an application component. If it is set to true, the source code and/or database credentials are updated. If it is set to false, the source code and/or database credentials are updated and an analysis is initiated.
     */
    public val configureOnly: kotlin.Boolean? = builder.configureOnly
    /**
     * Indicates whether the application component has been included for server recommendation or not.
     */
    public val inclusionStatus: aws.sdk.kotlin.services.migrationhubstrategy.model.InclusionStatus? = builder.inclusionStatus
    /**
     * Database credentials.
     */
    public val secretsManagerKey: kotlin.String? = builder.secretsManagerKey
    /**
     * The list of source code configurations to update for the application component.
     */
    public val sourceCodeList: List<SourceCode>? = builder.sourceCodeList
    /**
     * The preferred strategy options for the application component. Use values from the GetApplicationComponentStrategies response.
     */
    public val strategyOption: aws.sdk.kotlin.services.migrationhubstrategy.model.StrategyOption? = builder.strategyOption

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.migrationhubstrategy.model.UpdateApplicationComponentConfigRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateApplicationComponentConfigRequest(")
        append("appType=$appType,")
        append("applicationComponentId=$applicationComponentId,")
        append("configureOnly=$configureOnly,")
        append("inclusionStatus=$inclusionStatus,")
        append("secretsManagerKey=*** Sensitive Data Redacted ***,")
        append("sourceCodeList=$sourceCodeList,")
        append("strategyOption=$strategyOption")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appType?.hashCode() ?: 0
        result = 31 * result + (applicationComponentId.hashCode())
        result = 31 * result + (configureOnly?.hashCode() ?: 0)
        result = 31 * result + (inclusionStatus?.hashCode() ?: 0)
        result = 31 * result + (secretsManagerKey?.hashCode() ?: 0)
        result = 31 * result + (sourceCodeList?.hashCode() ?: 0)
        result = 31 * result + (strategyOption?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateApplicationComponentConfigRequest

        if (appType != other.appType) return false
        if (applicationComponentId != other.applicationComponentId) return false
        if (configureOnly != other.configureOnly) return false
        if (inclusionStatus != other.inclusionStatus) return false
        if (secretsManagerKey != other.secretsManagerKey) return false
        if (sourceCodeList != other.sourceCodeList) return false
        if (strategyOption != other.strategyOption) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.migrationhubstrategy.model.UpdateApplicationComponentConfigRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The type of known component.
         */
        public var appType: aws.sdk.kotlin.services.migrationhubstrategy.model.AppType? = null
        /**
         * The ID of the application component. The ID is unique within an AWS account.
         */
        public var applicationComponentId: kotlin.String? = null
        /**
         * Update the configuration request of an application component. If it is set to true, the source code and/or database credentials are updated. If it is set to false, the source code and/or database credentials are updated and an analysis is initiated.
         */
        public var configureOnly: kotlin.Boolean? = null
        /**
         * Indicates whether the application component has been included for server recommendation or not.
         */
        public var inclusionStatus: aws.sdk.kotlin.services.migrationhubstrategy.model.InclusionStatus? = null
        /**
         * Database credentials.
         */
        public var secretsManagerKey: kotlin.String? = null
        /**
         * The list of source code configurations to update for the application component.
         */
        public var sourceCodeList: List<SourceCode>? = null
        /**
         * The preferred strategy options for the application component. Use values from the GetApplicationComponentStrategies response.
         */
        public var strategyOption: aws.sdk.kotlin.services.migrationhubstrategy.model.StrategyOption? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.migrationhubstrategy.model.UpdateApplicationComponentConfigRequest) : this() {
            this.appType = x.appType
            this.applicationComponentId = x.applicationComponentId
            this.configureOnly = x.configureOnly
            this.inclusionStatus = x.inclusionStatus
            this.secretsManagerKey = x.secretsManagerKey
            this.sourceCodeList = x.sourceCodeList
            this.strategyOption = x.strategyOption
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.migrationhubstrategy.model.UpdateApplicationComponentConfigRequest = UpdateApplicationComponentConfigRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.migrationhubstrategy.model.StrategyOption] inside the given [block]
         */
        public fun strategyOption(block: aws.sdk.kotlin.services.migrationhubstrategy.model.StrategyOption.Builder.() -> kotlin.Unit) {
            this.strategyOption = aws.sdk.kotlin.services.migrationhubstrategy.model.StrategyOption.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (applicationComponentId == null) applicationComponentId = ""
            return this
        }
    }
}
