// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhubstrategy.serde

import aws.sdk.kotlin.services.migrationhubstrategy.model.ApplicationMode
import aws.sdk.kotlin.services.migrationhubstrategy.model.ApplicationPreferences
import aws.sdk.kotlin.services.migrationhubstrategy.model.DatabasePreferences
import aws.sdk.kotlin.services.migrationhubstrategy.model.GetPortfolioPreferencesResponse
import aws.sdk.kotlin.services.migrationhubstrategy.model.MigrationHubStrategyException
import aws.sdk.kotlin.services.migrationhubstrategy.model.PrioritizeBusinessGoals
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetPortfolioPreferencesOperationDeserializer: HttpDeserialize<GetPortfolioPreferencesResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetPortfolioPreferencesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetPortfolioPreferencesError(context, call)
        }
        val builder = GetPortfolioPreferencesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetPortfolioPreferencesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetPortfolioPreferencesError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MigrationHubStrategyException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        else -> MigrationHubStrategyException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetPortfolioPreferencesOperationBody(builder: GetPortfolioPreferencesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPLICATIONMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("applicationMode"))
    val APPLICATIONPREFERENCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("applicationPreferences"))
    val DATABASEPREFERENCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("databasePreferences"))
    val PRIORITIZEBUSINESSGOALS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("prioritizeBusinessGoals"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPLICATIONMODE_DESCRIPTOR)
        field(APPLICATIONPREFERENCES_DESCRIPTOR)
        field(DATABASEPREFERENCES_DESCRIPTOR)
        field(PRIORITIZEBUSINESSGOALS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPLICATIONMODE_DESCRIPTOR.index -> builder.applicationMode = deserializeString().let { ApplicationMode.fromValue(it) }
                APPLICATIONPREFERENCES_DESCRIPTOR.index -> builder.applicationPreferences = deserializeApplicationPreferencesDocument(deserializer)
                DATABASEPREFERENCES_DESCRIPTOR.index -> builder.databasePreferences = deserializeDatabasePreferencesDocument(deserializer)
                PRIORITIZEBUSINESSGOALS_DESCRIPTOR.index -> builder.prioritizeBusinessGoals = deserializePrioritizeBusinessGoalsDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
