// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhubrefactorspaces.model

import aws.smithy.kotlin.runtime.SdkDsl

private val awsSdkKotlinServicesMigrationhubrefactorspacesModelDefaultRouteInputDslBuilderRef = aws.sdk.kotlin.services.migrationhubrefactorspaces.model.DefaultRouteInput
private val awsSdkKotlinServicesMigrationhubrefactorspacesModelUriPathRouteInputDslBuilderRef = aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UriPathRouteInput

public class CreateRouteRequest private constructor(builder: Builder) {
    /**
     * The ID of the application within which the route is being created.
     */
    public val applicationIdentifier: kotlin.String = requireNotNull(builder.applicationIdentifier) { "A non-null value must be provided for applicationIdentifier" }
    /**
     * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * Configuration for the default route type.
     */
    public val defaultRoute: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.DefaultRouteInput? = builder.defaultRoute
    /**
     * The ID of the environment in which the route is created.
     */
    public val environmentIdentifier: kotlin.String = requireNotNull(builder.environmentIdentifier) { "A non-null value must be provided for environmentIdentifier" }
    /**
     * The route type of the route. `DEFAULT` indicates that all traffic that does not match another route is forwarded to the default route. Applications must have a default route before any other routes can be created. `URI_PATH` indicates a route that is based on a URI path.
     */
    public val routeType: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.RouteType = requireNotNull(builder.routeType) { "A non-null value must be provided for routeType" }
    /**
     * The ID of the service in which the route is created. Traffic that matches this route is forwarded to this service.
     */
    public val serviceIdentifier: kotlin.String = requireNotNull(builder.serviceIdentifier) { "A non-null value must be provided for serviceIdentifier" }
    /**
     * The tags to assign to the route. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair..
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The configuration for the URI path route type.
     */
    public val uriPathRoute: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UriPathRouteInput? = builder.uriPathRoute

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateRouteRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateRouteRequest(")
        append("applicationIdentifier=$applicationIdentifier,")
        append("clientToken=$clientToken,")
        append("defaultRoute=$defaultRoute,")
        append("environmentIdentifier=$environmentIdentifier,")
        append("routeType=$routeType,")
        append("serviceIdentifier=$serviceIdentifier,")
        append("tags=*** Sensitive Data Redacted ***,")
        append("uriPathRoute=$uriPathRoute")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationIdentifier.hashCode()
        result = 31 * result + (this.clientToken?.hashCode() ?: 0)
        result = 31 * result + (this.defaultRoute?.hashCode() ?: 0)
        result = 31 * result + (this.environmentIdentifier.hashCode())
        result = 31 * result + (this.routeType.hashCode())
        result = 31 * result + (this.serviceIdentifier.hashCode())
        result = 31 * result + (this.tags?.hashCode() ?: 0)
        result = 31 * result + (this.uriPathRoute?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateRouteRequest

        if (applicationIdentifier != other.applicationIdentifier) return false
        if (clientToken != other.clientToken) return false
        if (defaultRoute != other.defaultRoute) return false
        if (environmentIdentifier != other.environmentIdentifier) return false
        if (routeType != other.routeType) return false
        if (serviceIdentifier != other.serviceIdentifier) return false
        if (tags != other.tags) return false
        if (uriPathRoute != other.uriPathRoute) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateRouteRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the application within which the route is being created.
         */
        public var applicationIdentifier: kotlin.String? = null
        /**
         * A unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         */
        public var clientToken: kotlin.String? = null
        /**
         * Configuration for the default route type.
         */
        public var defaultRoute: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.DefaultRouteInput? = null
        /**
         * The ID of the environment in which the route is created.
         */
        public var environmentIdentifier: kotlin.String? = null
        /**
         * The route type of the route. `DEFAULT` indicates that all traffic that does not match another route is forwarded to the default route. Applications must have a default route before any other routes can be created. `URI_PATH` indicates a route that is based on a URI path.
         */
        public var routeType: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.RouteType? = null
        /**
         * The ID of the service in which the route is created. Traffic that matches this route is forwarded to this service.
         */
        public var serviceIdentifier: kotlin.String? = null
        /**
         * The tags to assign to the route. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair..
         */
        public var tags: Map<String, String>? = null
        /**
         * The configuration for the URI path route type.
         */
        public var uriPathRoute: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UriPathRouteInput? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateRouteRequest) : this() {
            this.applicationIdentifier = x.applicationIdentifier
            this.clientToken = x.clientToken
            this.defaultRoute = x.defaultRoute
            this.environmentIdentifier = x.environmentIdentifier
            this.routeType = x.routeType
            this.serviceIdentifier = x.serviceIdentifier
            this.tags = x.tags
            this.uriPathRoute = x.uriPathRoute
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateRouteRequest = CreateRouteRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.migrationhubrefactorspaces.model.DefaultRouteInput] inside the given [block]
         */
        public fun defaultRoute(block: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.DefaultRouteInput.Builder.() -> kotlin.Unit) {
            this.defaultRoute = awsSdkKotlinServicesMigrationhubrefactorspacesModelDefaultRouteInputDslBuilderRef(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UriPathRouteInput] inside the given [block]
         */
        public fun uriPathRoute(block: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UriPathRouteInput.Builder.() -> kotlin.Unit) {
            this.uriPathRoute = awsSdkKotlinServicesMigrationhubrefactorspacesModelUriPathRouteInputDslBuilderRef(block)
        }

        internal fun correctErrors(): Builder {
            if (applicationIdentifier == null) applicationIdentifier = ""
            if (environmentIdentifier == null) environmentIdentifier = ""
            if (routeType == null) routeType = RouteType.SdkUnknown("no value provided")
            if (serviceIdentifier == null) serviceIdentifier = ""
            return this
        }
    }
}
