// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhubrefactorspaces.serde

import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ApiGatewayProxyInput
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateApplicationRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ProxyType
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateApplicationOperationSerializer: HttpSerializer.NonStreaming<CreateApplicationRequest> {
    override fun serialize(context: ExecutionContext, input: CreateApplicationRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encodedSegments {
                add(PercentEncoding.Path.encode("environments"))
                add(PercentEncoding.SmithyLabel.encode(input.environmentIdentifier))
                add(PercentEncoding.Path.encode("applications"))
            }
        }

        val payload = serializeCreateApplicationOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateApplicationOperationBody(context: ExecutionContext, input: CreateApplicationRequest): ByteArray {
    val serializer = JsonSerializer()
    val APIGATEWAYPROXY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ApiGatewayProxy"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClientToken"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val PROXYTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ProxyType"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val VPCID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VpcId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APIGATEWAYPROXY_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PROXYTYPE_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VPCID_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.apiGatewayProxy?.let { field(APIGATEWAYPROXY_DESCRIPTOR, it, ::serializeApiGatewayProxyInputDocument) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        field(NAME_DESCRIPTOR, input.name)
        field(PROXYTYPE_DESCRIPTOR, input.proxyType.value)
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        field(VPCID_DESCRIPTOR, input.vpcId)
    }
    return serializer.toByteArray()
}
