// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhubrefactorspaces.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The summary of the configuration for the URL endpoint type.
 */
public class UrlEndpointSummary private constructor(builder: Builder) {
    /**
     * The health check URL of the URL endpoint type. If the URL is a public endpoint, the `HealthUrl` must also be a public endpoint. If the URL is a private endpoint inside a virtual private cloud (VPC), the health URL must also be a private endpoint, and the host must be the same as the URL.
     */
    public val healthUrl: kotlin.String? = builder.healthUrl
    /**
     * The URL to route traffic to. The URL must be an [rfc3986-formatted URL](https://datatracker.ietf.org/doc/html/rfc3986). If the host is a domain name, the name must be resolvable over the public internet. If the scheme is `https`, the top level domain of the host must be listed in the [IANA root zone database](https://www.iana.org/domains/root/db).
     */
    public val url: kotlin.String? = builder.url

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UrlEndpointSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UrlEndpointSummary(")
        append("healthUrl=$healthUrl,")
        append("url=$url")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = healthUrl?.hashCode() ?: 0
        result = 31 * result + (url?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UrlEndpointSummary

        if (healthUrl != other.healthUrl) return false
        if (url != other.url) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UrlEndpointSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The health check URL of the URL endpoint type. If the URL is a public endpoint, the `HealthUrl` must also be a public endpoint. If the URL is a private endpoint inside a virtual private cloud (VPC), the health URL must also be a private endpoint, and the host must be the same as the URL.
         */
        public var healthUrl: kotlin.String? = null
        /**
         * The URL to route traffic to. The URL must be an [rfc3986-formatted URL](https://datatracker.ietf.org/doc/html/rfc3986). If the host is a domain name, the name must be resolvable over the public internet. If the scheme is `https`, the top level domain of the host must be listed in the [IANA root zone database](https://www.iana.org/domains/root/db).
         */
        public var url: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UrlEndpointSummary) : this() {
            this.healthUrl = x.healthUrl
            this.url = x.url
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UrlEndpointSummary = UrlEndpointSummary(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
