// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhubrefactorspaces

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.migrationhubrefactorspaces.auth.DefaultMigrationHubRefactorSpacesAuthSchemeProvider
import aws.sdk.kotlin.services.migrationhubrefactorspaces.auth.MigrationHubRefactorSpacesAuthSchemeProvider
import aws.sdk.kotlin.services.migrationhubrefactorspaces.endpoints.DefaultMigrationHubRefactorSpacesEndpointProvider
import aws.sdk.kotlin.services.migrationhubrefactorspaces.endpoints.MigrationHubRefactorSpacesEndpointParameters
import aws.sdk.kotlin.services.migrationhubrefactorspaces.endpoints.MigrationHubRefactorSpacesEndpointProvider
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateApplicationRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateApplicationResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateEnvironmentRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateEnvironmentResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateRouteRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateRouteResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateServiceRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateServiceResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.DeleteApplicationRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.DeleteApplicationResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.DeleteEnvironmentRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.DeleteEnvironmentResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.DeleteResourcePolicyRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.DeleteResourcePolicyResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.DeleteRouteRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.DeleteRouteResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.DeleteServiceRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.DeleteServiceResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.GetApplicationRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.GetApplicationResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.GetEnvironmentRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.GetEnvironmentResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.GetResourcePolicyRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.GetResourcePolicyResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.GetRouteRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.GetRouteResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.GetServiceRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.GetServiceResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ListApplicationsRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ListApplicationsResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ListEnvironmentVpcsRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ListEnvironmentVpcsResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ListEnvironmentsRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ListEnvironmentsResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ListRoutesRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ListRoutesResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ListServicesRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ListServicesResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.PutResourcePolicyRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.PutResourcePolicyResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.TagResourceRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.TagResourceResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UntagResourceRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UntagResourceResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UpdateRouteRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UpdateRouteResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Migration Hub Refactor Spaces"
public const val SdkVersion: String = "1.3.98"
public const val ServiceApiVersion: String = "2021-10-26"

/**
 * # Amazon Web Services Migration Hub Refactor Spaces
 * This API reference provides descriptions, syntax, and other details about each of the actions and data types for Amazon Web Services Migration Hub Refactor Spaces (Refactor Spaces). The topic for each action shows the API request parameters and the response. Alternatively, you can use one of the Amazon Web Services SDKs to access an API that is tailored to the programming language or platform that you're using. For more information, see [Amazon Web Services SDKs](https://aws.amazon.com/tools/#SDKs).
 *
 * To share Refactor Spaces environments with other Amazon Web Services accounts or with Organizations and their OUs, use Resource Access Manager's `CreateResourceShare` API. See [CreateResourceShare](https://docs.aws.amazon.com/ram/latest/APIReference/API_CreateResourceShare.html) in the *Amazon Web Services RAM API Reference*.
 */
public interface MigrationHubRefactorSpacesClient : SdkClient {
    /**
     * MigrationHubRefactorSpacesClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, MigrationHubRefactorSpacesClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "MigrationHubRefactorSpaces",
                "MIGRATION_HUB_REFACTOR_SPACES",
                "migration_hub_refactor_spaces",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, MigrationHubRefactorSpacesClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): MigrationHubRefactorSpacesClient = DefaultMigrationHubRefactorSpacesClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: MigrationHubRefactorSpacesEndpointProvider = builder.endpointProvider ?: DefaultMigrationHubRefactorSpacesEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: MigrationHubRefactorSpacesAuthSchemeProvider = builder.authSchemeProvider ?: DefaultMigrationHubRefactorSpacesAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Migration Hub Refactor Spaces"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: MigrationHubRefactorSpacesEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: MigrationHubRefactorSpacesAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates an Amazon Web Services Migration Hub Refactor Spaces application. The account that owns the environment also owns the applications created inside the environment, regardless of the account that creates the application. Refactor Spaces provisions an Amazon API Gateway, API Gateway VPC link, and Network Load Balancer for the application proxy inside your account.
     *
     * In environments created with a [CreateEnvironment:NetworkFabricType](https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/APIReference/API_CreateEnvironment.html#migrationhubrefactorspaces-CreateEnvironment-request-NetworkFabricType) of `NONE` you need to configure [ VPC to VPC connectivity](https://docs.aws.amazon.com/whitepapers/latest/aws-vpc-connectivity-options/amazon-vpc-to-amazon-vpc-connectivity-options.html) between your service VPC and the application proxy VPC to route traffic through the application proxy to a service with a private URL endpoint. For more information, see [ Create an application](https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/userguide/getting-started-create-application.html) in the *Refactor Spaces User Guide*.
     */
    public suspend fun createApplication(input: CreateApplicationRequest): CreateApplicationResponse

    /**
     * Creates an Amazon Web Services Migration Hub Refactor Spaces environment. The caller owns the environment resource, and all Refactor Spaces applications, services, and routes created within the environment. They are referred to as the *environment owner*. The environment owner has cross-account visibility and control of Refactor Spaces resources that are added to the environment by other accounts that the environment is shared with.
     *
     * When creating an environment with a [CreateEnvironment:NetworkFabricType](https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/APIReference/API_CreateEnvironment.html#migrationhubrefactorspaces-CreateEnvironment-request-NetworkFabricType) of `TRANSIT_GATEWAY`, Refactor Spaces provisions a transit gateway to enable services in VPCs to communicate directly across accounts. If [CreateEnvironment:NetworkFabricType](https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/APIReference/API_CreateEnvironment.html#migrationhubrefactorspaces-CreateEnvironment-request-NetworkFabricType) is `NONE`, Refactor Spaces does not create a transit gateway and you must use your network infrastructure to route traffic to services with private URL endpoints.
     */
    public suspend fun createEnvironment(input: CreateEnvironmentRequest): CreateEnvironmentResponse

    /**
     * Creates an Amazon Web Services Migration Hub Refactor Spaces route. The account owner of the service resource is always the environment owner, regardless of which account creates the route. Routes target a service in the application. If an application does not have any routes, then the first route must be created as a `DEFAULT``RouteType`.
     *
     * When created, the default route defaults to an active state so state is not a required input. However, like all other state values the state of the default route can be updated after creation, but only when all other routes are also inactive. Conversely, no route can be active without the default route also being active.
     *
     * When you create a route, Refactor Spaces configures the Amazon API Gateway to send traffic to the target service as follows:
     * + **URL Endpoints**If the service has a URL endpoint, and the endpoint resolves to a private IP address, Refactor Spaces routes traffic using the API Gateway VPC link. If a service endpoint resolves to a public IP address, Refactor Spaces routes traffic over the public internet. Services can have HTTP or HTTPS URL endpoints. For HTTPS URLs, publicly-signed certificates are supported. Private Certificate Authorities (CAs) are permitted only if the CA's domain is also publicly resolvable. Refactor Spaces automatically resolves the public Domain Name System (DNS) names that are set in `CreateService:UrlEndpoint `when you create a service. The DNS names resolve when the DNS time-to-live (TTL) expires, or every 60 seconds for TTLs less than 60 seconds. This periodic DNS resolution ensures that the route configuration remains up-to-date. **One-time health check**A one-time health check is performed on the service when either the route is updated from inactive to active, or when it is created with an active state. If the health check fails, the route transitions the route state to `FAILED`, an error code of `SERVICE_ENDPOINT_HEALTH_CHECK_FAILURE` is provided, and no traffic is sent to the service.For private URLs, a target group is created on the Network Load Balancer and the load balancer target group runs default target health checks. By default, the health check is run against the service endpoint URL. Optionally, the health check can be performed against a different protocol, port, and/or path using the [CreateService:UrlEndpoint](https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/APIReference/API_CreateService.html#migrationhubrefactorspaces-CreateService-request-UrlEndpoint) parameter. All other health check settings for the load balancer use the default values described in the [Health checks for your target groups](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/target-group-health-checks.html) in the *Elastic Load Balancing guide*. The health check is considered successful if at least one target within the target group transitions to a healthy state.
     * + **Lambda function endpoints**If the service has an Lambda function endpoint, then Refactor Spaces configures the Lambda function's resource policy to allow the application's API Gateway to invoke the function.The Lambda function state is checked. If the function is not active, the function configuration is updated so that Lambda resources are provisioned. If the Lambda state is `Failed`, then the route creation fails. For more information, see the [GetFunctionConfiguration's State response parameter](https://docs.aws.amazon.com/lambda/latest/dg/API_GetFunctionConfiguration.html#SSS-GetFunctionConfiguration-response-State) in the *Lambda Developer Guide*.A check is performed to determine that a Lambda function with the specified ARN exists. If it does not exist, the health check fails. For public URLs, a connection is opened to the public endpoint. If the URL is not reachable, the health check fails.
     *
     * **Environments without a network bridge**
     *
     * When you create environments without a network bridge ([CreateEnvironment:NetworkFabricType](https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/APIReference/API_CreateEnvironment.html#migrationhubrefactorspaces-CreateEnvironment-request-NetworkFabricType) is `NONE)` and you use your own networking infrastructure, you need to configure [VPC to VPC connectivity](https://docs.aws.amazon.com/whitepapers/latest/aws-vpc-connectivity-options/amazon-vpc-to-amazon-vpc-connectivity-options.html) between your network and the application proxy VPC. Route creation from the application proxy to service endpoints will fail if your network is not configured to connect to the application proxy VPC. For more information, see [ Create a route](https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/userguide/getting-started-create-role.html) in the *Refactor Spaces User Guide*.
     */
    public suspend fun createRoute(input: CreateRouteRequest): CreateRouteResponse

    /**
     * Creates an Amazon Web Services Migration Hub Refactor Spaces service. The account owner of the service is always the environment owner, regardless of which account in the environment creates the service. Services have either a URL endpoint in a virtual private cloud (VPC), or a Lambda function endpoint.
     *
     * If an Amazon Web Services resource is launched in a service VPC, and you want it to be accessible to all of an environment’s services with VPCs and routes, apply the `RefactorSpacesSecurityGroup` to the resource. Alternatively, to add more cross-account constraints, apply your own security group.
     */
    public suspend fun createService(input: CreateServiceRequest): CreateServiceResponse

    /**
     * Deletes an Amazon Web Services Migration Hub Refactor Spaces application. Before you can delete an application, you must first delete any services or routes within the application.
     */
    public suspend fun deleteApplication(input: DeleteApplicationRequest): DeleteApplicationResponse

    /**
     * Deletes an Amazon Web Services Migration Hub Refactor Spaces environment. Before you can delete an environment, you must first delete any applications and services within the environment.
     */
    public suspend fun deleteEnvironment(input: DeleteEnvironmentRequest): DeleteEnvironmentResponse

    /**
     * Deletes the resource policy set for the environment.
     */
    public suspend fun deleteResourcePolicy(input: DeleteResourcePolicyRequest): DeleteResourcePolicyResponse

    /**
     * Deletes an Amazon Web Services Migration Hub Refactor Spaces route.
     */
    public suspend fun deleteRoute(input: DeleteRouteRequest): DeleteRouteResponse

    /**
     * Deletes an Amazon Web Services Migration Hub Refactor Spaces service.
     */
    public suspend fun deleteService(input: DeleteServiceRequest): DeleteServiceResponse

    /**
     * Gets an Amazon Web Services Migration Hub Refactor Spaces application.
     */
    public suspend fun getApplication(input: GetApplicationRequest): GetApplicationResponse

    /**
     * Gets an Amazon Web Services Migration Hub Refactor Spaces environment.
     */
    public suspend fun getEnvironment(input: GetEnvironmentRequest): GetEnvironmentResponse

    /**
     * Gets the resource-based permission policy that is set for the given environment.
     */
    public suspend fun getResourcePolicy(input: GetResourcePolicyRequest): GetResourcePolicyResponse

    /**
     * Gets an Amazon Web Services Migration Hub Refactor Spaces route.
     */
    public suspend fun getRoute(input: GetRouteRequest): GetRouteResponse

    /**
     * Gets an Amazon Web Services Migration Hub Refactor Spaces service.
     */
    public suspend fun getService(input: GetServiceRequest): GetServiceResponse

    /**
     * Lists all the Amazon Web Services Migration Hub Refactor Spaces applications within an environment.
     */
    public suspend fun listApplications(input: ListApplicationsRequest): ListApplicationsResponse

    /**
     * Lists all Amazon Web Services Migration Hub Refactor Spaces service virtual private clouds (VPCs) that are part of the environment.
     */
    public suspend fun listEnvironmentVpcs(input: ListEnvironmentVpcsRequest): ListEnvironmentVpcsResponse

    /**
     * Lists Amazon Web Services Migration Hub Refactor Spaces environments owned by a caller account or shared with the caller account.
     */
    public suspend fun listEnvironments(input: ListEnvironmentsRequest = ListEnvironmentsRequest { }): ListEnvironmentsResponse

    /**
     * Lists all the Amazon Web Services Migration Hub Refactor Spaces routes within an application.
     */
    public suspend fun listRoutes(input: ListRoutesRequest): ListRoutesResponse

    /**
     * Lists all the Amazon Web Services Migration Hub Refactor Spaces services within an application.
     */
    public suspend fun listServices(input: ListServicesRequest): ListServicesResponse

    /**
     * Lists the tags of a resource. The caller account must be the same as the resource’s `OwnerAccountId`. Listing tags in other accounts is not supported.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Attaches a resource-based permission policy to the Amazon Web Services Migration Hub Refactor Spaces environment. The policy must contain the same actions and condition statements as the `arn:aws:ram::aws:permission/AWSRAMDefaultPermissionRefactorSpacesEnvironment` permission in Resource Access Manager. The policy must not contain new lines or blank lines.
     */
    public suspend fun putResourcePolicy(input: PutResourcePolicyRequest): PutResourcePolicyResponse

    /**
     * Removes the tags of a given resource. Tags are metadata which can be used to manage a resource. To tag a resource, the caller account must be the same as the resource’s `OwnerAccountId`. Tagging resources in other accounts is not supported.
     *
     * Amazon Web Services Migration Hub Refactor Spaces does not propagate tags to orchestrated resources, such as an environment’s transit gateway.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds to or modifies the tags of the given resource. Tags are metadata which can be used to manage a resource. To untag a resource, the caller account must be the same as the resource’s `OwnerAccountId`. Untagging resources across accounts is not supported.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an Amazon Web Services Migration Hub Refactor Spaces route.
     */
    public suspend fun updateRoute(input: UpdateRouteRequest): UpdateRouteResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun MigrationHubRefactorSpacesClient.withConfig(block: MigrationHubRefactorSpacesClient.Config.Builder.() -> Unit): MigrationHubRefactorSpacesClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultMigrationHubRefactorSpacesClient(newConfig)
}

/**
 * Creates an Amazon Web Services Migration Hub Refactor Spaces application. The account that owns the environment also owns the applications created inside the environment, regardless of the account that creates the application. Refactor Spaces provisions an Amazon API Gateway, API Gateway VPC link, and Network Load Balancer for the application proxy inside your account.
 *
 * In environments created with a [CreateEnvironment:NetworkFabricType](https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/APIReference/API_CreateEnvironment.html#migrationhubrefactorspaces-CreateEnvironment-request-NetworkFabricType) of `NONE` you need to configure [ VPC to VPC connectivity](https://docs.aws.amazon.com/whitepapers/latest/aws-vpc-connectivity-options/amazon-vpc-to-amazon-vpc-connectivity-options.html) between your service VPC and the application proxy VPC to route traffic through the application proxy to a service with a private URL endpoint. For more information, see [ Create an application](https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/userguide/getting-started-create-application.html) in the *Refactor Spaces User Guide*.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.createApplication(crossinline block: CreateApplicationRequest.Builder.() -> Unit): CreateApplicationResponse = createApplication(CreateApplicationRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Web Services Migration Hub Refactor Spaces environment. The caller owns the environment resource, and all Refactor Spaces applications, services, and routes created within the environment. They are referred to as the *environment owner*. The environment owner has cross-account visibility and control of Refactor Spaces resources that are added to the environment by other accounts that the environment is shared with.
 *
 * When creating an environment with a [CreateEnvironment:NetworkFabricType](https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/APIReference/API_CreateEnvironment.html#migrationhubrefactorspaces-CreateEnvironment-request-NetworkFabricType) of `TRANSIT_GATEWAY`, Refactor Spaces provisions a transit gateway to enable services in VPCs to communicate directly across accounts. If [CreateEnvironment:NetworkFabricType](https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/APIReference/API_CreateEnvironment.html#migrationhubrefactorspaces-CreateEnvironment-request-NetworkFabricType) is `NONE`, Refactor Spaces does not create a transit gateway and you must use your network infrastructure to route traffic to services with private URL endpoints.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.createEnvironment(crossinline block: CreateEnvironmentRequest.Builder.() -> Unit): CreateEnvironmentResponse = createEnvironment(CreateEnvironmentRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Web Services Migration Hub Refactor Spaces route. The account owner of the service resource is always the environment owner, regardless of which account creates the route. Routes target a service in the application. If an application does not have any routes, then the first route must be created as a `DEFAULT``RouteType`.
 *
 * When created, the default route defaults to an active state so state is not a required input. However, like all other state values the state of the default route can be updated after creation, but only when all other routes are also inactive. Conversely, no route can be active without the default route also being active.
 *
 * When you create a route, Refactor Spaces configures the Amazon API Gateway to send traffic to the target service as follows:
 * + **URL Endpoints**If the service has a URL endpoint, and the endpoint resolves to a private IP address, Refactor Spaces routes traffic using the API Gateway VPC link. If a service endpoint resolves to a public IP address, Refactor Spaces routes traffic over the public internet. Services can have HTTP or HTTPS URL endpoints. For HTTPS URLs, publicly-signed certificates are supported. Private Certificate Authorities (CAs) are permitted only if the CA's domain is also publicly resolvable. Refactor Spaces automatically resolves the public Domain Name System (DNS) names that are set in `CreateService:UrlEndpoint `when you create a service. The DNS names resolve when the DNS time-to-live (TTL) expires, or every 60 seconds for TTLs less than 60 seconds. This periodic DNS resolution ensures that the route configuration remains up-to-date. **One-time health check**A one-time health check is performed on the service when either the route is updated from inactive to active, or when it is created with an active state. If the health check fails, the route transitions the route state to `FAILED`, an error code of `SERVICE_ENDPOINT_HEALTH_CHECK_FAILURE` is provided, and no traffic is sent to the service.For private URLs, a target group is created on the Network Load Balancer and the load balancer target group runs default target health checks. By default, the health check is run against the service endpoint URL. Optionally, the health check can be performed against a different protocol, port, and/or path using the [CreateService:UrlEndpoint](https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/APIReference/API_CreateService.html#migrationhubrefactorspaces-CreateService-request-UrlEndpoint) parameter. All other health check settings for the load balancer use the default values described in the [Health checks for your target groups](https://docs.aws.amazon.com/elasticloadbalancing/latest/application/target-group-health-checks.html) in the *Elastic Load Balancing guide*. The health check is considered successful if at least one target within the target group transitions to a healthy state.
 * + **Lambda function endpoints**If the service has an Lambda function endpoint, then Refactor Spaces configures the Lambda function's resource policy to allow the application's API Gateway to invoke the function.The Lambda function state is checked. If the function is not active, the function configuration is updated so that Lambda resources are provisioned. If the Lambda state is `Failed`, then the route creation fails. For more information, see the [GetFunctionConfiguration's State response parameter](https://docs.aws.amazon.com/lambda/latest/dg/API_GetFunctionConfiguration.html#SSS-GetFunctionConfiguration-response-State) in the *Lambda Developer Guide*.A check is performed to determine that a Lambda function with the specified ARN exists. If it does not exist, the health check fails. For public URLs, a connection is opened to the public endpoint. If the URL is not reachable, the health check fails.
 *
 * **Environments without a network bridge**
 *
 * When you create environments without a network bridge ([CreateEnvironment:NetworkFabricType](https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/APIReference/API_CreateEnvironment.html#migrationhubrefactorspaces-CreateEnvironment-request-NetworkFabricType) is `NONE)` and you use your own networking infrastructure, you need to configure [VPC to VPC connectivity](https://docs.aws.amazon.com/whitepapers/latest/aws-vpc-connectivity-options/amazon-vpc-to-amazon-vpc-connectivity-options.html) between your network and the application proxy VPC. Route creation from the application proxy to service endpoints will fail if your network is not configured to connect to the application proxy VPC. For more information, see [ Create a route](https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/userguide/getting-started-create-role.html) in the *Refactor Spaces User Guide*.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.createRoute(crossinline block: CreateRouteRequest.Builder.() -> Unit): CreateRouteResponse = createRoute(CreateRouteRequest.Builder().apply(block).build())

/**
 * Creates an Amazon Web Services Migration Hub Refactor Spaces service. The account owner of the service is always the environment owner, regardless of which account in the environment creates the service. Services have either a URL endpoint in a virtual private cloud (VPC), or a Lambda function endpoint.
 *
 * If an Amazon Web Services resource is launched in a service VPC, and you want it to be accessible to all of an environment’s services with VPCs and routes, apply the `RefactorSpacesSecurityGroup` to the resource. Alternatively, to add more cross-account constraints, apply your own security group.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.createService(crossinline block: CreateServiceRequest.Builder.() -> Unit): CreateServiceResponse = createService(CreateServiceRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Web Services Migration Hub Refactor Spaces application. Before you can delete an application, you must first delete any services or routes within the application.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.deleteApplication(crossinline block: DeleteApplicationRequest.Builder.() -> Unit): DeleteApplicationResponse = deleteApplication(DeleteApplicationRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Web Services Migration Hub Refactor Spaces environment. Before you can delete an environment, you must first delete any applications and services within the environment.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.deleteEnvironment(crossinline block: DeleteEnvironmentRequest.Builder.() -> Unit): DeleteEnvironmentResponse = deleteEnvironment(DeleteEnvironmentRequest.Builder().apply(block).build())

/**
 * Deletes the resource policy set for the environment.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.deleteResourcePolicy(crossinline block: DeleteResourcePolicyRequest.Builder.() -> Unit): DeleteResourcePolicyResponse = deleteResourcePolicy(DeleteResourcePolicyRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Web Services Migration Hub Refactor Spaces route.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.deleteRoute(crossinline block: DeleteRouteRequest.Builder.() -> Unit): DeleteRouteResponse = deleteRoute(DeleteRouteRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Web Services Migration Hub Refactor Spaces service.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.deleteService(crossinline block: DeleteServiceRequest.Builder.() -> Unit): DeleteServiceResponse = deleteService(DeleteServiceRequest.Builder().apply(block).build())

/**
 * Gets an Amazon Web Services Migration Hub Refactor Spaces application.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.getApplication(crossinline block: GetApplicationRequest.Builder.() -> Unit): GetApplicationResponse = getApplication(GetApplicationRequest.Builder().apply(block).build())

/**
 * Gets an Amazon Web Services Migration Hub Refactor Spaces environment.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.getEnvironment(crossinline block: GetEnvironmentRequest.Builder.() -> Unit): GetEnvironmentResponse = getEnvironment(GetEnvironmentRequest.Builder().apply(block).build())

/**
 * Gets the resource-based permission policy that is set for the given environment.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.getResourcePolicy(crossinline block: GetResourcePolicyRequest.Builder.() -> Unit): GetResourcePolicyResponse = getResourcePolicy(GetResourcePolicyRequest.Builder().apply(block).build())

/**
 * Gets an Amazon Web Services Migration Hub Refactor Spaces route.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.getRoute(crossinline block: GetRouteRequest.Builder.() -> Unit): GetRouteResponse = getRoute(GetRouteRequest.Builder().apply(block).build())

/**
 * Gets an Amazon Web Services Migration Hub Refactor Spaces service.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.getService(crossinline block: GetServiceRequest.Builder.() -> Unit): GetServiceResponse = getService(GetServiceRequest.Builder().apply(block).build())

/**
 * Lists all the Amazon Web Services Migration Hub Refactor Spaces applications within an environment.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.listApplications(crossinline block: ListApplicationsRequest.Builder.() -> Unit): ListApplicationsResponse = listApplications(ListApplicationsRequest.Builder().apply(block).build())

/**
 * Lists all Amazon Web Services Migration Hub Refactor Spaces service virtual private clouds (VPCs) that are part of the environment.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.listEnvironmentVpcs(crossinline block: ListEnvironmentVpcsRequest.Builder.() -> Unit): ListEnvironmentVpcsResponse = listEnvironmentVpcs(ListEnvironmentVpcsRequest.Builder().apply(block).build())

/**
 * Lists Amazon Web Services Migration Hub Refactor Spaces environments owned by a caller account or shared with the caller account.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.listEnvironments(crossinline block: ListEnvironmentsRequest.Builder.() -> Unit): ListEnvironmentsResponse = listEnvironments(ListEnvironmentsRequest.Builder().apply(block).build())

/**
 * Lists all the Amazon Web Services Migration Hub Refactor Spaces routes within an application.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.listRoutes(crossinline block: ListRoutesRequest.Builder.() -> Unit): ListRoutesResponse = listRoutes(ListRoutesRequest.Builder().apply(block).build())

/**
 * Lists all the Amazon Web Services Migration Hub Refactor Spaces services within an application.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.listServices(crossinline block: ListServicesRequest.Builder.() -> Unit): ListServicesResponse = listServices(ListServicesRequest.Builder().apply(block).build())

/**
 * Lists the tags of a resource. The caller account must be the same as the resource’s `OwnerAccountId`. Listing tags in other accounts is not supported.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Attaches a resource-based permission policy to the Amazon Web Services Migration Hub Refactor Spaces environment. The policy must contain the same actions and condition statements as the `arn:aws:ram::aws:permission/AWSRAMDefaultPermissionRefactorSpacesEnvironment` permission in Resource Access Manager. The policy must not contain new lines or blank lines.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.putResourcePolicy(crossinline block: PutResourcePolicyRequest.Builder.() -> Unit): PutResourcePolicyResponse = putResourcePolicy(PutResourcePolicyRequest.Builder().apply(block).build())

/**
 * Removes the tags of a given resource. Tags are metadata which can be used to manage a resource. To tag a resource, the caller account must be the same as the resource’s `OwnerAccountId`. Tagging resources in other accounts is not supported.
 *
 * Amazon Web Services Migration Hub Refactor Spaces does not propagate tags to orchestrated resources, such as an environment’s transit gateway.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Adds to or modifies the tags of the given resource. Tags are metadata which can be used to manage a resource. To untag a resource, the caller account must be the same as the resource’s `OwnerAccountId`. Untagging resources across accounts is not supported.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an Amazon Web Services Migration Hub Refactor Spaces route.
 */
public suspend inline fun MigrationHubRefactorSpacesClient.updateRoute(crossinline block: UpdateRouteRequest.Builder.() -> Unit): UpdateRouteResponse = updateRoute(UpdateRouteRequest.Builder().apply(block).build())
