// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhubrefactorspaces.serde

import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ErrorResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.GetServiceResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.LambdaEndpointConfig
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.MigrationHubRefactorSpacesException
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ServiceEndpointType
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ServiceState
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UrlEndpointConfig
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableMapOf


internal class GetServiceOperationDeserializer: HttpDeserialize<GetServiceResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetServiceResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetServiceError(context, call)
        }
        val builder = GetServiceResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetServiceOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetServiceError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MigrationHubRefactorSpacesException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        else -> MigrationHubRefactorSpacesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetServiceOperationBody(builder: GetServiceResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPLICATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ApplicationId"))
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val CREATEDBYACCOUNTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CreatedByAccountId"))
    val CREATEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val ENDPOINTTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EndpointType"))
    val ENVIRONMENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EnvironmentId"))
    val ERROR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Error"))
    val LAMBDAENDPOINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("LambdaEndpoint"))
    val LASTUPDATEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastUpdatedTime"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val OWNERACCOUNTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OwnerAccountId"))
    val SERVICEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ServiceId"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("State"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val URLENDPOINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("UrlEndpoint"))
    val VPCID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("VpcId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPLICATIONID_DESCRIPTOR)
        field(ARN_DESCRIPTOR)
        field(CREATEDBYACCOUNTID_DESCRIPTOR)
        field(CREATEDTIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENDPOINTTYPE_DESCRIPTOR)
        field(ENVIRONMENTID_DESCRIPTOR)
        field(ERROR_DESCRIPTOR)
        field(LAMBDAENDPOINT_DESCRIPTOR)
        field(LASTUPDATEDTIME_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(OWNERACCOUNTID_DESCRIPTOR)
        field(SERVICEID_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(URLENDPOINT_DESCRIPTOR)
        field(VPCID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPLICATIONID_DESCRIPTOR.index -> builder.applicationId = deserializeString()
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CREATEDBYACCOUNTID_DESCRIPTOR.index -> builder.createdByAccountId = deserializeString()
                CREATEDTIME_DESCRIPTOR.index -> builder.createdTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ENDPOINTTYPE_DESCRIPTOR.index -> builder.endpointType = deserializeString().let { ServiceEndpointType.fromValue(it) }
                ENVIRONMENTID_DESCRIPTOR.index -> builder.environmentId = deserializeString()
                ERROR_DESCRIPTOR.index -> builder.error = deserializeErrorResponseDocument(deserializer)
                LAMBDAENDPOINT_DESCRIPTOR.index -> builder.lambdaEndpoint = deserializeLambdaEndpointConfigDocument(deserializer)
                LASTUPDATEDTIME_DESCRIPTOR.index -> builder.lastUpdatedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                OWNERACCOUNTID_DESCRIPTOR.index -> builder.ownerAccountId = deserializeString()
                SERVICEID_DESCRIPTOR.index -> builder.serviceId = deserializeString()
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { ServiceState.fromValue(it) }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                URLENDPOINT_DESCRIPTOR.index -> builder.urlEndpoint = deserializeUrlEndpointConfigDocument(deserializer)
                VPCID_DESCRIPTOR.index -> builder.vpcId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
