// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhubrefactorspaces.serde

import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ErrorResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.GetRouteResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.HttpMethod
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.MigrationHubRefactorSpacesException
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.RouteState
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.RouteType
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetRouteOperationDeserializer: HttpDeserialize<GetRouteResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetRouteResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetRouteError(context, call)
        }
        val builder = GetRouteResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetRouteOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetRouteError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MigrationHubRefactorSpacesException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        else -> MigrationHubRefactorSpacesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetRouteOperationBody(builder: GetRouteResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPENDSOURCEPATH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("AppendSourcePath"))
    val APPLICATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ApplicationId"))
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val CREATEDBYACCOUNTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CreatedByAccountId"))
    val CREATEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreatedTime"))
    val ENVIRONMENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EnvironmentId"))
    val ERROR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Error"))
    val INCLUDECHILDPATHS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("IncludeChildPaths"))
    val LASTUPDATEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastUpdatedTime"))
    val METHODS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Methods"))
    val OWNERACCOUNTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OwnerAccountId"))
    val PATHRESOURCETOID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("PathResourceToId"))
    val ROUTEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RouteId"))
    val ROUTETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RouteType"))
    val SERVICEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ServiceId"))
    val SOURCEPATH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SourcePath"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("State"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("Tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPENDSOURCEPATH_DESCRIPTOR)
        field(APPLICATIONID_DESCRIPTOR)
        field(ARN_DESCRIPTOR)
        field(CREATEDBYACCOUNTID_DESCRIPTOR)
        field(CREATEDTIME_DESCRIPTOR)
        field(ENVIRONMENTID_DESCRIPTOR)
        field(ERROR_DESCRIPTOR)
        field(INCLUDECHILDPATHS_DESCRIPTOR)
        field(LASTUPDATEDTIME_DESCRIPTOR)
        field(METHODS_DESCRIPTOR)
        field(OWNERACCOUNTID_DESCRIPTOR)
        field(PATHRESOURCETOID_DESCRIPTOR)
        field(ROUTEID_DESCRIPTOR)
        field(ROUTETYPE_DESCRIPTOR)
        field(SERVICEID_DESCRIPTOR)
        field(SOURCEPATH_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPENDSOURCEPATH_DESCRIPTOR.index -> builder.appendSourcePath = deserializeBoolean()
                APPLICATIONID_DESCRIPTOR.index -> builder.applicationId = deserializeString()
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CREATEDBYACCOUNTID_DESCRIPTOR.index -> builder.createdByAccountId = deserializeString()
                CREATEDTIME_DESCRIPTOR.index -> builder.createdTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                ENVIRONMENTID_DESCRIPTOR.index -> builder.environmentId = deserializeString()
                ERROR_DESCRIPTOR.index -> builder.error = deserializeErrorResponseDocument(deserializer)
                INCLUDECHILDPATHS_DESCRIPTOR.index -> builder.includeChildPaths = deserializeBoolean()
                LASTUPDATEDTIME_DESCRIPTOR.index -> builder.lastUpdatedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                METHODS_DESCRIPTOR.index -> builder.methods =
                    deserializer.deserializeList(METHODS_DESCRIPTOR) {
                        val col0 = mutableListOf<HttpMethod>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString().let { HttpMethod.fromValue(it) } } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                OWNERACCOUNTID_DESCRIPTOR.index -> builder.ownerAccountId = deserializeString()
                PATHRESOURCETOID_DESCRIPTOR.index -> builder.pathResourceToId =
                    deserializer.deserializeMap(PATHRESOURCETOID_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                ROUTEID_DESCRIPTOR.index -> builder.routeId = deserializeString()
                ROUTETYPE_DESCRIPTOR.index -> builder.routeType = deserializeString().let { RouteType.fromValue(it) }
                SERVICEID_DESCRIPTOR.index -> builder.serviceId = deserializeString()
                SOURCEPATH_DESCRIPTOR.index -> builder.sourcePath = deserializeString()
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { RouteState.fromValue(it) }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
