// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhubrefactorspaces.serde

import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ApplicationState
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.DeleteApplicationResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.MigrationHubRefactorSpacesException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DeleteApplicationOperationDeserializer: HttpDeserialize<DeleteApplicationResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DeleteApplicationResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteApplicationError(context, call)
        }
        val builder = DeleteApplicationResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteApplicationOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDeleteApplicationError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MigrationHubRefactorSpacesException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall)
        else -> MigrationHubRefactorSpacesException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteApplicationOperationBody(builder: DeleteApplicationResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPLICATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ApplicationId"))
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val ENVIRONMENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EnvironmentId"))
    val LASTUPDATEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LastUpdatedTime"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val STATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("State"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPLICATIONID_DESCRIPTOR)
        field(ARN_DESCRIPTOR)
        field(ENVIRONMENTID_DESCRIPTOR)
        field(LASTUPDATEDTIME_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(STATE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPLICATIONID_DESCRIPTOR.index -> builder.applicationId = deserializeString()
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                ENVIRONMENTID_DESCRIPTOR.index -> builder.environmentId = deserializeString()
                LASTUPDATEDTIME_DESCRIPTOR.index -> builder.lastUpdatedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                STATE_DESCRIPTOR.index -> builder.state = deserializeString().let { ApplicationState.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
