// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhubrefactorspaces.paginators

import aws.sdk.kotlin.services.migrationhubrefactorspaces.MigrationHubRefactorSpacesClient
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ApplicationSummary
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.EnvironmentSummary
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.EnvironmentVpc
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ListApplicationsRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ListApplicationsResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ListEnvironmentVpcsRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ListEnvironmentVpcsResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ListEnvironmentsRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ListEnvironmentsResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ListRoutesRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ListRoutesResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ListServicesRequest
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ListServicesResponse
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.RouteSummary
import aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ServiceSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListApplicationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListApplicationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationsResponse]
 */
public fun MigrationHubRefactorSpacesClient.listApplicationsPaginated(initialRequest: ListApplicationsRequest): Flow<ListApplicationsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listApplicationsPaginated.listApplications(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListApplicationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationsResponse]
 */
public fun MigrationHubRefactorSpacesClient.listApplicationsPaginated(block: ListApplicationsRequest.Builder.() -> Unit): Flow<ListApplicationsResponse> =
    listApplicationsPaginated(ListApplicationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listApplicationsPaginated]
 * to access the nested member [ApplicationSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ApplicationSummary]
 */
@JvmName("listApplicationsResponseApplicationSummary")
public fun Flow<ListApplicationsResponse>.applicationSummaryList(): Flow<ApplicationSummary> =
    transform() { response ->
        response.applicationSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListEnvironmentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEnvironmentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEnvironmentsResponse]
 */
public fun MigrationHubRefactorSpacesClient.listEnvironmentsPaginated(initialRequest: ListEnvironmentsRequest = ListEnvironmentsRequest { }): Flow<ListEnvironmentsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEnvironmentsPaginated.listEnvironments(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListEnvironmentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEnvironmentsResponse]
 */
public fun MigrationHubRefactorSpacesClient.listEnvironmentsPaginated(block: ListEnvironmentsRequest.Builder.() -> Unit): Flow<ListEnvironmentsResponse> =
    listEnvironmentsPaginated(ListEnvironmentsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listEnvironmentsPaginated]
 * to access the nested member [EnvironmentSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EnvironmentSummary]
 */
@JvmName("listEnvironmentsResponseEnvironmentSummary")
public fun Flow<ListEnvironmentsResponse>.environmentSummaryList(): Flow<EnvironmentSummary> =
    transform() { response ->
        response.environmentSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListEnvironmentVpcsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEnvironmentVpcsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEnvironmentVpcsResponse]
 */
public fun MigrationHubRefactorSpacesClient.listEnvironmentVpcsPaginated(initialRequest: ListEnvironmentVpcsRequest): Flow<ListEnvironmentVpcsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEnvironmentVpcsPaginated.listEnvironmentVpcs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListEnvironmentVpcsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEnvironmentVpcsResponse]
 */
public fun MigrationHubRefactorSpacesClient.listEnvironmentVpcsPaginated(block: ListEnvironmentVpcsRequest.Builder.() -> Unit): Flow<ListEnvironmentVpcsResponse> =
    listEnvironmentVpcsPaginated(ListEnvironmentVpcsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listEnvironmentVpcsPaginated]
 * to access the nested member [EnvironmentVpc]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EnvironmentVpc]
 */
@JvmName("listEnvironmentVpcsResponseEnvironmentVpc")
public fun Flow<ListEnvironmentVpcsResponse>.environmentVpcList(): Flow<EnvironmentVpc> =
    transform() { response ->
        response.environmentVpcList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListRoutesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListRoutesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRoutesResponse]
 */
public fun MigrationHubRefactorSpacesClient.listRoutesPaginated(initialRequest: ListRoutesRequest): Flow<ListRoutesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listRoutesPaginated.listRoutes(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListRoutesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListRoutesResponse]
 */
public fun MigrationHubRefactorSpacesClient.listRoutesPaginated(block: ListRoutesRequest.Builder.() -> Unit): Flow<ListRoutesResponse> =
    listRoutesPaginated(ListRoutesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listRoutesPaginated]
 * to access the nested member [RouteSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [RouteSummary]
 */
@JvmName("listRoutesResponseRouteSummary")
public fun Flow<ListRoutesResponse>.routeSummaryList(): Flow<RouteSummary> =
    transform() { response ->
        response.routeSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListServicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListServicesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServicesResponse]
 */
public fun MigrationHubRefactorSpacesClient.listServicesPaginated(initialRequest: ListServicesRequest): Flow<ListServicesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listServicesPaginated.listServices(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListServicesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListServicesResponse]
 */
public fun MigrationHubRefactorSpacesClient.listServicesPaginated(block: ListServicesRequest.Builder.() -> Unit): Flow<ListServicesResponse> =
    listServicesPaginated(ListServicesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listServicesPaginated]
 * to access the nested member [ServiceSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ServiceSummary]
 */
@JvmName("listServicesResponseServiceSummary")
public fun Flow<ListServicesResponse>.serviceSummaryList(): Flow<ServiceSummary> =
    transform() { response ->
        response.serviceSummaryList?.forEach {
            emit(it)
        }
    }
