// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhubrefactorspaces.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A summary for the service as a response to `ListServices`.
 */
public class ServiceSummary private constructor(builder: Builder) {
    /**
     * The unique identifier of the application.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * The Amazon Resource Name (ARN) of the service.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The Amazon Web Services account ID of the service creator.
     */
    public val createdByAccountId: kotlin.String? = builder.createdByAccountId
    /**
     * A timestamp that indicates when the service is created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * A description of the service.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The endpoint type of the service.
     */
    public val endpointType: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ServiceEndpointType? = builder.endpointType
    /**
     * The unique identifier of the environment.
     */
    public val environmentId: kotlin.String? = builder.environmentId
    /**
     * Any error associated with the service resource.
     */
    public val error: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ErrorResponse? = builder.error
    /**
     * A summary of the configuration for the Lambda endpoint type.
     */
    public val lambdaEndpoint: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.LambdaEndpointSummary? = builder.lambdaEndpoint
    /**
     * A timestamp that indicates when the service was last updated.
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTime
    /**
     * The name of the service.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Web Services account ID of the service owner.
     */
    public val ownerAccountId: kotlin.String? = builder.ownerAccountId
    /**
     * The unique identifier of the service.
     */
    public val serviceId: kotlin.String? = builder.serviceId
    /**
     * The current state of the service.
     */
    public val state: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ServiceState? = builder.state
    /**
     * The tags assigned to the service.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The summary of the configuration for the URL endpoint type.
     */
    public val urlEndpoint: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UrlEndpointSummary? = builder.urlEndpoint
    /**
     * The ID of the virtual private cloud (VPC).
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ServiceSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServiceSummary(")
        append("applicationId=$applicationId,")
        append("arn=$arn,")
        append("createdByAccountId=$createdByAccountId,")
        append("createdTime=$createdTime,")
        append("description=$description,")
        append("endpointType=$endpointType,")
        append("environmentId=$environmentId,")
        append("error=$error,")
        append("lambdaEndpoint=$lambdaEndpoint,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("name=$name,")
        append("ownerAccountId=$ownerAccountId,")
        append("serviceId=$serviceId,")
        append("state=$state,")
        append("tags=*** Sensitive Data Redacted ***,")
        append("urlEndpoint=$urlEndpoint,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (createdByAccountId?.hashCode() ?: 0)
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (endpointType?.hashCode() ?: 0)
        result = 31 * result + (environmentId?.hashCode() ?: 0)
        result = 31 * result + (error?.hashCode() ?: 0)
        result = 31 * result + (lambdaEndpoint?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (ownerAccountId?.hashCode() ?: 0)
        result = 31 * result + (serviceId?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (urlEndpoint?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServiceSummary

        if (applicationId != other.applicationId) return false
        if (arn != other.arn) return false
        if (createdByAccountId != other.createdByAccountId) return false
        if (createdTime != other.createdTime) return false
        if (description != other.description) return false
        if (endpointType != other.endpointType) return false
        if (environmentId != other.environmentId) return false
        if (error != other.error) return false
        if (lambdaEndpoint != other.lambdaEndpoint) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (name != other.name) return false
        if (ownerAccountId != other.ownerAccountId) return false
        if (serviceId != other.serviceId) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (urlEndpoint != other.urlEndpoint) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ServiceSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique identifier of the application.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the service.
         */
        public var arn: kotlin.String? = null
        /**
         * The Amazon Web Services account ID of the service creator.
         */
        public var createdByAccountId: kotlin.String? = null
        /**
         * A timestamp that indicates when the service is created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A description of the service.
         */
        public var description: kotlin.String? = null
        /**
         * The endpoint type of the service.
         */
        public var endpointType: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ServiceEndpointType? = null
        /**
         * The unique identifier of the environment.
         */
        public var environmentId: kotlin.String? = null
        /**
         * Any error associated with the service resource.
         */
        public var error: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ErrorResponse? = null
        /**
         * A summary of the configuration for the Lambda endpoint type.
         */
        public var lambdaEndpoint: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.LambdaEndpointSummary? = null
        /**
         * A timestamp that indicates when the service was last updated.
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the service.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Web Services account ID of the service owner.
         */
        public var ownerAccountId: kotlin.String? = null
        /**
         * The unique identifier of the service.
         */
        public var serviceId: kotlin.String? = null
        /**
         * The current state of the service.
         */
        public var state: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ServiceState? = null
        /**
         * The tags assigned to the service.
         */
        public var tags: Map<String, String>? = null
        /**
         * The summary of the configuration for the URL endpoint type.
         */
        public var urlEndpoint: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UrlEndpointSummary? = null
        /**
         * The ID of the virtual private cloud (VPC).
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ServiceSummary) : this() {
            this.applicationId = x.applicationId
            this.arn = x.arn
            this.createdByAccountId = x.createdByAccountId
            this.createdTime = x.createdTime
            this.description = x.description
            this.endpointType = x.endpointType
            this.environmentId = x.environmentId
            this.error = x.error
            this.lambdaEndpoint = x.lambdaEndpoint
            this.lastUpdatedTime = x.lastUpdatedTime
            this.name = x.name
            this.ownerAccountId = x.ownerAccountId
            this.serviceId = x.serviceId
            this.state = x.state
            this.tags = x.tags
            this.urlEndpoint = x.urlEndpoint
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ServiceSummary = ServiceSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ErrorResponse] inside the given [block]
         */
        public fun error(block: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ErrorResponse.Builder.() -> kotlin.Unit) {
            this.error = aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ErrorResponse.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.migrationhubrefactorspaces.model.LambdaEndpointSummary] inside the given [block]
         */
        public fun lambdaEndpoint(block: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.LambdaEndpointSummary.Builder.() -> kotlin.Unit) {
            this.lambdaEndpoint = aws.sdk.kotlin.services.migrationhubrefactorspaces.model.LambdaEndpointSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UrlEndpointSummary] inside the given [block]
         */
        public fun urlEndpoint(block: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UrlEndpointSummary.Builder.() -> kotlin.Unit) {
            this.urlEndpoint = aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UrlEndpointSummary.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
