// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhubrefactorspaces.model

import aws.smithy.kotlin.runtime.time.Instant

public class CreateRouteResponse private constructor(builder: Builder) {
    /**
     * The ID of the application in which the route is created.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * The Amazon Resource Name (ARN) of the route. The format for this ARN is `arn:aws:refactor-spaces:<i>region</i>:<i>account-id</i>:<i>resource-type/resource-id</i> `. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The Amazon Web Services account ID of the route creator.
     */
    public val createdByAccountId: kotlin.String? = builder.createdByAccountId
    /**
     * A timestamp that indicates when the route is created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * A timestamp that indicates when the route was last updated.
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTime
    /**
     * The Amazon Web Services account ID of the route owner.
     */
    public val ownerAccountId: kotlin.String? = builder.ownerAccountId
    /**
     * The unique identifier of the route.
     */
    public val routeId: kotlin.String? = builder.routeId
    /**
     * The route type of the route.
     */
    public val routeType: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.RouteType? = builder.routeType
    /**
     * The ID of service in which the route is created. Traffic that matches this route is forwarded to this service.
     */
    public val serviceId: kotlin.String? = builder.serviceId
    /**
     * The current state of the route. Activation state only allows `ACTIVE` or `INACTIVE` as user inputs. `FAILED` is a route state that is system generated.
     */
    public val state: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.RouteState? = builder.state
    /**
     * The tags assigned to the created route. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * Configuration for the URI path route type.
     */
    public val uriPathRoute: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UriPathRouteInput? = builder.uriPathRoute

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateRouteResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateRouteResponse(")
        append("applicationId=$applicationId,")
        append("arn=$arn,")
        append("createdByAccountId=$createdByAccountId,")
        append("createdTime=$createdTime,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("ownerAccountId=$ownerAccountId,")
        append("routeId=$routeId,")
        append("routeType=$routeType,")
        append("serviceId=$serviceId,")
        append("state=$state,")
        append("tags=*** Sensitive Data Redacted ***,")
        append("uriPathRoute=$uriPathRoute")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = applicationId?.hashCode() ?: 0
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (createdByAccountId?.hashCode() ?: 0)
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (ownerAccountId?.hashCode() ?: 0)
        result = 31 * result + (routeId?.hashCode() ?: 0)
        result = 31 * result + (routeType?.hashCode() ?: 0)
        result = 31 * result + (serviceId?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (uriPathRoute?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateRouteResponse

        if (applicationId != other.applicationId) return false
        if (arn != other.arn) return false
        if (createdByAccountId != other.createdByAccountId) return false
        if (createdTime != other.createdTime) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (ownerAccountId != other.ownerAccountId) return false
        if (routeId != other.routeId) return false
        if (routeType != other.routeType) return false
        if (serviceId != other.serviceId) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (uriPathRoute != other.uriPathRoute) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateRouteResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The ID of the application in which the route is created.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the route. The format for this ARN is `arn:aws:refactor-spaces:<i>region</i>:<i>account-id</i>:<i>resource-type/resource-id</i> `. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
         */
        public var arn: kotlin.String? = null
        /**
         * The Amazon Web Services account ID of the route creator.
         */
        public var createdByAccountId: kotlin.String? = null
        /**
         * A timestamp that indicates when the route is created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A timestamp that indicates when the route was last updated.
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Web Services account ID of the route owner.
         */
        public var ownerAccountId: kotlin.String? = null
        /**
         * The unique identifier of the route.
         */
        public var routeId: kotlin.String? = null
        /**
         * The route type of the route.
         */
        public var routeType: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.RouteType? = null
        /**
         * The ID of service in which the route is created. Traffic that matches this route is forwarded to this service.
         */
        public var serviceId: kotlin.String? = null
        /**
         * The current state of the route. Activation state only allows `ACTIVE` or `INACTIVE` as user inputs. `FAILED` is a route state that is system generated.
         */
        public var state: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.RouteState? = null
        /**
         * The tags assigned to the created route. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.
         */
        public var tags: Map<String, String>? = null
        /**
         * Configuration for the URI path route type.
         */
        public var uriPathRoute: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UriPathRouteInput? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateRouteResponse) : this() {
            this.applicationId = x.applicationId
            this.arn = x.arn
            this.createdByAccountId = x.createdByAccountId
            this.createdTime = x.createdTime
            this.lastUpdatedTime = x.lastUpdatedTime
            this.ownerAccountId = x.ownerAccountId
            this.routeId = x.routeId
            this.routeType = x.routeType
            this.serviceId = x.serviceId
            this.state = x.state
            this.tags = x.tags
            this.uriPathRoute = x.uriPathRoute
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateRouteResponse = CreateRouteResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UriPathRouteInput] inside the given [block]
         */
        public fun uriPathRoute(block: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UriPathRouteInput.Builder.() -> kotlin.Unit) {
            this.uriPathRoute = aws.sdk.kotlin.services.migrationhubrefactorspaces.model.UriPathRouteInput.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
