// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhubrefactorspaces.model

import aws.smithy.kotlin.runtime.time.Instant

public class CreateApplicationResponse private constructor(builder: Builder) {
    /**
     * A wrapper object holding the API Gateway endpoint type and stage name for the proxy.
     */
    public val apiGatewayProxy: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ApiGatewayProxyInput? = builder.apiGatewayProxy
    /**
     * The unique identifier of the application.
     */
    public val applicationId: kotlin.String? = builder.applicationId
    /**
     * The Amazon Resource Name (ARN) of the application. The format for this ARN is `arn:aws:refactor-spaces:<i>region</i>:<i>account-id</i>:<i>resource-type/resource-id</i> `. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The Amazon Web Services account ID of application creator.
     */
    public val createdByAccountId: kotlin.String? = builder.createdByAccountId
    /**
     * A timestamp that indicates when the application is created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The ID of the environment in which the application is created.
     */
    public val environmentId: kotlin.String? = builder.environmentId
    /**
     * A timestamp that indicates when the application was last updated.
     */
    public val lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedTime
    /**
     * The name of the application.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The Amazon Web Services account ID of the application owner (which is always the same as the environment owner account ID).
     */
    public val ownerAccountId: kotlin.String? = builder.ownerAccountId
    /**
     * The proxy type of the proxy created within the application.
     */
    public val proxyType: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ProxyType? = builder.proxyType
    /**
     * The current state of the application.
     */
    public val state: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ApplicationState? = builder.state
    /**
     * The tags assigned to the application. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The ID of the Amazon VPC.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateApplicationResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateApplicationResponse(")
        append("apiGatewayProxy=$apiGatewayProxy,")
        append("applicationId=$applicationId,")
        append("arn=$arn,")
        append("createdByAccountId=$createdByAccountId,")
        append("createdTime=$createdTime,")
        append("environmentId=$environmentId,")
        append("lastUpdatedTime=$lastUpdatedTime,")
        append("name=$name,")
        append("ownerAccountId=$ownerAccountId,")
        append("proxyType=$proxyType,")
        append("state=$state,")
        append("tags=*** Sensitive Data Redacted ***,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiGatewayProxy?.hashCode() ?: 0
        result = 31 * result + (applicationId?.hashCode() ?: 0)
        result = 31 * result + (arn?.hashCode() ?: 0)
        result = 31 * result + (createdByAccountId?.hashCode() ?: 0)
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (environmentId?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (ownerAccountId?.hashCode() ?: 0)
        result = 31 * result + (proxyType?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateApplicationResponse

        if (apiGatewayProxy != other.apiGatewayProxy) return false
        if (applicationId != other.applicationId) return false
        if (arn != other.arn) return false
        if (createdByAccountId != other.createdByAccountId) return false
        if (createdTime != other.createdTime) return false
        if (environmentId != other.environmentId) return false
        if (lastUpdatedTime != other.lastUpdatedTime) return false
        if (name != other.name) return false
        if (ownerAccountId != other.ownerAccountId) return false
        if (proxyType != other.proxyType) return false
        if (state != other.state) return false
        if (tags != other.tags) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateApplicationResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A wrapper object holding the API Gateway endpoint type and stage name for the proxy.
         */
        public var apiGatewayProxy: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ApiGatewayProxyInput? = null
        /**
         * The unique identifier of the application.
         */
        public var applicationId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the application. The format for this ARN is `arn:aws:refactor-spaces:<i>region</i>:<i>account-id</i>:<i>resource-type/resource-id</i> `. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference*.
         */
        public var arn: kotlin.String? = null
        /**
         * The Amazon Web Services account ID of application creator.
         */
        public var createdByAccountId: kotlin.String? = null
        /**
         * A timestamp that indicates when the application is created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The ID of the environment in which the application is created.
         */
        public var environmentId: kotlin.String? = null
        /**
         * A timestamp that indicates when the application was last updated.
         */
        public var lastUpdatedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the application.
         */
        public var name: kotlin.String? = null
        /**
         * The Amazon Web Services account ID of the application owner (which is always the same as the environment owner account ID).
         */
        public var ownerAccountId: kotlin.String? = null
        /**
         * The proxy type of the proxy created within the application.
         */
        public var proxyType: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ProxyType? = null
        /**
         * The current state of the application.
         */
        public var state: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ApplicationState? = null
        /**
         * The tags assigned to the application. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key-value pair.
         */
        public var tags: Map<String, String>? = null
        /**
         * The ID of the Amazon VPC.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateApplicationResponse) : this() {
            this.apiGatewayProxy = x.apiGatewayProxy
            this.applicationId = x.applicationId
            this.arn = x.arn
            this.createdByAccountId = x.createdByAccountId
            this.createdTime = x.createdTime
            this.environmentId = x.environmentId
            this.lastUpdatedTime = x.lastUpdatedTime
            this.name = x.name
            this.ownerAccountId = x.ownerAccountId
            this.proxyType = x.proxyType
            this.state = x.state
            this.tags = x.tags
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.migrationhubrefactorspaces.model.CreateApplicationResponse = CreateApplicationResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ApiGatewayProxyInput] inside the given [block]
         */
        public fun apiGatewayProxy(block: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ApiGatewayProxyInput.Builder.() -> kotlin.Unit) {
            this.apiGatewayProxy = aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ApiGatewayProxyInput.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
