// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhubrefactorspaces.model



/**
 * A wrapper object holding the Amazon API Gateway endpoint input.
 */
public class ApiGatewayProxyInput private constructor(builder: Builder) {
    /**
     * The type of endpoint to use for the API Gateway proxy. If no value is specified in the request, the value is set to `REGIONAL` by default.
     *
     * If the value is set to `PRIVATE` in the request, this creates a private API endpoint that is isolated from the public internet. The private endpoint can only be accessed by using Amazon Virtual Private Cloud (Amazon VPC) interface endpoints for the Amazon API Gateway that has been granted access. For more information about creating a private connection with Refactor Spaces and interface endpoint (Amazon Web Services PrivateLink) availability, see [Access Refactor Spaces using an interface endpoint (Amazon Web Services PrivateLink)](https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/userguide/vpc-interface-endpoints.html).
     */
    public val endpointType: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ApiGatewayEndpointType? = builder.endpointType
    /**
     * The name of the API Gateway stage. The name defaults to `prod`.
     */
    public val stageName: kotlin.String? = builder.stageName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ApiGatewayProxyInput = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ApiGatewayProxyInput(")
        append("endpointType=$endpointType,")
        append("stageName=$stageName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endpointType?.hashCode() ?: 0
        result = 31 * result + (stageName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ApiGatewayProxyInput

        if (endpointType != other.endpointType) return false
        if (stageName != other.stageName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ApiGatewayProxyInput = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The type of endpoint to use for the API Gateway proxy. If no value is specified in the request, the value is set to `REGIONAL` by default.
         *
         * If the value is set to `PRIVATE` in the request, this creates a private API endpoint that is isolated from the public internet. The private endpoint can only be accessed by using Amazon Virtual Private Cloud (Amazon VPC) interface endpoints for the Amazon API Gateway that has been granted access. For more information about creating a private connection with Refactor Spaces and interface endpoint (Amazon Web Services PrivateLink) availability, see [Access Refactor Spaces using an interface endpoint (Amazon Web Services PrivateLink)](https://docs.aws.amazon.com/migrationhub-refactor-spaces/latest/userguide/vpc-interface-endpoints.html).
         */
        public var endpointType: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ApiGatewayEndpointType? = null
        /**
         * The name of the API Gateway stage. The name defaults to `prod`.
         */
        public var stageName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ApiGatewayProxyInput) : this() {
            this.endpointType = x.endpointType
            this.stageName = x.stageName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.migrationhubrefactorspaces.model.ApiGatewayProxyInput = ApiGatewayProxyInput(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
