// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhuborchestrator

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.migrationhuborchestrator.auth.DefaultMigrationHubOrchestratorAuthSchemeProvider
import aws.sdk.kotlin.services.migrationhuborchestrator.auth.MigrationHubOrchestratorAuthSchemeProvider
import aws.sdk.kotlin.services.migrationhuborchestrator.endpoints.DefaultMigrationHubOrchestratorEndpointProvider
import aws.sdk.kotlin.services.migrationhuborchestrator.endpoints.MigrationHubOrchestratorEndpointParameters
import aws.sdk.kotlin.services.migrationhuborchestrator.endpoints.MigrationHubOrchestratorEndpointProvider
import aws.sdk.kotlin.services.migrationhuborchestrator.model.CreateTemplateRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.CreateTemplateResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.CreateWorkflowRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.CreateWorkflowResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.CreateWorkflowStepGroupRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.CreateWorkflowStepGroupResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.CreateWorkflowStepRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.CreateWorkflowStepResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.DeleteTemplateRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.DeleteTemplateResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.DeleteWorkflowRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.DeleteWorkflowResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.DeleteWorkflowStepGroupRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.DeleteWorkflowStepGroupResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.DeleteWorkflowStepRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.DeleteWorkflowStepResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.GetTemplateRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.GetTemplateResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.GetTemplateStepGroupRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.GetTemplateStepGroupResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.GetTemplateStepRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.GetTemplateStepResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.GetWorkflowRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.GetWorkflowResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.GetWorkflowStepGroupRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.GetWorkflowStepGroupResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.GetWorkflowStepRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.GetWorkflowStepResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListPluginsRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListPluginsResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListTemplateStepGroupsRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListTemplateStepGroupsResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListTemplateStepsRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListTemplateStepsResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListTemplatesRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListTemplatesResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListWorkflowStepGroupsRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListWorkflowStepGroupsResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListWorkflowStepsRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListWorkflowStepsResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListWorkflowsRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListWorkflowsResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.RetryWorkflowStepRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.RetryWorkflowStepResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.StartWorkflowRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.StartWorkflowResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.StopWorkflowRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.StopWorkflowResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.TagResourceRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.TagResourceResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.UntagResourceRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.UntagResourceResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.UpdateTemplateRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.UpdateTemplateResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.UpdateWorkflowRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.UpdateWorkflowResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.UpdateWorkflowStepGroupRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.UpdateWorkflowStepGroupResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.UpdateWorkflowStepRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.UpdateWorkflowStepResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "MigrationHubOrchestrator"
public const val SdkVersion: String = "1.5.65"
public const val ServiceApiVersion: String = "2021-08-28"

/**
 * This API reference provides descriptions, syntax, and other details about each of the actions and data types for AWS Migration Hub Orchestrator. The topic for each action shows the API request parameters and responses. Alternatively, you can use one of the AWS SDKs to access an API that is tailored to the programming language or platform that you're using.
 */
public interface MigrationHubOrchestratorClient : SdkClient {
    /**
     * MigrationHubOrchestratorClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, MigrationHubOrchestratorClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "MigrationHubOrchestrator",
                "MIGRATIONHUBORCHESTRATOR",
                "migrationhuborchestrator",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, MigrationHubOrchestratorClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): MigrationHubOrchestratorClient = DefaultMigrationHubOrchestratorClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: MigrationHubOrchestratorEndpointProvider = builder.endpointProvider ?: DefaultMigrationHubOrchestratorEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: MigrationHubOrchestratorAuthSchemeProvider = builder.authSchemeProvider ?: DefaultMigrationHubOrchestratorAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "MigrationHubOrchestrator"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: MigrationHubOrchestratorEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: MigrationHubOrchestratorAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a migration workflow template.
     */
    public suspend fun createTemplate(input: CreateTemplateRequest): CreateTemplateResponse

    /**
     * Create a workflow to orchestrate your migrations.
     */
    public suspend fun createWorkflow(input: CreateWorkflowRequest): CreateWorkflowResponse

    /**
     * Create a step in the migration workflow.
     */
    public suspend fun createWorkflowStep(input: CreateWorkflowStepRequest): CreateWorkflowStepResponse

    /**
     * Create a step group in a migration workflow.
     */
    public suspend fun createWorkflowStepGroup(input: CreateWorkflowStepGroupRequest): CreateWorkflowStepGroupResponse

    /**
     * Deletes a migration workflow template.
     */
    public suspend fun deleteTemplate(input: DeleteTemplateRequest): DeleteTemplateResponse

    /**
     * Delete a migration workflow. You must pause a running workflow in Migration Hub Orchestrator console to delete it.
     */
    public suspend fun deleteWorkflow(input: DeleteWorkflowRequest): DeleteWorkflowResponse

    /**
     * Delete a step in a migration workflow. Pause the workflow to delete a running step.
     */
    public suspend fun deleteWorkflowStep(input: DeleteWorkflowStepRequest): DeleteWorkflowStepResponse

    /**
     * Delete a step group in a migration workflow.
     */
    public suspend fun deleteWorkflowStepGroup(input: DeleteWorkflowStepGroupRequest): DeleteWorkflowStepGroupResponse

    /**
     * Get the template you want to use for creating a migration workflow.
     */
    public suspend fun getTemplate(input: GetTemplateRequest): GetTemplateResponse

    /**
     * Get a specific step in a template.
     */
    public suspend fun getTemplateStep(input: GetTemplateStepRequest): GetTemplateStepResponse

    /**
     * Get a step group in a template.
     */
    public suspend fun getTemplateStepGroup(input: GetTemplateStepGroupRequest): GetTemplateStepGroupResponse

    /**
     * Get migration workflow.
     */
    public suspend fun getWorkflow(input: GetWorkflowRequest): GetWorkflowResponse

    /**
     * Get a step in the migration workflow.
     */
    public suspend fun getWorkflowStep(input: GetWorkflowStepRequest): GetWorkflowStepResponse

    /**
     * Get the step group of a migration workflow.
     */
    public suspend fun getWorkflowStepGroup(input: GetWorkflowStepGroupRequest): GetWorkflowStepGroupResponse

    /**
     * List AWS Migration Hub Orchestrator plugins.
     */
    public suspend fun listPlugins(input: ListPluginsRequest = ListPluginsRequest { }): ListPluginsResponse

    /**
     * List the tags added to a resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * List the step groups in a template.
     */
    public suspend fun listTemplateStepGroups(input: ListTemplateStepGroupsRequest): ListTemplateStepGroupsResponse

    /**
     * List the steps in a template.
     */
    public suspend fun listTemplateSteps(input: ListTemplateStepsRequest): ListTemplateStepsResponse

    /**
     * List the templates available in Migration Hub Orchestrator to create a migration workflow.
     */
    public suspend fun listTemplates(input: ListTemplatesRequest = ListTemplatesRequest { }): ListTemplatesResponse

    /**
     * List the step groups in a migration workflow.
     */
    public suspend fun listWorkflowStepGroups(input: ListWorkflowStepGroupsRequest): ListWorkflowStepGroupsResponse

    /**
     * List the steps in a workflow.
     */
    public suspend fun listWorkflowSteps(input: ListWorkflowStepsRequest): ListWorkflowStepsResponse

    /**
     * List the migration workflows.
     */
    public suspend fun listWorkflows(input: ListWorkflowsRequest = ListWorkflowsRequest { }): ListWorkflowsResponse

    /**
     * Retry a failed step in a migration workflow.
     */
    public suspend fun retryWorkflowStep(input: RetryWorkflowStepRequest): RetryWorkflowStepResponse

    /**
     * Start a migration workflow.
     */
    public suspend fun startWorkflow(input: StartWorkflowRequest): StartWorkflowResponse

    /**
     * Stop an ongoing migration workflow.
     */
    public suspend fun stopWorkflow(input: StopWorkflowRequest): StopWorkflowResponse

    /**
     * Tag a resource by specifying its Amazon Resource Name (ARN).
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Deletes the tags for a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates a migration workflow template.
     */
    public suspend fun updateTemplate(input: UpdateTemplateRequest): UpdateTemplateResponse

    /**
     * Update a migration workflow.
     */
    public suspend fun updateWorkflow(input: UpdateWorkflowRequest): UpdateWorkflowResponse

    /**
     * Update a step in a migration workflow.
     */
    public suspend fun updateWorkflowStep(input: UpdateWorkflowStepRequest): UpdateWorkflowStepResponse

    /**
     * Update the step group in a migration workflow.
     */
    public suspend fun updateWorkflowStepGroup(input: UpdateWorkflowStepGroupRequest): UpdateWorkflowStepGroupResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun MigrationHubOrchestratorClient.withConfig(block: MigrationHubOrchestratorClient.Config.Builder.() -> Unit): MigrationHubOrchestratorClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultMigrationHubOrchestratorClient(newConfig)
}

/**
 * Creates a migration workflow template.
 */
public suspend inline fun MigrationHubOrchestratorClient.createTemplate(crossinline block: CreateTemplateRequest.Builder.() -> Unit): CreateTemplateResponse = createTemplate(CreateTemplateRequest.Builder().apply(block).build())

/**
 * Create a workflow to orchestrate your migrations.
 */
public suspend inline fun MigrationHubOrchestratorClient.createWorkflow(crossinline block: CreateWorkflowRequest.Builder.() -> Unit): CreateWorkflowResponse = createWorkflow(CreateWorkflowRequest.Builder().apply(block).build())

/**
 * Create a step in the migration workflow.
 */
public suspend inline fun MigrationHubOrchestratorClient.createWorkflowStep(crossinline block: CreateWorkflowStepRequest.Builder.() -> Unit): CreateWorkflowStepResponse = createWorkflowStep(CreateWorkflowStepRequest.Builder().apply(block).build())

/**
 * Create a step group in a migration workflow.
 */
public suspend inline fun MigrationHubOrchestratorClient.createWorkflowStepGroup(crossinline block: CreateWorkflowStepGroupRequest.Builder.() -> Unit): CreateWorkflowStepGroupResponse = createWorkflowStepGroup(CreateWorkflowStepGroupRequest.Builder().apply(block).build())

/**
 * Deletes a migration workflow template.
 */
public suspend inline fun MigrationHubOrchestratorClient.deleteTemplate(crossinline block: DeleteTemplateRequest.Builder.() -> Unit): DeleteTemplateResponse = deleteTemplate(DeleteTemplateRequest.Builder().apply(block).build())

/**
 * Delete a migration workflow. You must pause a running workflow in Migration Hub Orchestrator console to delete it.
 */
public suspend inline fun MigrationHubOrchestratorClient.deleteWorkflow(crossinline block: DeleteWorkflowRequest.Builder.() -> Unit): DeleteWorkflowResponse = deleteWorkflow(DeleteWorkflowRequest.Builder().apply(block).build())

/**
 * Delete a step in a migration workflow. Pause the workflow to delete a running step.
 */
public suspend inline fun MigrationHubOrchestratorClient.deleteWorkflowStep(crossinline block: DeleteWorkflowStepRequest.Builder.() -> Unit): DeleteWorkflowStepResponse = deleteWorkflowStep(DeleteWorkflowStepRequest.Builder().apply(block).build())

/**
 * Delete a step group in a migration workflow.
 */
public suspend inline fun MigrationHubOrchestratorClient.deleteWorkflowStepGroup(crossinline block: DeleteWorkflowStepGroupRequest.Builder.() -> Unit): DeleteWorkflowStepGroupResponse = deleteWorkflowStepGroup(DeleteWorkflowStepGroupRequest.Builder().apply(block).build())

/**
 * Get the template you want to use for creating a migration workflow.
 */
public suspend inline fun MigrationHubOrchestratorClient.getTemplate(crossinline block: GetTemplateRequest.Builder.() -> Unit): GetTemplateResponse = getTemplate(GetTemplateRequest.Builder().apply(block).build())

/**
 * Get a specific step in a template.
 */
public suspend inline fun MigrationHubOrchestratorClient.getTemplateStep(crossinline block: GetTemplateStepRequest.Builder.() -> Unit): GetTemplateStepResponse = getTemplateStep(GetTemplateStepRequest.Builder().apply(block).build())

/**
 * Get a step group in a template.
 */
public suspend inline fun MigrationHubOrchestratorClient.getTemplateStepGroup(crossinline block: GetTemplateStepGroupRequest.Builder.() -> Unit): GetTemplateStepGroupResponse = getTemplateStepGroup(GetTemplateStepGroupRequest.Builder().apply(block).build())

/**
 * Get migration workflow.
 */
public suspend inline fun MigrationHubOrchestratorClient.getWorkflow(crossinline block: GetWorkflowRequest.Builder.() -> Unit): GetWorkflowResponse = getWorkflow(GetWorkflowRequest.Builder().apply(block).build())

/**
 * Get a step in the migration workflow.
 */
public suspend inline fun MigrationHubOrchestratorClient.getWorkflowStep(crossinline block: GetWorkflowStepRequest.Builder.() -> Unit): GetWorkflowStepResponse = getWorkflowStep(GetWorkflowStepRequest.Builder().apply(block).build())

/**
 * Get the step group of a migration workflow.
 */
public suspend inline fun MigrationHubOrchestratorClient.getWorkflowStepGroup(crossinline block: GetWorkflowStepGroupRequest.Builder.() -> Unit): GetWorkflowStepGroupResponse = getWorkflowStepGroup(GetWorkflowStepGroupRequest.Builder().apply(block).build())

/**
 * List AWS Migration Hub Orchestrator plugins.
 */
public suspend inline fun MigrationHubOrchestratorClient.listPlugins(crossinline block: ListPluginsRequest.Builder.() -> Unit): ListPluginsResponse = listPlugins(ListPluginsRequest.Builder().apply(block).build())

/**
 * List the tags added to a resource.
 */
public suspend inline fun MigrationHubOrchestratorClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * List the step groups in a template.
 */
public suspend inline fun MigrationHubOrchestratorClient.listTemplateStepGroups(crossinline block: ListTemplateStepGroupsRequest.Builder.() -> Unit): ListTemplateStepGroupsResponse = listTemplateStepGroups(ListTemplateStepGroupsRequest.Builder().apply(block).build())

/**
 * List the steps in a template.
 */
public suspend inline fun MigrationHubOrchestratorClient.listTemplateSteps(crossinline block: ListTemplateStepsRequest.Builder.() -> Unit): ListTemplateStepsResponse = listTemplateSteps(ListTemplateStepsRequest.Builder().apply(block).build())

/**
 * List the templates available in Migration Hub Orchestrator to create a migration workflow.
 */
public suspend inline fun MigrationHubOrchestratorClient.listTemplates(crossinline block: ListTemplatesRequest.Builder.() -> Unit): ListTemplatesResponse = listTemplates(ListTemplatesRequest.Builder().apply(block).build())

/**
 * List the step groups in a migration workflow.
 */
public suspend inline fun MigrationHubOrchestratorClient.listWorkflowStepGroups(crossinline block: ListWorkflowStepGroupsRequest.Builder.() -> Unit): ListWorkflowStepGroupsResponse = listWorkflowStepGroups(ListWorkflowStepGroupsRequest.Builder().apply(block).build())

/**
 * List the steps in a workflow.
 */
public suspend inline fun MigrationHubOrchestratorClient.listWorkflowSteps(crossinline block: ListWorkflowStepsRequest.Builder.() -> Unit): ListWorkflowStepsResponse = listWorkflowSteps(ListWorkflowStepsRequest.Builder().apply(block).build())

/**
 * List the migration workflows.
 */
public suspend inline fun MigrationHubOrchestratorClient.listWorkflows(crossinline block: ListWorkflowsRequest.Builder.() -> Unit): ListWorkflowsResponse = listWorkflows(ListWorkflowsRequest.Builder().apply(block).build())

/**
 * Retry a failed step in a migration workflow.
 */
public suspend inline fun MigrationHubOrchestratorClient.retryWorkflowStep(crossinline block: RetryWorkflowStepRequest.Builder.() -> Unit): RetryWorkflowStepResponse = retryWorkflowStep(RetryWorkflowStepRequest.Builder().apply(block).build())

/**
 * Start a migration workflow.
 */
public suspend inline fun MigrationHubOrchestratorClient.startWorkflow(crossinline block: StartWorkflowRequest.Builder.() -> Unit): StartWorkflowResponse = startWorkflow(StartWorkflowRequest.Builder().apply(block).build())

/**
 * Stop an ongoing migration workflow.
 */
public suspend inline fun MigrationHubOrchestratorClient.stopWorkflow(crossinline block: StopWorkflowRequest.Builder.() -> Unit): StopWorkflowResponse = stopWorkflow(StopWorkflowRequest.Builder().apply(block).build())

/**
 * Tag a resource by specifying its Amazon Resource Name (ARN).
 */
public suspend inline fun MigrationHubOrchestratorClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Deletes the tags for a resource.
 */
public suspend inline fun MigrationHubOrchestratorClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates a migration workflow template.
 */
public suspend inline fun MigrationHubOrchestratorClient.updateTemplate(crossinline block: UpdateTemplateRequest.Builder.() -> Unit): UpdateTemplateResponse = updateTemplate(UpdateTemplateRequest.Builder().apply(block).build())

/**
 * Update a migration workflow.
 */
public suspend inline fun MigrationHubOrchestratorClient.updateWorkflow(crossinline block: UpdateWorkflowRequest.Builder.() -> Unit): UpdateWorkflowResponse = updateWorkflow(UpdateWorkflowRequest.Builder().apply(block).build())

/**
 * Update a step in a migration workflow.
 */
public suspend inline fun MigrationHubOrchestratorClient.updateWorkflowStep(crossinline block: UpdateWorkflowStepRequest.Builder.() -> Unit): UpdateWorkflowStepResponse = updateWorkflowStep(UpdateWorkflowStepRequest.Builder().apply(block).build())

/**
 * Update the step group in a migration workflow.
 */
public suspend inline fun MigrationHubOrchestratorClient.updateWorkflowStepGroup(crossinline block: UpdateWorkflowStepGroupRequest.Builder.() -> Unit): UpdateWorkflowStepGroupResponse = updateWorkflowStepGroup(UpdateWorkflowStepGroupRequest.Builder().apply(block).build())
