// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhuborchestrator.paginators

import aws.sdk.kotlin.services.migrationhuborchestrator.MigrationHubOrchestratorClient
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListPluginsRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListPluginsResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListTemplateStepGroupsRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListTemplateStepGroupsResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListTemplateStepsRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListTemplateStepsResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListTemplatesRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListTemplatesResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListWorkflowStepGroupsRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListWorkflowStepGroupsResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListWorkflowStepsRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListWorkflowStepsResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListWorkflowsRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListWorkflowsResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.MigrationWorkflowSummary
import aws.sdk.kotlin.services.migrationhuborchestrator.model.PluginSummary
import aws.sdk.kotlin.services.migrationhuborchestrator.model.TemplateStepGroupSummary
import aws.sdk.kotlin.services.migrationhuborchestrator.model.TemplateStepSummary
import aws.sdk.kotlin.services.migrationhuborchestrator.model.TemplateSummary
import aws.sdk.kotlin.services.migrationhuborchestrator.model.WorkflowStepGroupSummary
import aws.sdk.kotlin.services.migrationhuborchestrator.model.WorkflowStepSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListPluginsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPluginsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPluginsResponse]
 */
public fun MigrationHubOrchestratorClient.listPluginsPaginated(initialRequest: ListPluginsRequest = ListPluginsRequest { }): Flow<ListPluginsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPluginsPaginated.listPlugins(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPluginsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPluginsResponse]
 */
public fun MigrationHubOrchestratorClient.listPluginsPaginated(block: ListPluginsRequest.Builder.() -> Unit): Flow<ListPluginsResponse> =
    listPluginsPaginated(ListPluginsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPluginsPaginated]
 * to access the nested member [PluginSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PluginSummary]
 */
@JvmName("listPluginsResponsePluginSummary")
public fun Flow<ListPluginsResponse>.plugins(): Flow<PluginSummary> =
    transform() { response ->
        response.plugins?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTemplatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTemplatesResponse]
 */
public fun MigrationHubOrchestratorClient.listTemplatesPaginated(initialRequest: ListTemplatesRequest = ListTemplatesRequest { }): Flow<ListTemplatesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTemplatesPaginated.listTemplates(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTemplatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTemplatesResponse]
 */
public fun MigrationHubOrchestratorClient.listTemplatesPaginated(block: ListTemplatesRequest.Builder.() -> Unit): Flow<ListTemplatesResponse> =
    listTemplatesPaginated(ListTemplatesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTemplatesPaginated]
 * to access the nested member [TemplateSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TemplateSummary]
 */
@JvmName("listTemplatesResponseTemplateSummary")
public fun Flow<ListTemplatesResponse>.templateSummary(): Flow<TemplateSummary> =
    transform() { response ->
        response.templateSummary?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTemplateStepGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTemplateStepGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTemplateStepGroupsResponse]
 */
public fun MigrationHubOrchestratorClient.listTemplateStepGroupsPaginated(initialRequest: ListTemplateStepGroupsRequest): Flow<ListTemplateStepGroupsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTemplateStepGroupsPaginated.listTemplateStepGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTemplateStepGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTemplateStepGroupsResponse]
 */
public fun MigrationHubOrchestratorClient.listTemplateStepGroupsPaginated(block: ListTemplateStepGroupsRequest.Builder.() -> Unit): Flow<ListTemplateStepGroupsResponse> =
    listTemplateStepGroupsPaginated(ListTemplateStepGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTemplateStepGroupsPaginated]
 * to access the nested member [TemplateStepGroupSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TemplateStepGroupSummary]
 */
@JvmName("listTemplateStepGroupsResponseTemplateStepGroupSummary")
public fun Flow<ListTemplateStepGroupsResponse>.templateStepGroupSummary(): Flow<TemplateStepGroupSummary> =
    transform() { response ->
        response.templateStepGroupSummary?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTemplateStepsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTemplateStepsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTemplateStepsResponse]
 */
public fun MigrationHubOrchestratorClient.listTemplateStepsPaginated(initialRequest: ListTemplateStepsRequest): Flow<ListTemplateStepsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTemplateStepsPaginated.listTemplateSteps(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTemplateStepsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTemplateStepsResponse]
 */
public fun MigrationHubOrchestratorClient.listTemplateStepsPaginated(block: ListTemplateStepsRequest.Builder.() -> Unit): Flow<ListTemplateStepsResponse> =
    listTemplateStepsPaginated(ListTemplateStepsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTemplateStepsPaginated]
 * to access the nested member [TemplateStepSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TemplateStepSummary]
 */
@JvmName("listTemplateStepsResponseTemplateStepSummary")
public fun Flow<ListTemplateStepsResponse>.templateStepSummaryList(): Flow<TemplateStepSummary> =
    transform() { response ->
        response.templateStepSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListWorkflowsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWorkflowsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkflowsResponse]
 */
public fun MigrationHubOrchestratorClient.listWorkflowsPaginated(initialRequest: ListWorkflowsRequest = ListWorkflowsRequest { }): Flow<ListWorkflowsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWorkflowsPaginated.listWorkflows(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListWorkflowsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkflowsResponse]
 */
public fun MigrationHubOrchestratorClient.listWorkflowsPaginated(block: ListWorkflowsRequest.Builder.() -> Unit): Flow<ListWorkflowsResponse> =
    listWorkflowsPaginated(ListWorkflowsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listWorkflowsPaginated]
 * to access the nested member [MigrationWorkflowSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [MigrationWorkflowSummary]
 */
@JvmName("listWorkflowsResponseMigrationWorkflowSummary")
public fun Flow<ListWorkflowsResponse>.migrationWorkflowSummary(): Flow<MigrationWorkflowSummary> =
    transform() { response ->
        response.migrationWorkflowSummary?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListWorkflowStepGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWorkflowStepGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkflowStepGroupsResponse]
 */
public fun MigrationHubOrchestratorClient.listWorkflowStepGroupsPaginated(initialRequest: ListWorkflowStepGroupsRequest): Flow<ListWorkflowStepGroupsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWorkflowStepGroupsPaginated.listWorkflowStepGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListWorkflowStepGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkflowStepGroupsResponse]
 */
public fun MigrationHubOrchestratorClient.listWorkflowStepGroupsPaginated(block: ListWorkflowStepGroupsRequest.Builder.() -> Unit): Flow<ListWorkflowStepGroupsResponse> =
    listWorkflowStepGroupsPaginated(ListWorkflowStepGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listWorkflowStepGroupsPaginated]
 * to access the nested member [WorkflowStepGroupSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [WorkflowStepGroupSummary]
 */
@JvmName("listWorkflowStepGroupsResponseWorkflowStepGroupSummary")
public fun Flow<ListWorkflowStepGroupsResponse>.workflowStepGroupsSummary(): Flow<WorkflowStepGroupSummary> =
    transform() { response ->
        response.workflowStepGroupsSummary?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListWorkflowStepsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWorkflowStepsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkflowStepsResponse]
 */
public fun MigrationHubOrchestratorClient.listWorkflowStepsPaginated(initialRequest: ListWorkflowStepsRequest): Flow<ListWorkflowStepsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWorkflowStepsPaginated.listWorkflowSteps(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListWorkflowStepsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkflowStepsResponse]
 */
public fun MigrationHubOrchestratorClient.listWorkflowStepsPaginated(block: ListWorkflowStepsRequest.Builder.() -> Unit): Flow<ListWorkflowStepsResponse> =
    listWorkflowStepsPaginated(ListWorkflowStepsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listWorkflowStepsPaginated]
 * to access the nested member [WorkflowStepSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [WorkflowStepSummary]
 */
@JvmName("listWorkflowStepsResponseWorkflowStepSummary")
public fun Flow<ListWorkflowStepsResponse>.workflowStepsSummary(): Flow<WorkflowStepSummary> =
    transform() { response ->
        response.workflowStepsSummary?.forEach {
            emit(it)
        }
    }
