// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhuborchestrator.transform

import aws.sdk.kotlin.services.migrationhuborchestrator.model.MigrationHubOrchestratorException
import aws.sdk.kotlin.services.migrationhuborchestrator.model.MigrationWorkflowStatusEnum
import aws.sdk.kotlin.services.migrationhuborchestrator.model.StepInput
import aws.sdk.kotlin.services.migrationhuborchestrator.model.UpdateWorkflowResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class UpdateWorkflowOperationDeserializer: HttpDeserialize<UpdateWorkflowResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateWorkflowResponse {
        if (!response.status.isSuccess()) {
            throwUpdateWorkflowError(context, response)
        }
        val builder = UpdateWorkflowResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateWorkflowOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateWorkflowError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MigrationHubOrchestratorException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> MigrationHubOrchestratorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateWorkflowOperationBody(builder: UpdateWorkflowResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ADSAPPLICATIONCONFIGURATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("adsApplicationConfigurationId"))
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastModifiedTime"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("status"))
    val STEPTARGETS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("stepTargets"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val TEMPLATEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("templateId"))
    val WORKFLOWINPUTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("workflowInputs"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADSAPPLICATIONCONFIGURATIONID_DESCRIPTOR)
        field(ARN_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STEPTARGETS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TEMPLATEID_DESCRIPTOR)
        field(WORKFLOWINPUTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ADSAPPLICATIONCONFIGURATIONID_DESCRIPTOR.index -> builder.adsApplicationConfigurationId = deserializeString()
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { MigrationWorkflowStatusEnum.fromValue(it) }
                STEPTARGETS_DESCRIPTOR.index -> builder.stepTargets =
                    deserializer.deserializeList(STEPTARGETS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                TEMPLATEID_DESCRIPTOR.index -> builder.templateId = deserializeString()
                WORKFLOWINPUTS_DESCRIPTOR.index -> builder.workflowInputs =
                    deserializer.deserializeMap(WORKFLOWINPUTS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, StepInput>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeStepInputDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
