// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhuborchestrator.transform

import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListTemplateStepGroupsResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.MigrationHubOrchestratorException
import aws.sdk.kotlin.services.migrationhuborchestrator.model.TemplateStepGroupSummary
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListTemplateStepGroupsOperationDeserializer: HttpDeserialize<ListTemplateStepGroupsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListTemplateStepGroupsResponse {
        if (!response.status.isSuccess()) {
            throwListTemplateStepGroupsError(context, response)
        }
        val builder = ListTemplateStepGroupsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListTemplateStepGroupsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListTemplateStepGroupsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MigrationHubOrchestratorException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> MigrationHubOrchestratorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListTemplateStepGroupsOperationBody(builder: ListTemplateStepGroupsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextToken"))
    val TEMPLATESTEPGROUPSUMMARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("templateStepGroupSummary"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(TEMPLATESTEPGROUPSUMMARY_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                TEMPLATESTEPGROUPSUMMARY_DESCRIPTOR.index -> builder.templateStepGroupSummary =
                    deserializer.deserializeList(TEMPLATESTEPGROUPSUMMARY_DESCRIPTOR) {
                        val col0 = mutableListOf<TemplateStepGroupSummary>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTemplateStepGroupSummaryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
