// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhuborchestrator.transform

import aws.sdk.kotlin.services.migrationhuborchestrator.model.GetWorkflowStepResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.MigrationHubOrchestratorException
import aws.sdk.kotlin.services.migrationhuborchestrator.model.Owner
import aws.sdk.kotlin.services.migrationhuborchestrator.model.StepActionType
import aws.sdk.kotlin.services.migrationhuborchestrator.model.StepStatus
import aws.sdk.kotlin.services.migrationhuborchestrator.model.WorkflowStepAutomationConfiguration
import aws.sdk.kotlin.services.migrationhuborchestrator.model.WorkflowStepOutput
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf


internal class GetWorkflowStepOperationDeserializer: HttpDeserialize<GetWorkflowStepResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetWorkflowStepResponse {
        if (!response.status.isSuccess()) {
            throwGetWorkflowStepError(context, response)
        }
        val builder = GetWorkflowStepResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetWorkflowStepOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetWorkflowStepError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MigrationHubOrchestratorException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> MigrationHubOrchestratorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetWorkflowStepOperationBody(builder: GetWorkflowStepResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("endTime"))
    val LASTSTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastStartTime"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val NEXT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("next"))
    val NOOFSRVCOMPLETED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("noOfSrvCompleted"))
    val NOOFSRVFAILED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("noOfSrvFailed"))
    val OUTPUTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("outputs"))
    val OWNER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("owner"))
    val PREVIOUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("previous"))
    val SCRIPTOUTPUTLOCATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("scriptOutputLocation"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("status"))
    val STATUSMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("statusMessage"))
    val STEPACTIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("stepActionType"))
    val STEPGROUPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("stepGroupId"))
    val STEPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("stepId"))
    val STEPTARGET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("stepTarget"))
    val TOTALNOOFSRV_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("totalNoOfSrv"))
    val WORKFLOWID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("workflowId"))
    val WORKFLOWSTEPAUTOMATIONCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("workflowStepAutomationConfiguration"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENDTIME_DESCRIPTOR)
        field(LASTSTARTTIME_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(NEXT_DESCRIPTOR)
        field(NOOFSRVCOMPLETED_DESCRIPTOR)
        field(NOOFSRVFAILED_DESCRIPTOR)
        field(OUTPUTS_DESCRIPTOR)
        field(OWNER_DESCRIPTOR)
        field(PREVIOUS_DESCRIPTOR)
        field(SCRIPTOUTPUTLOCATION_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSMESSAGE_DESCRIPTOR)
        field(STEPACTIONTYPE_DESCRIPTOR)
        field(STEPGROUPID_DESCRIPTOR)
        field(STEPID_DESCRIPTOR)
        field(STEPTARGET_DESCRIPTOR)
        field(TOTALNOOFSRV_DESCRIPTOR)
        field(WORKFLOWID_DESCRIPTOR)
        field(WORKFLOWSTEPAUTOMATIONCONFIGURATION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ENDTIME_DESCRIPTOR.index -> builder.endTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                LASTSTARTTIME_DESCRIPTOR.index -> builder.lastStartTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                NEXT_DESCRIPTOR.index -> builder.next =
                    deserializer.deserializeList(NEXT_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NOOFSRVCOMPLETED_DESCRIPTOR.index -> builder.noOfSrvCompleted = deserializeInt()
                NOOFSRVFAILED_DESCRIPTOR.index -> builder.noOfSrvFailed = deserializeInt()
                OUTPUTS_DESCRIPTOR.index -> builder.outputs =
                    deserializer.deserializeList(OUTPUTS_DESCRIPTOR) {
                        val col0 = mutableListOf<WorkflowStepOutput>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeWorkflowStepOutputDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                OWNER_DESCRIPTOR.index -> builder.owner = deserializeString().let { Owner.fromValue(it) }
                PREVIOUS_DESCRIPTOR.index -> builder.previous =
                    deserializer.deserializeList(PREVIOUS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SCRIPTOUTPUTLOCATION_DESCRIPTOR.index -> builder.scriptOutputLocation = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { StepStatus.fromValue(it) }
                STATUSMESSAGE_DESCRIPTOR.index -> builder.statusMessage = deserializeString()
                STEPACTIONTYPE_DESCRIPTOR.index -> builder.stepActionType = deserializeString().let { StepActionType.fromValue(it) }
                STEPGROUPID_DESCRIPTOR.index -> builder.stepGroupId = deserializeString()
                STEPID_DESCRIPTOR.index -> builder.stepId = deserializeString()
                STEPTARGET_DESCRIPTOR.index -> builder.stepTarget =
                    deserializer.deserializeList(STEPTARGET_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TOTALNOOFSRV_DESCRIPTOR.index -> builder.totalNoOfSrv = deserializeInt()
                WORKFLOWID_DESCRIPTOR.index -> builder.workflowId = deserializeString()
                WORKFLOWSTEPAUTOMATIONCONFIGURATION_DESCRIPTOR.index -> builder.workflowStepAutomationConfiguration = deserializeWorkflowStepAutomationConfigurationDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
