// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhuborchestrator.transform

import aws.sdk.kotlin.services.migrationhuborchestrator.model.GetWorkflowResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.MigrationHubOrchestratorException
import aws.sdk.kotlin.services.migrationhuborchestrator.model.MigrationWorkflowStatusEnum
import aws.sdk.kotlin.services.migrationhuborchestrator.model.StepInput
import aws.sdk.kotlin.services.migrationhuborchestrator.model.Tool
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class GetWorkflowOperationDeserializer: HttpDeserialize<GetWorkflowResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetWorkflowResponse {
        if (!response.status.isSuccess()) {
            throwGetWorkflowError(context, response)
        }
        val builder = GetWorkflowResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetWorkflowOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetWorkflowError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MigrationHubOrchestratorException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> MigrationHubOrchestratorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetWorkflowOperationBody(builder: GetWorkflowResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ADSAPPLICATIONCONFIGURATIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("adsApplicationConfigurationId"))
    val ADSAPPLICATIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("adsApplicationName"))
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val COMPLETEDSTEPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("completedSteps"))
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("creationTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val ENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("endTime"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val LASTMODIFIEDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastModifiedTime"))
    val LASTSTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastStartTime"))
    val LASTSTOPTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("lastStopTime"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("status"))
    val STATUSMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("statusMessage"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val TEMPLATEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("templateId"))
    val TOOLS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("tools"))
    val TOTALSTEPS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("totalSteps"))
    val WORKFLOWBUCKET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("workflowBucket"))
    val WORKFLOWINPUTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("workflowInputs"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ADSAPPLICATIONCONFIGURATIONID_DESCRIPTOR)
        field(ADSAPPLICATIONNAME_DESCRIPTOR)
        field(ARN_DESCRIPTOR)
        field(COMPLETEDSTEPS_DESCRIPTOR)
        field(CREATIONTIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENDTIME_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(LASTMODIFIEDTIME_DESCRIPTOR)
        field(LASTSTARTTIME_DESCRIPTOR)
        field(LASTSTOPTIME_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSMESSAGE_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TEMPLATEID_DESCRIPTOR)
        field(TOOLS_DESCRIPTOR)
        field(TOTALSTEPS_DESCRIPTOR)
        field(WORKFLOWBUCKET_DESCRIPTOR)
        field(WORKFLOWINPUTS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ADSAPPLICATIONCONFIGURATIONID_DESCRIPTOR.index -> builder.adsApplicationConfigurationId = deserializeString()
                ADSAPPLICATIONNAME_DESCRIPTOR.index -> builder.adsApplicationName = deserializeString()
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                COMPLETEDSTEPS_DESCRIPTOR.index -> builder.completedSteps = deserializeInt()
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ENDTIME_DESCRIPTOR.index -> builder.endTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                LASTMODIFIEDTIME_DESCRIPTOR.index -> builder.lastModifiedTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                LASTSTARTTIME_DESCRIPTOR.index -> builder.lastStartTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                LASTSTOPTIME_DESCRIPTOR.index -> builder.lastStopTime = deserializeString().let { Instant.fromEpochSeconds(it) }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { MigrationWorkflowStatusEnum.fromValue(it) }
                STATUSMESSAGE_DESCRIPTOR.index -> builder.statusMessage = deserializeString()
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                TEMPLATEID_DESCRIPTOR.index -> builder.templateId = deserializeString()
                TOOLS_DESCRIPTOR.index -> builder.tools =
                    deserializer.deserializeList(TOOLS_DESCRIPTOR) {
                        val col0 = mutableListOf<Tool>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeToolDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                TOTALSTEPS_DESCRIPTOR.index -> builder.totalSteps = deserializeInt()
                WORKFLOWBUCKET_DESCRIPTOR.index -> builder.workflowBucket = deserializeString()
                WORKFLOWINPUTS_DESCRIPTOR.index -> builder.workflowInputs =
                    deserializer.deserializeMap(WORKFLOWINPUTS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, StepInput>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeStepInputDocument(deserializer) } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
