// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhuborchestrator

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.migrationhuborchestrator.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.migrationhuborchestrator.endpoints.EndpointProvider
import aws.sdk.kotlin.services.migrationhuborchestrator.model.CreateWorkflowRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.CreateWorkflowResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.CreateWorkflowStepGroupRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.CreateWorkflowStepGroupResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.CreateWorkflowStepRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.CreateWorkflowStepResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.DeleteWorkflowRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.DeleteWorkflowResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.DeleteWorkflowStepGroupRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.DeleteWorkflowStepGroupResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.DeleteWorkflowStepRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.DeleteWorkflowStepResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.GetTemplateRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.GetTemplateResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.GetTemplateStepGroupRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.GetTemplateStepGroupResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.GetTemplateStepRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.GetTemplateStepResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.GetWorkflowRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.GetWorkflowResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.GetWorkflowStepGroupRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.GetWorkflowStepGroupResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.GetWorkflowStepRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.GetWorkflowStepResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListPluginsRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListPluginsResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListTemplateStepGroupsRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListTemplateStepGroupsResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListTemplateStepsRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListTemplateStepsResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListTemplatesRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListTemplatesResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListWorkflowStepGroupsRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListWorkflowStepGroupsResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListWorkflowStepsRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListWorkflowStepsResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListWorkflowsRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListWorkflowsResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.RetryWorkflowStepRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.RetryWorkflowStepResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.StartWorkflowRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.StartWorkflowResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.StopWorkflowRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.StopWorkflowResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.TagResourceRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.TagResourceResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.UntagResourceRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.UntagResourceResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.UpdateWorkflowRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.UpdateWorkflowResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.UpdateWorkflowStepGroupRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.UpdateWorkflowStepGroupResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.UpdateWorkflowStepRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.UpdateWorkflowStepResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.internal.manage
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig
import kotlin.collections.List
import kotlin.jvm.JvmStatic

/**
 * This API reference provides descriptions, syntax, and other details about each of the actions and data types for AWS Migration Hub Orchestrator. he topic for each action shows the API request parameters and the response. Alternatively, you can use one of the AWS SDKs to access an API that is tailored to the programming language or platform that you're using.
 */
public interface MigrationHubOrchestratorClient : SdkClient {
    /**
     * MigrationHubOrchestratorClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, MigrationHubOrchestratorClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, MigrationHubOrchestratorClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): MigrationHubOrchestratorClient = DefaultMigrationHubOrchestratorClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, HttpClientConfig, SdkClientConfig, TracingClientConfig {
        override val clientName: String = builder.clientName
        override val httpClientEngine: HttpClientEngine = builder.httpClientEngine ?: DefaultHttpEngine().manage()
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region).manage()
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, clientName)
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            httpClientEngine = this@Config.httpClientEngine
            region = this@Config.region
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            interceptors = this@Config.interceptors.toMutableList()
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            sdkLogMode = this@Config.sdkLogMode
            signer = this@Config.signer
            tracer = this@Config.tracer
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, HttpClientConfig.Builder, SdkClientConfig.Builder<Config>, TracingClientConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "MigrationHubOrchestrator"

            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            override var httpClientEngine: HttpClientEngine? = null

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            override var retryStrategy: RetryStrategy? = null

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            override var tracer: Tracer? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Create a workflow to orchestrate your migrations.
     */
    public suspend fun createWorkflow(input: CreateWorkflowRequest): CreateWorkflowResponse

    /**
     * Create a step in the migration workflow.
     */
    public suspend fun createWorkflowStep(input: CreateWorkflowStepRequest): CreateWorkflowStepResponse

    /**
     * Create a step group in a migration workflow.
     */
    public suspend fun createWorkflowStepGroup(input: CreateWorkflowStepGroupRequest): CreateWorkflowStepGroupResponse

    /**
     * Delete a migration workflow. You must pause a running workflow in Migration Hub Orchestrator console to delete it.
     */
    public suspend fun deleteWorkflow(input: DeleteWorkflowRequest): DeleteWorkflowResponse

    /**
     * Delete a step in a migration workflow. Pause the workflow to delete a running step.
     */
    public suspend fun deleteWorkflowStep(input: DeleteWorkflowStepRequest): DeleteWorkflowStepResponse

    /**
     * Delete a step group in a migration workflow.
     */
    public suspend fun deleteWorkflowStepGroup(input: DeleteWorkflowStepGroupRequest): DeleteWorkflowStepGroupResponse

    /**
     * Get the template you want to use for creating a migration workflow.
     */
    public suspend fun getTemplate(input: GetTemplateRequest): GetTemplateResponse

    /**
     * Get a specific step in a template.
     */
    public suspend fun getTemplateStep(input: GetTemplateStepRequest): GetTemplateStepResponse

    /**
     * Get a step group in a template.
     */
    public suspend fun getTemplateStepGroup(input: GetTemplateStepGroupRequest): GetTemplateStepGroupResponse

    /**
     * Get migration workflow.
     */
    public suspend fun getWorkflow(input: GetWorkflowRequest): GetWorkflowResponse

    /**
     * Get a step in the migration workflow.
     */
    public suspend fun getWorkflowStep(input: GetWorkflowStepRequest): GetWorkflowStepResponse

    /**
     * Get the step group of a migration workflow.
     */
    public suspend fun getWorkflowStepGroup(input: GetWorkflowStepGroupRequest): GetWorkflowStepGroupResponse

    /**
     * List AWS Migration Hub Orchestrator plugins.
     */
    public suspend fun listPlugins(input: ListPluginsRequest = ListPluginsRequest {}): ListPluginsResponse

    /**
     * List the tags added to a resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * List the step groups in a template.
     */
    public suspend fun listTemplateStepGroups(input: ListTemplateStepGroupsRequest): ListTemplateStepGroupsResponse

    /**
     * List the steps in a template.
     */
    public suspend fun listTemplateSteps(input: ListTemplateStepsRequest): ListTemplateStepsResponse

    /**
     * List the templates available in Migration Hub Orchestrator to create a migration workflow.
     */
    public suspend fun listTemplates(input: ListTemplatesRequest = ListTemplatesRequest {}): ListTemplatesResponse

    /**
     * List the step groups in a migration workflow.
     */
    public suspend fun listWorkflowStepGroups(input: ListWorkflowStepGroupsRequest): ListWorkflowStepGroupsResponse

    /**
     * List the steps in a workflow.
     */
    public suspend fun listWorkflowSteps(input: ListWorkflowStepsRequest): ListWorkflowStepsResponse

    /**
     * List the migration workflows.
     */
    public suspend fun listWorkflows(input: ListWorkflowsRequest = ListWorkflowsRequest {}): ListWorkflowsResponse

    /**
     * Retry a failed step in a migration workflow.
     */
    public suspend fun retryWorkflowStep(input: RetryWorkflowStepRequest): RetryWorkflowStepResponse

    /**
     * Start a migration workflow.
     */
    public suspend fun startWorkflow(input: StartWorkflowRequest): StartWorkflowResponse

    /**
     * Stop an ongoing migration workflow.
     */
    public suspend fun stopWorkflow(input: StopWorkflowRequest): StopWorkflowResponse

    /**
     * Tag a resource by specifying its Amazon Resource Name (ARN).
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Deletes the tags for a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Update a migration workflow.
     */
    public suspend fun updateWorkflow(input: UpdateWorkflowRequest): UpdateWorkflowResponse

    /**
     * Update a step in a migration workflow.
     */
    public suspend fun updateWorkflowStep(input: UpdateWorkflowStepRequest): UpdateWorkflowStepResponse

    /**
     * Update the step group in a migration workflow.
     */
    public suspend fun updateWorkflowStepGroup(input: UpdateWorkflowStepGroupRequest): UpdateWorkflowStepGroupResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun MigrationHubOrchestratorClient.withConfig(block: MigrationHubOrchestratorClient.Config.Builder.() -> Unit): MigrationHubOrchestratorClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultMigrationHubOrchestratorClient(newConfig)
}

/**
 * Create a workflow to orchestrate your migrations.
 */
public suspend inline fun MigrationHubOrchestratorClient.createWorkflow(crossinline block: CreateWorkflowRequest.Builder.() -> Unit): CreateWorkflowResponse = createWorkflow(CreateWorkflowRequest.Builder().apply(block).build())

/**
 * Create a step in the migration workflow.
 */
public suspend inline fun MigrationHubOrchestratorClient.createWorkflowStep(crossinline block: CreateWorkflowStepRequest.Builder.() -> Unit): CreateWorkflowStepResponse = createWorkflowStep(CreateWorkflowStepRequest.Builder().apply(block).build())

/**
 * Create a step group in a migration workflow.
 */
public suspend inline fun MigrationHubOrchestratorClient.createWorkflowStepGroup(crossinline block: CreateWorkflowStepGroupRequest.Builder.() -> Unit): CreateWorkflowStepGroupResponse = createWorkflowStepGroup(CreateWorkflowStepGroupRequest.Builder().apply(block).build())

/**
 * Delete a migration workflow. You must pause a running workflow in Migration Hub Orchestrator console to delete it.
 */
public suspend inline fun MigrationHubOrchestratorClient.deleteWorkflow(crossinline block: DeleteWorkflowRequest.Builder.() -> Unit): DeleteWorkflowResponse = deleteWorkflow(DeleteWorkflowRequest.Builder().apply(block).build())

/**
 * Delete a step in a migration workflow. Pause the workflow to delete a running step.
 */
public suspend inline fun MigrationHubOrchestratorClient.deleteWorkflowStep(crossinline block: DeleteWorkflowStepRequest.Builder.() -> Unit): DeleteWorkflowStepResponse = deleteWorkflowStep(DeleteWorkflowStepRequest.Builder().apply(block).build())

/**
 * Delete a step group in a migration workflow.
 */
public suspend inline fun MigrationHubOrchestratorClient.deleteWorkflowStepGroup(crossinline block: DeleteWorkflowStepGroupRequest.Builder.() -> Unit): DeleteWorkflowStepGroupResponse = deleteWorkflowStepGroup(DeleteWorkflowStepGroupRequest.Builder().apply(block).build())

/**
 * Get the template you want to use for creating a migration workflow.
 */
public suspend inline fun MigrationHubOrchestratorClient.getTemplate(crossinline block: GetTemplateRequest.Builder.() -> Unit): GetTemplateResponse = getTemplate(GetTemplateRequest.Builder().apply(block).build())

/**
 * Get a specific step in a template.
 */
public suspend inline fun MigrationHubOrchestratorClient.getTemplateStep(crossinline block: GetTemplateStepRequest.Builder.() -> Unit): GetTemplateStepResponse = getTemplateStep(GetTemplateStepRequest.Builder().apply(block).build())

/**
 * Get a step group in a template.
 */
public suspend inline fun MigrationHubOrchestratorClient.getTemplateStepGroup(crossinline block: GetTemplateStepGroupRequest.Builder.() -> Unit): GetTemplateStepGroupResponse = getTemplateStepGroup(GetTemplateStepGroupRequest.Builder().apply(block).build())

/**
 * Get migration workflow.
 */
public suspend inline fun MigrationHubOrchestratorClient.getWorkflow(crossinline block: GetWorkflowRequest.Builder.() -> Unit): GetWorkflowResponse = getWorkflow(GetWorkflowRequest.Builder().apply(block).build())

/**
 * Get a step in the migration workflow.
 */
public suspend inline fun MigrationHubOrchestratorClient.getWorkflowStep(crossinline block: GetWorkflowStepRequest.Builder.() -> Unit): GetWorkflowStepResponse = getWorkflowStep(GetWorkflowStepRequest.Builder().apply(block).build())

/**
 * Get the step group of a migration workflow.
 */
public suspend inline fun MigrationHubOrchestratorClient.getWorkflowStepGroup(crossinline block: GetWorkflowStepGroupRequest.Builder.() -> Unit): GetWorkflowStepGroupResponse = getWorkflowStepGroup(GetWorkflowStepGroupRequest.Builder().apply(block).build())

/**
 * List AWS Migration Hub Orchestrator plugins.
 */
public suspend inline fun MigrationHubOrchestratorClient.listPlugins(crossinline block: ListPluginsRequest.Builder.() -> Unit): ListPluginsResponse = listPlugins(ListPluginsRequest.Builder().apply(block).build())

/**
 * List the tags added to a resource.
 */
public suspend inline fun MigrationHubOrchestratorClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * List the step groups in a template.
 */
public suspend inline fun MigrationHubOrchestratorClient.listTemplateStepGroups(crossinline block: ListTemplateStepGroupsRequest.Builder.() -> Unit): ListTemplateStepGroupsResponse = listTemplateStepGroups(ListTemplateStepGroupsRequest.Builder().apply(block).build())

/**
 * List the steps in a template.
 */
public suspend inline fun MigrationHubOrchestratorClient.listTemplateSteps(crossinline block: ListTemplateStepsRequest.Builder.() -> Unit): ListTemplateStepsResponse = listTemplateSteps(ListTemplateStepsRequest.Builder().apply(block).build())

/**
 * List the templates available in Migration Hub Orchestrator to create a migration workflow.
 */
public suspend inline fun MigrationHubOrchestratorClient.listTemplates(crossinline block: ListTemplatesRequest.Builder.() -> Unit): ListTemplatesResponse = listTemplates(ListTemplatesRequest.Builder().apply(block).build())

/**
 * List the step groups in a migration workflow.
 */
public suspend inline fun MigrationHubOrchestratorClient.listWorkflowStepGroups(crossinline block: ListWorkflowStepGroupsRequest.Builder.() -> Unit): ListWorkflowStepGroupsResponse = listWorkflowStepGroups(ListWorkflowStepGroupsRequest.Builder().apply(block).build())

/**
 * List the steps in a workflow.
 */
public suspend inline fun MigrationHubOrchestratorClient.listWorkflowSteps(crossinline block: ListWorkflowStepsRequest.Builder.() -> Unit): ListWorkflowStepsResponse = listWorkflowSteps(ListWorkflowStepsRequest.Builder().apply(block).build())

/**
 * List the migration workflows.
 */
public suspend inline fun MigrationHubOrchestratorClient.listWorkflows(crossinline block: ListWorkflowsRequest.Builder.() -> Unit): ListWorkflowsResponse = listWorkflows(ListWorkflowsRequest.Builder().apply(block).build())

/**
 * Retry a failed step in a migration workflow.
 */
public suspend inline fun MigrationHubOrchestratorClient.retryWorkflowStep(crossinline block: RetryWorkflowStepRequest.Builder.() -> Unit): RetryWorkflowStepResponse = retryWorkflowStep(RetryWorkflowStepRequest.Builder().apply(block).build())

/**
 * Start a migration workflow.
 */
public suspend inline fun MigrationHubOrchestratorClient.startWorkflow(crossinline block: StartWorkflowRequest.Builder.() -> Unit): StartWorkflowResponse = startWorkflow(StartWorkflowRequest.Builder().apply(block).build())

/**
 * Stop an ongoing migration workflow.
 */
public suspend inline fun MigrationHubOrchestratorClient.stopWorkflow(crossinline block: StopWorkflowRequest.Builder.() -> Unit): StopWorkflowResponse = stopWorkflow(StopWorkflowRequest.Builder().apply(block).build())

/**
 * Tag a resource by specifying its Amazon Resource Name (ARN).
 */
public suspend inline fun MigrationHubOrchestratorClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Deletes the tags for a resource.
 */
public suspend inline fun MigrationHubOrchestratorClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Update a migration workflow.
 */
public suspend inline fun MigrationHubOrchestratorClient.updateWorkflow(crossinline block: UpdateWorkflowRequest.Builder.() -> Unit): UpdateWorkflowResponse = updateWorkflow(UpdateWorkflowRequest.Builder().apply(block).build())

/**
 * Update a step in a migration workflow.
 */
public suspend inline fun MigrationHubOrchestratorClient.updateWorkflowStep(crossinline block: UpdateWorkflowStepRequest.Builder.() -> Unit): UpdateWorkflowStepResponse = updateWorkflowStep(UpdateWorkflowStepRequest.Builder().apply(block).build())

/**
 * Update the step group in a migration workflow.
 */
public suspend inline fun MigrationHubOrchestratorClient.updateWorkflowStepGroup(crossinline block: UpdateWorkflowStepGroupRequest.Builder.() -> Unit): UpdateWorkflowStepGroupResponse = updateWorkflowStepGroup(UpdateWorkflowStepGroupRequest.Builder().apply(block).build())
