// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhuborchestrator

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.services.migrationhuborchestrator.endpoints.internal.ResolveEndpoint
import aws.sdk.kotlin.services.migrationhuborchestrator.endpoints.internal.bindAwsBuiltins
import aws.sdk.kotlin.services.migrationhuborchestrator.model.*
import aws.sdk.kotlin.services.migrationhuborchestrator.model.CreateWorkflowRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.CreateWorkflowStepGroupRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.CreateWorkflowStepRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.DeleteWorkflowRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.DeleteWorkflowStepGroupRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.DeleteWorkflowStepRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.GetTemplateRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.GetTemplateStepGroupRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.GetTemplateStepRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.GetWorkflowRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.GetWorkflowStepGroupRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.GetWorkflowStepRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListPluginsRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListTemplateStepGroupsRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListTemplateStepsRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListTemplatesRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListWorkflowStepGroupsRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListWorkflowStepsRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.ListWorkflowsRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.RetryWorkflowStepRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.StartWorkflowRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.StopWorkflowRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.TagResourceRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.UntagResourceRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.UpdateWorkflowRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.UpdateWorkflowStepGroupRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.model.UpdateWorkflowStepRequest
import aws.sdk.kotlin.services.migrationhuborchestrator.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsHttpSigner
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.io.SdkManagedGroup
import aws.smithy.kotlin.runtime.io.addIfManaged
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "MigrationHubOrchestrator"
public const val ServiceApiVersion: String = "2021-08-28"
public const val SdkVersion: String = "0.21.3-beta"

internal class DefaultMigrationHubOrchestratorClient(override val config: MigrationHubOrchestratorClient.Config) : MigrationHubOrchestratorClient {
    private val managedResources = SdkManagedGroup()
    private val client = SdkHttpClient(config.httpClientEngine)

    init {
        managedResources.addIfManaged(config.httpClientEngine)
        managedResources.addIfManaged(config.credentialsProvider)
    }

    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Create a workflow to orchestrate your migrations.
     */
    override suspend fun createWorkflow(input: CreateWorkflowRequest): CreateWorkflowResponse {
        val op = SdkHttpOperation.build<CreateWorkflowRequest, CreateWorkflowResponse> {
            serializer = CreateWorkflowOperationSerializer()
            deserializer = CreateWorkflowOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateWorkflow"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateWorkflowRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "migrationhub-orchestrator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateWorkflow-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Create a step in the migration workflow.
     */
    override suspend fun createWorkflowStep(input: CreateWorkflowStepRequest): CreateWorkflowStepResponse {
        val op = SdkHttpOperation.build<CreateWorkflowStepRequest, CreateWorkflowStepResponse> {
            serializer = CreateWorkflowStepOperationSerializer()
            deserializer = CreateWorkflowStepOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateWorkflowStep"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateWorkflowStepRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "migrationhub-orchestrator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateWorkflowStep-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Create a step group in a migration workflow.
     */
    override suspend fun createWorkflowStepGroup(input: CreateWorkflowStepGroupRequest): CreateWorkflowStepGroupResponse {
        val op = SdkHttpOperation.build<CreateWorkflowStepGroupRequest, CreateWorkflowStepGroupResponse> {
            serializer = CreateWorkflowStepGroupOperationSerializer()
            deserializer = CreateWorkflowStepGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "CreateWorkflowStepGroup"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateWorkflowStepGroupRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "migrationhub-orchestrator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateWorkflowStepGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Delete a migration workflow. You must pause a running workflow in Migration Hub Orchestrator console to delete it.
     */
    override suspend fun deleteWorkflow(input: DeleteWorkflowRequest): DeleteWorkflowResponse {
        val op = SdkHttpOperation.build<DeleteWorkflowRequest, DeleteWorkflowResponse> {
            serializer = DeleteWorkflowOperationSerializer()
            deserializer = DeleteWorkflowOperationDeserializer()
            context {
                expectedHttpStatus = 202
                operationName = "DeleteWorkflow"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteWorkflowRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "migrationhub-orchestrator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteWorkflow-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Delete a step in a migration workflow. Pause the workflow to delete a running step.
     */
    override suspend fun deleteWorkflowStep(input: DeleteWorkflowStepRequest): DeleteWorkflowStepResponse {
        val op = SdkHttpOperation.build<DeleteWorkflowStepRequest, DeleteWorkflowStepResponse> {
            serializer = DeleteWorkflowStepOperationSerializer()
            deserializer = DeleteWorkflowStepOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "DeleteWorkflowStep"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteWorkflowStepRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "migrationhub-orchestrator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteWorkflowStep-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Delete a step group in a migration workflow.
     */
    override suspend fun deleteWorkflowStepGroup(input: DeleteWorkflowStepGroupRequest): DeleteWorkflowStepGroupResponse {
        val op = SdkHttpOperation.build<DeleteWorkflowStepGroupRequest, DeleteWorkflowStepGroupResponse> {
            serializer = DeleteWorkflowStepGroupOperationSerializer()
            deserializer = DeleteWorkflowStepGroupOperationDeserializer()
            context {
                expectedHttpStatus = 202
                operationName = "DeleteWorkflowStepGroup"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteWorkflowStepGroupRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "migrationhub-orchestrator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteWorkflowStepGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Get the template you want to use for creating a migration workflow.
     */
    override suspend fun getTemplate(input: GetTemplateRequest): GetTemplateResponse {
        val op = SdkHttpOperation.build<GetTemplateRequest, GetTemplateResponse> {
            serializer = GetTemplateOperationSerializer()
            deserializer = GetTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetTemplate"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetTemplateRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "migrationhub-orchestrator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Get a specific step in a template.
     */
    override suspend fun getTemplateStep(input: GetTemplateStepRequest): GetTemplateStepResponse {
        val op = SdkHttpOperation.build<GetTemplateStepRequest, GetTemplateStepResponse> {
            serializer = GetTemplateStepOperationSerializer()
            deserializer = GetTemplateStepOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetTemplateStep"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetTemplateStepRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "migrationhub-orchestrator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetTemplateStep-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Get a step group in a template.
     */
    override suspend fun getTemplateStepGroup(input: GetTemplateStepGroupRequest): GetTemplateStepGroupResponse {
        val op = SdkHttpOperation.build<GetTemplateStepGroupRequest, GetTemplateStepGroupResponse> {
            serializer = GetTemplateStepGroupOperationSerializer()
            deserializer = GetTemplateStepGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetTemplateStepGroup"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetTemplateStepGroupRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "migrationhub-orchestrator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetTemplateStepGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Get migration workflow.
     */
    override suspend fun getWorkflow(input: GetWorkflowRequest): GetWorkflowResponse {
        val op = SdkHttpOperation.build<GetWorkflowRequest, GetWorkflowResponse> {
            serializer = GetWorkflowOperationSerializer()
            deserializer = GetWorkflowOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetWorkflow"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetWorkflowRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "migrationhub-orchestrator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetWorkflow-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Get a step in the migration workflow.
     */
    override suspend fun getWorkflowStep(input: GetWorkflowStepRequest): GetWorkflowStepResponse {
        val op = SdkHttpOperation.build<GetWorkflowStepRequest, GetWorkflowStepResponse> {
            serializer = GetWorkflowStepOperationSerializer()
            deserializer = GetWorkflowStepOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetWorkflowStep"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetWorkflowStepRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "migrationhub-orchestrator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetWorkflowStep-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Get the step group of a migration workflow.
     */
    override suspend fun getWorkflowStepGroup(input: GetWorkflowStepGroupRequest): GetWorkflowStepGroupResponse {
        val op = SdkHttpOperation.build<GetWorkflowStepGroupRequest, GetWorkflowStepGroupResponse> {
            serializer = GetWorkflowStepGroupOperationSerializer()
            deserializer = GetWorkflowStepGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "GetWorkflowStepGroup"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetWorkflowStepGroupRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "migrationhub-orchestrator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetWorkflowStepGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * List AWS Migration Hub Orchestrator plugins.
     */
    override suspend fun listPlugins(input: ListPluginsRequest): ListPluginsResponse {
        val op = SdkHttpOperation.build<ListPluginsRequest, ListPluginsResponse> {
            serializer = ListPluginsOperationSerializer()
            deserializer = ListPluginsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListPlugins"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListPluginsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "migrationhub-orchestrator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListPlugins-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * List the tags added to a resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListTagsForResource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListTagsForResourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "migrationhub-orchestrator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListTagsForResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * List the step groups in a template.
     */
    override suspend fun listTemplateStepGroups(input: ListTemplateStepGroupsRequest): ListTemplateStepGroupsResponse {
        val op = SdkHttpOperation.build<ListTemplateStepGroupsRequest, ListTemplateStepGroupsResponse> {
            serializer = ListTemplateStepGroupsOperationSerializer()
            deserializer = ListTemplateStepGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListTemplateStepGroups"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListTemplateStepGroupsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "migrationhub-orchestrator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListTemplateStepGroups-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * List the steps in a template.
     */
    override suspend fun listTemplateSteps(input: ListTemplateStepsRequest): ListTemplateStepsResponse {
        val op = SdkHttpOperation.build<ListTemplateStepsRequest, ListTemplateStepsResponse> {
            serializer = ListTemplateStepsOperationSerializer()
            deserializer = ListTemplateStepsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListTemplateSteps"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListTemplateStepsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "migrationhub-orchestrator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListTemplateSteps-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * List the templates available in Migration Hub Orchestrator to create a migration workflow.
     */
    override suspend fun listTemplates(input: ListTemplatesRequest): ListTemplatesResponse {
        val op = SdkHttpOperation.build<ListTemplatesRequest, ListTemplatesResponse> {
            serializer = ListTemplatesOperationSerializer()
            deserializer = ListTemplatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListTemplates"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListTemplatesRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "migrationhub-orchestrator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListTemplates-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * List the step groups in a migration workflow.
     */
    override suspend fun listWorkflowStepGroups(input: ListWorkflowStepGroupsRequest): ListWorkflowStepGroupsResponse {
        val op = SdkHttpOperation.build<ListWorkflowStepGroupsRequest, ListWorkflowStepGroupsResponse> {
            serializer = ListWorkflowStepGroupsOperationSerializer()
            deserializer = ListWorkflowStepGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListWorkflowStepGroups"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListWorkflowStepGroupsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "migrationhub-orchestrator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListWorkflowStepGroups-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * List the steps in a workflow.
     */
    override suspend fun listWorkflowSteps(input: ListWorkflowStepsRequest): ListWorkflowStepsResponse {
        val op = SdkHttpOperation.build<ListWorkflowStepsRequest, ListWorkflowStepsResponse> {
            serializer = ListWorkflowStepsOperationSerializer()
            deserializer = ListWorkflowStepsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListWorkflowSteps"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListWorkflowStepsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "migrationhub-orchestrator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListWorkflowSteps-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * List the migration workflows.
     */
    override suspend fun listWorkflows(input: ListWorkflowsRequest): ListWorkflowsResponse {
        val op = SdkHttpOperation.build<ListWorkflowsRequest, ListWorkflowsResponse> {
            serializer = ListWorkflowsOperationSerializer()
            deserializer = ListWorkflowsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "ListWorkflows"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListWorkflowsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "migrationhub-orchestrator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListWorkflows-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retry a failed step in a migration workflow.
     */
    override suspend fun retryWorkflowStep(input: RetryWorkflowStepRequest): RetryWorkflowStepResponse {
        val op = SdkHttpOperation.build<RetryWorkflowStepRequest, RetryWorkflowStepResponse> {
            serializer = RetryWorkflowStepOperationSerializer()
            deserializer = RetryWorkflowStepOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "RetryWorkflowStep"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<RetryWorkflowStepRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "migrationhub-orchestrator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("RetryWorkflowStep-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Start a migration workflow.
     */
    override suspend fun startWorkflow(input: StartWorkflowRequest): StartWorkflowResponse {
        val op = SdkHttpOperation.build<StartWorkflowRequest, StartWorkflowResponse> {
            serializer = StartWorkflowOperationSerializer()
            deserializer = StartWorkflowOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StartWorkflow"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<StartWorkflowRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "migrationhub-orchestrator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StartWorkflow-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Stop an ongoing migration workflow.
     */
    override suspend fun stopWorkflow(input: StopWorkflowRequest): StopWorkflowResponse {
        val op = SdkHttpOperation.build<StopWorkflowRequest, StopWorkflowResponse> {
            serializer = StopWorkflowOperationSerializer()
            deserializer = StopWorkflowOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "StopWorkflow"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<StopWorkflowRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "migrationhub-orchestrator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StopWorkflow-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Tag a resource by specifying its Amazon Resource Name (ARN).
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "TagResource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<TagResourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "migrationhub-orchestrator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("TagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the tags for a resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UntagResource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UntagResourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "migrationhub-orchestrator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UntagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Update a migration workflow.
     */
    override suspend fun updateWorkflow(input: UpdateWorkflowRequest): UpdateWorkflowResponse {
        val op = SdkHttpOperation.build<UpdateWorkflowRequest, UpdateWorkflowResponse> {
            serializer = UpdateWorkflowOperationSerializer()
            deserializer = UpdateWorkflowOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateWorkflow"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateWorkflowRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "migrationhub-orchestrator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateWorkflow-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Update a step in a migration workflow.
     */
    override suspend fun updateWorkflowStep(input: UpdateWorkflowStepRequest): UpdateWorkflowStepResponse {
        val op = SdkHttpOperation.build<UpdateWorkflowStepRequest, UpdateWorkflowStepResponse> {
            serializer = UpdateWorkflowStepOperationSerializer()
            deserializer = UpdateWorkflowStepOperationDeserializer()
            context {
                expectedHttpStatus = 200
                operationName = "UpdateWorkflowStep"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateWorkflowStepRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "migrationhub-orchestrator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateWorkflowStep-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Update the step group in a migration workflow.
     */
    override suspend fun updateWorkflowStepGroup(input: UpdateWorkflowStepGroupRequest): UpdateWorkflowStepGroupResponse {
        val op = SdkHttpOperation.build<UpdateWorkflowStepGroupRequest, UpdateWorkflowStepGroupResponse> {
            serializer = UpdateWorkflowStepGroupOperationSerializer()
            deserializer = UpdateWorkflowStepGroupOperationDeserializer()
            context {
                expectedHttpStatus = 202
                operationName = "UpdateWorkflowStepGroup"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = config.retryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateWorkflowStepGroupRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "migrationhub-orchestrator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateWorkflowStepGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        managedResources.unshareAll()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ClientName, config.clientName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "migrationhub-orchestrator")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
