// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhuborchestrator.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.migrationhuborchestrator.model.GetTemplateStepResponse
import aws.sdk.kotlin.services.migrationhuborchestrator.model.MigrationHubOrchestratorException
import aws.sdk.kotlin.services.migrationhuborchestrator.model.StepActionType
import aws.sdk.kotlin.services.migrationhuborchestrator.model.StepAutomationConfiguration
import aws.sdk.kotlin.services.migrationhuborchestrator.model.StepOutput
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetTemplateStepOperationDeserializer: HttpDeserialize<GetTemplateStepResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetTemplateStepResponse {
        if (!response.status.isSuccess()) {
            throwGetTemplateStepError(context, response)
        }
        val builder = GetTemplateStepResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetTemplateStepOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetTemplateStepError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw MigrationHubOrchestratorException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> MigrationHubOrchestratorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetTemplateStepOperationBody(builder: GetTemplateStepResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CREATIONTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("creationTime"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val ID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("id"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val NEXT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("next"))
    val OUTPUTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("outputs"))
    val PREVIOUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("previous"))
    val STEPACTIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("stepActionType"))
    val STEPAUTOMATIONCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("stepAutomationConfiguration"))
    val STEPGROUPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("stepGroupId"))
    val TEMPLATEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("templateId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CREATIONTIME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ID_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(NEXT_DESCRIPTOR)
        field(OUTPUTS_DESCRIPTOR)
        field(PREVIOUS_DESCRIPTOR)
        field(STEPACTIONTYPE_DESCRIPTOR)
        field(STEPAUTOMATIONCONFIGURATION_DESCRIPTOR)
        field(STEPGROUPID_DESCRIPTOR)
        field(TEMPLATEID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CREATIONTIME_DESCRIPTOR.index -> builder.creationTime = deserializeString()
                DESCRIPTION_DESCRIPTOR.index -> builder.description = deserializeString()
                ID_DESCRIPTOR.index -> builder.id = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                NEXT_DESCRIPTOR.index -> builder.next =
                    deserializer.deserializeList(NEXT_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                OUTPUTS_DESCRIPTOR.index -> builder.outputs =
                    deserializer.deserializeList(OUTPUTS_DESCRIPTOR) {
                        val col0 = mutableListOf<StepOutput>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeStepOutputDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PREVIOUS_DESCRIPTOR.index -> builder.previous =
                    deserializer.deserializeList(PREVIOUS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STEPACTIONTYPE_DESCRIPTOR.index -> builder.stepActionType = deserializeString().let { StepActionType.fromValue(it) }
                STEPAUTOMATIONCONFIGURATION_DESCRIPTOR.index -> builder.stepAutomationConfiguration = deserializeStepAutomationConfigurationDocument(deserializer)
                STEPGROUPID_DESCRIPTOR.index -> builder.stepGroupId = deserializeString()
                TEMPLATEID_DESCRIPTOR.index -> builder.templateId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
