// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhuborchestrator

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.migrationhuborchestrator.endpoints.internal.ResolveEndpointMiddleware
import aws.sdk.kotlin.services.migrationhuborchestrator.endpoints.internal.bindAwsBuiltins
import aws.sdk.kotlin.services.migrationhuborchestrator.model.*
import aws.sdk.kotlin.services.migrationhuborchestrator.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "MigrationHubOrchestrator"
public const val ServiceApiVersion: String = "2021-08-28"
public const val SdkVersion: String = "0.19.1-beta"

internal class DefaultMigrationHubOrchestratorClient(override val config: MigrationHubOrchestratorClient.Config) : MigrationHubOrchestratorClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Create a workflow to orchestrate your migrations.
     */
    override suspend fun createWorkflow(input: CreateWorkflowRequest): CreateWorkflowResponse {
        val op = SdkHttpOperation.build<CreateWorkflowRequest, CreateWorkflowResponse> {
            serializer = CreateWorkflowOperationSerializer()
            deserializer = CreateWorkflowOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateWorkflow"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "migrationhub-orchestrator"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateWorkflow-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Create a step in the migration workflow.
     */
    override suspend fun createWorkflowStep(input: CreateWorkflowStepRequest): CreateWorkflowStepResponse {
        val op = SdkHttpOperation.build<CreateWorkflowStepRequest, CreateWorkflowStepResponse> {
            serializer = CreateWorkflowStepOperationSerializer()
            deserializer = CreateWorkflowStepOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateWorkflowStep"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "migrationhub-orchestrator"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateWorkflowStep-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Create a step group in a migration workflow.
     */
    override suspend fun createWorkflowStepGroup(input: CreateWorkflowStepGroupRequest): CreateWorkflowStepGroupResponse {
        val op = SdkHttpOperation.build<CreateWorkflowStepGroupRequest, CreateWorkflowStepGroupResponse> {
            serializer = CreateWorkflowStepGroupOperationSerializer()
            deserializer = CreateWorkflowStepGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateWorkflowStepGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "migrationhub-orchestrator"
            }
        )
        val rootSpan = config.tracer.createRootSpan("CreateWorkflowStepGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Delete a migration workflow. You must pause a running workflow in Migration Hub Orchestrator console to delete it.
     */
    override suspend fun deleteWorkflow(input: DeleteWorkflowRequest): DeleteWorkflowResponse {
        val op = SdkHttpOperation.build<DeleteWorkflowRequest, DeleteWorkflowResponse> {
            serializer = DeleteWorkflowOperationSerializer()
            deserializer = DeleteWorkflowOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteWorkflow"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "migrationhub-orchestrator"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteWorkflow-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Delete a step in a migration workflow. Pause the workflow to delete a running step.
     */
    override suspend fun deleteWorkflowStep(input: DeleteWorkflowStepRequest): DeleteWorkflowStepResponse {
        val op = SdkHttpOperation.build<DeleteWorkflowStepRequest, DeleteWorkflowStepResponse> {
            serializer = DeleteWorkflowStepOperationSerializer()
            deserializer = DeleteWorkflowStepOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteWorkflowStep"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "migrationhub-orchestrator"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteWorkflowStep-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Delete a step group in a migration workflow.
     */
    override suspend fun deleteWorkflowStepGroup(input: DeleteWorkflowStepGroupRequest): DeleteWorkflowStepGroupResponse {
        val op = SdkHttpOperation.build<DeleteWorkflowStepGroupRequest, DeleteWorkflowStepGroupResponse> {
            serializer = DeleteWorkflowStepGroupOperationSerializer()
            deserializer = DeleteWorkflowStepGroupOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "DeleteWorkflowStepGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "migrationhub-orchestrator"
            }
        )
        val rootSpan = config.tracer.createRootSpan("DeleteWorkflowStepGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Get the template you want to use for creating a migration workflow.
     */
    override suspend fun getTemplate(input: GetTemplateRequest): GetTemplateResponse {
        val op = SdkHttpOperation.build<GetTemplateRequest, GetTemplateResponse> {
            serializer = GetTemplateOperationSerializer()
            deserializer = GetTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTemplate"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "migrationhub-orchestrator"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Get a specific step in a template.
     */
    override suspend fun getTemplateStep(input: GetTemplateStepRequest): GetTemplateStepResponse {
        val op = SdkHttpOperation.build<GetTemplateStepRequest, GetTemplateStepResponse> {
            serializer = GetTemplateStepOperationSerializer()
            deserializer = GetTemplateStepOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTemplateStep"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "migrationhub-orchestrator"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetTemplateStep-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Get a step group in a template.
     */
    override suspend fun getTemplateStepGroup(input: GetTemplateStepGroupRequest): GetTemplateStepGroupResponse {
        val op = SdkHttpOperation.build<GetTemplateStepGroupRequest, GetTemplateStepGroupResponse> {
            serializer = GetTemplateStepGroupOperationSerializer()
            deserializer = GetTemplateStepGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetTemplateStepGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "migrationhub-orchestrator"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetTemplateStepGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Get migration workflow.
     */
    override suspend fun getWorkflow(input: GetWorkflowRequest): GetWorkflowResponse {
        val op = SdkHttpOperation.build<GetWorkflowRequest, GetWorkflowResponse> {
            serializer = GetWorkflowOperationSerializer()
            deserializer = GetWorkflowOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetWorkflow"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "migrationhub-orchestrator"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetWorkflow-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Get a step in the migration workflow.
     */
    override suspend fun getWorkflowStep(input: GetWorkflowStepRequest): GetWorkflowStepResponse {
        val op = SdkHttpOperation.build<GetWorkflowStepRequest, GetWorkflowStepResponse> {
            serializer = GetWorkflowStepOperationSerializer()
            deserializer = GetWorkflowStepOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetWorkflowStep"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "migrationhub-orchestrator"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetWorkflowStep-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Get the step group of a migration workflow.
     */
    override suspend fun getWorkflowStepGroup(input: GetWorkflowStepGroupRequest): GetWorkflowStepGroupResponse {
        val op = SdkHttpOperation.build<GetWorkflowStepGroupRequest, GetWorkflowStepGroupResponse> {
            serializer = GetWorkflowStepGroupOperationSerializer()
            deserializer = GetWorkflowStepGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetWorkflowStepGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "migrationhub-orchestrator"
            }
        )
        val rootSpan = config.tracer.createRootSpan("GetWorkflowStepGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * List AWS Migration Hub Orchestrator plugins.
     */
    override suspend fun listPlugins(input: ListPluginsRequest): ListPluginsResponse {
        val op = SdkHttpOperation.build<ListPluginsRequest, ListPluginsResponse> {
            serializer = ListPluginsOperationSerializer()
            deserializer = ListPluginsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListPlugins"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "migrationhub-orchestrator"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListPlugins-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * List the tags added to a resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "migrationhub-orchestrator"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListTagsForResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * List the step groups in a template.
     */
    override suspend fun listTemplateStepGroups(input: ListTemplateStepGroupsRequest): ListTemplateStepGroupsResponse {
        val op = SdkHttpOperation.build<ListTemplateStepGroupsRequest, ListTemplateStepGroupsResponse> {
            serializer = ListTemplateStepGroupsOperationSerializer()
            deserializer = ListTemplateStepGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTemplateStepGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "migrationhub-orchestrator"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListTemplateStepGroups-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * List the steps in a template.
     */
    override suspend fun listTemplateSteps(input: ListTemplateStepsRequest): ListTemplateStepsResponse {
        val op = SdkHttpOperation.build<ListTemplateStepsRequest, ListTemplateStepsResponse> {
            serializer = ListTemplateStepsOperationSerializer()
            deserializer = ListTemplateStepsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTemplateSteps"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "migrationhub-orchestrator"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListTemplateSteps-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * List the templates available in Migration Hub Orchestrator to create a migration workflow.
     */
    override suspend fun listTemplates(input: ListTemplatesRequest): ListTemplatesResponse {
        val op = SdkHttpOperation.build<ListTemplatesRequest, ListTemplatesResponse> {
            serializer = ListTemplatesOperationSerializer()
            deserializer = ListTemplatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTemplates"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "migrationhub-orchestrator"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListTemplates-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * List the step groups in a migration workflow.
     */
    override suspend fun listWorkflowStepGroups(input: ListWorkflowStepGroupsRequest): ListWorkflowStepGroupsResponse {
        val op = SdkHttpOperation.build<ListWorkflowStepGroupsRequest, ListWorkflowStepGroupsResponse> {
            serializer = ListWorkflowStepGroupsOperationSerializer()
            deserializer = ListWorkflowStepGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListWorkflowStepGroups"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "migrationhub-orchestrator"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListWorkflowStepGroups-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * List the steps in a workflow.
     */
    override suspend fun listWorkflowSteps(input: ListWorkflowStepsRequest): ListWorkflowStepsResponse {
        val op = SdkHttpOperation.build<ListWorkflowStepsRequest, ListWorkflowStepsResponse> {
            serializer = ListWorkflowStepsOperationSerializer()
            deserializer = ListWorkflowStepsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListWorkflowSteps"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "migrationhub-orchestrator"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListWorkflowSteps-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * List the migration workflows.
     */
    override suspend fun listWorkflows(input: ListWorkflowsRequest): ListWorkflowsResponse {
        val op = SdkHttpOperation.build<ListWorkflowsRequest, ListWorkflowsResponse> {
            serializer = ListWorkflowsOperationSerializer()
            deserializer = ListWorkflowsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListWorkflows"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "migrationhub-orchestrator"
            }
        )
        val rootSpan = config.tracer.createRootSpan("ListWorkflows-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Retry a failed step in a migration workflow.
     */
    override suspend fun retryWorkflowStep(input: RetryWorkflowStepRequest): RetryWorkflowStepResponse {
        val op = SdkHttpOperation.build<RetryWorkflowStepRequest, RetryWorkflowStepResponse> {
            serializer = RetryWorkflowStepOperationSerializer()
            deserializer = RetryWorkflowStepOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RetryWorkflowStep"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "migrationhub-orchestrator"
            }
        )
        val rootSpan = config.tracer.createRootSpan("RetryWorkflowStep-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Start a migration workflow.
     */
    override suspend fun startWorkflow(input: StartWorkflowRequest): StartWorkflowResponse {
        val op = SdkHttpOperation.build<StartWorkflowRequest, StartWorkflowResponse> {
            serializer = StartWorkflowOperationSerializer()
            deserializer = StartWorkflowOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartWorkflow"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "migrationhub-orchestrator"
            }
        )
        val rootSpan = config.tracer.createRootSpan("StartWorkflow-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Stop an ongoing migration workflow.
     */
    override suspend fun stopWorkflow(input: StopWorkflowRequest): StopWorkflowResponse {
        val op = SdkHttpOperation.build<StopWorkflowRequest, StopWorkflowResponse> {
            serializer = StopWorkflowOperationSerializer()
            deserializer = StopWorkflowOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopWorkflow"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "migrationhub-orchestrator"
            }
        )
        val rootSpan = config.tracer.createRootSpan("StopWorkflow-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Tag a resource by specifying its Amazon Resource Name (ARN).
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "migrationhub-orchestrator"
            }
        )
        val rootSpan = config.tracer.createRootSpan("TagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes the tags for a resource.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "migrationhub-orchestrator"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UntagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Update a migration workflow.
     */
    override suspend fun updateWorkflow(input: UpdateWorkflowRequest): UpdateWorkflowResponse {
        val op = SdkHttpOperation.build<UpdateWorkflowRequest, UpdateWorkflowResponse> {
            serializer = UpdateWorkflowOperationSerializer()
            deserializer = UpdateWorkflowOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateWorkflow"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "migrationhub-orchestrator"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdateWorkflow-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Update a step in a migration workflow.
     */
    override suspend fun updateWorkflowStep(input: UpdateWorkflowStepRequest): UpdateWorkflowStepResponse {
        val op = SdkHttpOperation.build<UpdateWorkflowStepRequest, UpdateWorkflowStepResponse> {
            serializer = UpdateWorkflowStepOperationSerializer()
            deserializer = UpdateWorkflowStepOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateWorkflowStep"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "migrationhub-orchestrator"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdateWorkflowStep-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Update the step group in a migration workflow.
     */
    override suspend fun updateWorkflowStepGroup(input: UpdateWorkflowStepGroupRequest): UpdateWorkflowStepGroupResponse {
        val op = SdkHttpOperation.build<UpdateWorkflowStepGroupRequest, UpdateWorkflowStepGroupResponse> {
            serializer = UpdateWorkflowStepGroupOperationSerializer()
            deserializer = UpdateWorkflowStepGroupOperationDeserializer()
            context {
                expectedHttpStatus = 202
                service = serviceName
                operationName = "UpdateWorkflowStepGroup"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveEndpointMiddleware(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "migrationhub-orchestrator"
            }
        )
        val rootSpan = config.tracer.createRootSpan("UpdateWorkflowStepGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "migrationhub-orchestrator")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
