// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhubconfig.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.migrationhubconfig.model.CreateHomeRegionControlResponse
import aws.sdk.kotlin.services.migrationhubconfig.model.MigrationHubConfigException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateHomeRegionControlOperationDeserializer: HttpDeserialize<CreateHomeRegionControlResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateHomeRegionControlResponse {
        if (!response.status.isSuccess()) {
            throwCreateHomeRegionControlError(context, response)
        }
        val builder = CreateHomeRegionControlResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateHomeRegionControlOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeCreateHomeRegionControlOperationBody(builder: CreateHomeRegionControlResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val HOMEREGIONCONTROL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("HomeRegionControl"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(HOMEREGIONCONTROL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                HOMEREGIONCONTROL_DESCRIPTOR.index -> builder.homeRegionControl = deserializeHomeRegionControlDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwCreateHomeRegionControlError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer()
        "DryRunOperation" -> DryRunOperationDeserializer()
        "InternalServerError" -> InternalServerErrorDeserializer()
        "InvalidInputException" -> InvalidInputExceptionDeserializer()
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer()
        "ThrottlingException" -> ThrottlingExceptionDeserializer()
        else -> throw MigrationHubConfigException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, response)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
