// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhubconfig.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A home region control is an object that specifies the home region for an account, with
 * some additional information. It contains a target (always of type ACCOUNT), an
 * ID, and a time at which the home region was set.
 */
class HomeRegionControl private constructor(builder: BuilderImpl) {
    /**
     * A unique identifier that's generated for each home region control. It's always a string
     * that begins with "hrc-" followed by 12 lowercase letters and numbers.
     */
    val controlId: String? = builder.controlId
    /**
     * The AWS Region that's been set as home region. For example, "us-west-2" or "eu-central-1"
     * are valid home regions.
     */
    val homeRegion: String? = builder.homeRegion
    /**
     * A timestamp representing the time when the customer called
     * CreateHomeregionControl and set the home region for the account.
     */
    val requestedTime: Instant? = builder.requestedTime
    /**
     * The target parameter specifies the identifier to which the home region is applied, which
     * is always an ACCOUNT. It applies the home region to the current
     * ACCOUNT.
     */
    val target: Target? = builder.target

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): HomeRegionControl = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("HomeRegionControl(")
        append("controlId=$controlId,")
        append("homeRegion=$homeRegion,")
        append("requestedTime=$requestedTime,")
        append("target=$target)")
    }

    override fun hashCode(): kotlin.Int {
        var result = controlId?.hashCode() ?: 0
        result = 31 * result + (homeRegion?.hashCode() ?: 0)
        result = 31 * result + (requestedTime?.hashCode() ?: 0)
        result = 31 * result + (target?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as HomeRegionControl

        if (controlId != other.controlId) return false
        if (homeRegion != other.homeRegion) return false
        if (requestedTime != other.requestedTime) return false
        if (target != other.target) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): HomeRegionControl = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): HomeRegionControl
        /**
         * A unique identifier that's generated for each home region control. It's always a string
         * that begins with "hrc-" followed by 12 lowercase letters and numbers.
         */
        fun controlId(controlId: String): FluentBuilder
        /**
         * The AWS Region that's been set as home region. For example, "us-west-2" or "eu-central-1"
         * are valid home regions.
         */
        fun homeRegion(homeRegion: String): FluentBuilder
        /**
         * A timestamp representing the time when the customer called
         * CreateHomeregionControl and set the home region for the account.
         */
        fun requestedTime(requestedTime: Instant): FluentBuilder
        /**
         * The target parameter specifies the identifier to which the home region is applied, which
         * is always an ACCOUNT. It applies the home region to the current
         * ACCOUNT.
         */
        fun target(target: Target): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A unique identifier that's generated for each home region control. It's always a string
         * that begins with "hrc-" followed by 12 lowercase letters and numbers.
         */
        var controlId: String?
        /**
         * The AWS Region that's been set as home region. For example, "us-west-2" or "eu-central-1"
         * are valid home regions.
         */
        var homeRegion: String?
        /**
         * A timestamp representing the time when the customer called
         * CreateHomeregionControl and set the home region for the account.
         */
        var requestedTime: Instant?
        /**
         * The target parameter specifies the identifier to which the home region is applied, which
         * is always an ACCOUNT. It applies the home region to the current
         * ACCOUNT.
         */
        var target: Target?

        fun build(): HomeRegionControl
        /**
         * construct an [aws.sdk.kotlin.services.migrationhubconfig.model.Target] inside the given [block]
         */
        fun target(block: Target.DslBuilder.() -> kotlin.Unit) {
            this.target = Target.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var controlId: String? = null
        override var homeRegion: String? = null
        override var requestedTime: Instant? = null
        override var target: Target? = null

        constructor(x: HomeRegionControl) : this() {
            this.controlId = x.controlId
            this.homeRegion = x.homeRegion
            this.requestedTime = x.requestedTime
            this.target = x.target
        }

        override fun build(): HomeRegionControl = HomeRegionControl(this)
        override fun controlId(controlId: String): FluentBuilder = apply { this.controlId = controlId }
        override fun homeRegion(homeRegion: String): FluentBuilder = apply { this.homeRegion = homeRegion }
        override fun requestedTime(requestedTime: Instant): FluentBuilder = apply { this.requestedTime = requestedTime }
        override fun target(target: Target): FluentBuilder = apply { this.target = target }
    }
}
