// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhubconfig.model



class DescribeHomeRegionControlsRequest private constructor(builder: BuilderImpl) {
    /**
     * The ControlID is a unique identifier string of your
     * HomeRegionControl object.
     */
    val controlId: String? = builder.controlId
    /**
     * The name of the home region you'd like to view.
     */
    val homeRegion: String? = builder.homeRegion
    /**
     * The maximum number of filtering results to display per page.
     */
    val maxResults: Int? = builder.maxResults
    /**
     * If a NextToken was returned by a previous call, more results are available.
     * To retrieve the next page of results, make the call again using the returned token in
     * NextToken.
     */
    val nextToken: String? = builder.nextToken
    /**
     * The target parameter specifies the identifier to which the home region is applied, which
     * is always of type ACCOUNT. It applies the home region to the current
     * ACCOUNT.
     */
    val target: Target? = builder.target

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeHomeRegionControlsRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeHomeRegionControlsRequest(")
        append("controlId=$controlId,")
        append("homeRegion=$homeRegion,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("target=$target)")
    }

    override fun hashCode(): kotlin.Int {
        var result = controlId?.hashCode() ?: 0
        result = 31 * result + (homeRegion?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (target?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeHomeRegionControlsRequest

        if (controlId != other.controlId) return false
        if (homeRegion != other.homeRegion) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (target != other.target) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeHomeRegionControlsRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeHomeRegionControlsRequest
        /**
         * The ControlID is a unique identifier string of your
         * HomeRegionControl object.
         */
        fun controlId(controlId: String): FluentBuilder
        /**
         * The name of the home region you'd like to view.
         */
        fun homeRegion(homeRegion: String): FluentBuilder
        /**
         * The maximum number of filtering results to display per page.
         */
        fun maxResults(maxResults: Int): FluentBuilder
        /**
         * If a NextToken was returned by a previous call, more results are available.
         * To retrieve the next page of results, make the call again using the returned token in
         * NextToken.
         */
        fun nextToken(nextToken: String): FluentBuilder
        /**
         * The target parameter specifies the identifier to which the home region is applied, which
         * is always of type ACCOUNT. It applies the home region to the current
         * ACCOUNT.
         */
        fun target(target: Target): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ControlID is a unique identifier string of your
         * HomeRegionControl object.
         */
        var controlId: String?
        /**
         * The name of the home region you'd like to view.
         */
        var homeRegion: String?
        /**
         * The maximum number of filtering results to display per page.
         */
        var maxResults: Int?
        /**
         * If a NextToken was returned by a previous call, more results are available.
         * To retrieve the next page of results, make the call again using the returned token in
         * NextToken.
         */
        var nextToken: String?
        /**
         * The target parameter specifies the identifier to which the home region is applied, which
         * is always of type ACCOUNT. It applies the home region to the current
         * ACCOUNT.
         */
        var target: Target?

        fun build(): DescribeHomeRegionControlsRequest
        /**
         * construct an [aws.sdk.kotlin.services.migrationhubconfig.model.Target] inside the given [block]
         */
        fun target(block: Target.DslBuilder.() -> kotlin.Unit) {
            this.target = Target.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var controlId: String? = null
        override var homeRegion: String? = null
        override var maxResults: Int? = null
        override var nextToken: String? = null
        override var target: Target? = null

        constructor(x: DescribeHomeRegionControlsRequest) : this() {
            this.controlId = x.controlId
            this.homeRegion = x.homeRegion
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.target = x.target
        }

        override fun build(): DescribeHomeRegionControlsRequest = DescribeHomeRegionControlsRequest(this)
        override fun controlId(controlId: String): FluentBuilder = apply { this.controlId = controlId }
        override fun homeRegion(homeRegion: String): FluentBuilder = apply { this.homeRegion = homeRegion }
        override fun maxResults(maxResults: Int): FluentBuilder = apply { this.maxResults = maxResults }
        override fun nextToken(nextToken: String): FluentBuilder = apply { this.nextToken = nextToken }
        override fun target(target: Target): FluentBuilder = apply { this.target = target }
    }
}
