// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhubconfig

import aws.sdk.kotlin.runtime.auth.AuthConfig
import aws.sdk.kotlin.runtime.auth.CredentialsProvider
import aws.sdk.kotlin.runtime.endpoint.EndpointResolver
import aws.sdk.kotlin.runtime.regions.RegionConfig
import aws.sdk.kotlin.services.migrationhubconfig.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine

/**
 * The AWS Migration Hub home region APIs are available specifically for working with your
 * Migration Hub home region. You can use these APIs to determine a home region, as well as to
 * create and work with controls that describe the home region.
 * You must make API calls for write actions (create, notify, associate, disassociate,
 * import, or put) while in your home region, or a HomeRegionNotSetException
 * error is returned.
 * API calls for read actions (list, describe, stop, and delete) are permitted outside of
 * your home region.
 * If you call a write API outside the home region, an InvalidInputException
 * is returned.
 * You can call GetHomeRegion action to obtain the account's Migration Hub
 * home region.
 * For specific API usage, see the sections that follow in this AWS Migration Hub Home Region
 * API reference.
 */
interface MigrationHubConfigClient : SdkClient {

    override val serviceName: String
        get() = "MigrationHub Config"
    /**
     * MigrationHubConfigClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(block: Config.DslBuilder.() -> Unit = {}): MigrationHubConfigClient {
            val config = Config.BuilderImpl().apply(block).build()
            return DefaultMigrationHubConfigClient(config)
        }
    }

    class Config private constructor(builder: BuilderImpl): AuthConfig, HttpClientConfig, RegionConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider? = builder.credentialsProvider
        val endpointResolver: EndpointResolver? = builder.endpointResolver
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String? = builder.region
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        override val signingRegion: String? = builder.signingRegion

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun signingRegion(signingRegion: String): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: EndpointResolver?

            /**
             * Override the default HTTP client configuration (e.g. configure proxy behavior, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

            /**
             * AWS region to be used for signing the request. This is not necessarily the same as `region`
             * in the case of global services like IAM
             */
            var signingRegion: String?

            fun build(): Config
        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: EndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default
            override var signingRegion: String? = null

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: EndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
            override fun signingRegion(signingRegion: String): FluentBuilder = apply { this.signingRegion = signingRegion }
        }
    }

    /**
     * This API sets up the home region for the calling account only.
     */
    suspend fun createHomeRegionControl(input: CreateHomeRegionControlRequest): CreateHomeRegionControlResponse

    /**
     * This API sets up the home region for the calling account only.
     */
    suspend fun createHomeRegionControl(block: CreateHomeRegionControlRequest.DslBuilder.() -> Unit) = createHomeRegionControl(CreateHomeRegionControlRequest.builder().apply(block).build())

    /**
     * This API permits filtering on the ControlId and HomeRegion
     * fields.
     */
    suspend fun describeHomeRegionControls(input: DescribeHomeRegionControlsRequest): DescribeHomeRegionControlsResponse

    /**
     * This API permits filtering on the ControlId and HomeRegion
     * fields.
     */
    suspend fun describeHomeRegionControls(block: DescribeHomeRegionControlsRequest.DslBuilder.() -> Unit) = describeHomeRegionControls(DescribeHomeRegionControlsRequest.builder().apply(block).build())

    /**
     * Returns the calling account’s home region, if configured. This API is used by other AWS
     * services to determine the regional endpoint for calling AWS Application Discovery Service and
     * Migration Hub. You must call GetHomeRegion at least once before you call any
     * other AWS Application Discovery Service and AWS Migration Hub APIs, to obtain the account's
     * Migration Hub home region.
     */
    suspend fun getHomeRegion(input: GetHomeRegionRequest): GetHomeRegionResponse

    /**
     * Returns the calling account’s home region, if configured. This API is used by other AWS
     * services to determine the regional endpoint for calling AWS Application Discovery Service and
     * Migration Hub. You must call GetHomeRegion at least once before you call any
     * other AWS Application Discovery Service and AWS Migration Hub APIs, to obtain the account's
     * Migration Hub home region.
     */
    suspend fun getHomeRegion(block: GetHomeRegionRequest.DslBuilder.() -> Unit) = getHomeRegion(GetHomeRegionRequest.builder().apply(block).build())
}
