// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhubconfig

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.runtime.regions.resolveRegionForOperation
import aws.sdk.kotlin.services.migrationhubconfig.model.*
import aws.sdk.kotlin.services.migrationhubconfig.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngineConfig
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "MigrationHub Config"
const val ServiceApiVersion: String = "2019-06-30"
const val SdkVersion: String = "0.4.0-alpha"

internal class DefaultMigrationHubConfigClient(override val config: MigrationHubConfigClient.Config) : MigrationHubConfigClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine(HttpClientEngineConfig())
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }

    /**
     * This API sets up the home region for the calling account only.
     */
    override suspend fun createHomeRegionControl(input: CreateHomeRegionControlRequest): CreateHomeRegionControlResponse {
        val op = SdkHttpOperation.build<CreateHomeRegionControlRequest, CreateHomeRegionControlResponse> {
            serializer = CreateHomeRegionControlOperationSerializer()
            deserializer = CreateHomeRegionControlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateHomeRegionControl"
            }
        }
        registerCreateHomeRegionControlMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * This API permits filtering on the ControlId and HomeRegion
     * fields.
     */
    override suspend fun describeHomeRegionControls(input: DescribeHomeRegionControlsRequest): DescribeHomeRegionControlsResponse {
        val op = SdkHttpOperation.build<DescribeHomeRegionControlsRequest, DescribeHomeRegionControlsResponse> {
            serializer = DescribeHomeRegionControlsOperationSerializer()
            deserializer = DescribeHomeRegionControlsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeHomeRegionControls"
            }
        }
        registerDescribeHomeRegionControlsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the calling account’s home region, if configured. This API is used by other AWS
     * services to determine the regional endpoint for calling AWS Application Discovery Service and
     * Migration Hub. You must call GetHomeRegion at least once before you call any
     * other AWS Application Discovery Service and AWS Migration Hub APIs, to obtain the account's
     * Migration Hub home region.
     */
    override suspend fun getHomeRegion(input: GetHomeRegionRequest): GetHomeRegionResponse {
        val op = SdkHttpOperation.build<GetHomeRegionRequest, GetHomeRegionResponse> {
            serializer = GetHomeRegionOperationSerializer()
            deserializer = GetHomeRegionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetHomeRegion"
            }
        }
        registerGetHomeRegionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        val region = resolveRegionForOperation(ctx, config)
        ctx.putIfAbsent(AwsClientOption.Region, region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.signingRegion ?: region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
    }
}
