// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhubconfig.paginators

import aws.sdk.kotlin.services.migrationhubconfig.MigrationHubConfigClient
import aws.sdk.kotlin.services.migrationhubconfig.model.DescribeHomeRegionControlsRequest
import aws.sdk.kotlin.services.migrationhubconfig.model.DescribeHomeRegionControlsResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [DescribeHomeRegionControlsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeHomeRegionControlsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeHomeRegionControlsResponse]
 */
public fun MigrationHubConfigClient.describeHomeRegionControlsPaginated(initialRequest: DescribeHomeRegionControlsRequest = DescribeHomeRegionControlsRequest { }): Flow<DescribeHomeRegionControlsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeHomeRegionControlsPaginated.describeHomeRegionControls(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeHomeRegionControlsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeHomeRegionControlsResponse]
 */
public fun MigrationHubConfigClient.describeHomeRegionControlsPaginated(block: DescribeHomeRegionControlsRequest.Builder.() -> Unit): Flow<DescribeHomeRegionControlsResponse> =
    describeHomeRegionControlsPaginated(DescribeHomeRegionControlsRequest.Builder().apply(block).build())
