// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhubconfig.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A home region control is an object that specifies the home region for an account, with some additional information. It contains a target (always of type `ACCOUNT`), an ID, and a time at which the home region was set.
 */
public class HomeRegionControl private constructor(builder: Builder) {
    /**
     * A unique identifier that's generated for each home region control. It's always a string that begins with "hrc-" followed by 12 lowercase letters and numbers.
     */
    public val controlId: kotlin.String? = builder.controlId
    /**
     * The AWS Region that's been set as home region. For example, "us-west-2" or "eu-central-1" are valid home regions.
     */
    public val homeRegion: kotlin.String? = builder.homeRegion
    /**
     * A timestamp representing the time when the customer called `CreateHomeregionControl` and set the home region for the account.
     */
    public val requestedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.requestedTime
    /**
     * The target parameter specifies the identifier to which the home region is applied, which is always an `ACCOUNT`. It applies the home region to the current `ACCOUNT`.
     */
    public val target: aws.sdk.kotlin.services.migrationhubconfig.model.Target? = builder.target

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.migrationhubconfig.model.HomeRegionControl = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("HomeRegionControl(")
        append("controlId=$controlId,")
        append("homeRegion=$homeRegion,")
        append("requestedTime=$requestedTime,")
        append("target=$target")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = controlId?.hashCode() ?: 0
        result = 31 * result + (homeRegion?.hashCode() ?: 0)
        result = 31 * result + (requestedTime?.hashCode() ?: 0)
        result = 31 * result + (target?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as HomeRegionControl

        if (controlId != other.controlId) return false
        if (homeRegion != other.homeRegion) return false
        if (requestedTime != other.requestedTime) return false
        if (target != other.target) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.migrationhubconfig.model.HomeRegionControl = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A unique identifier that's generated for each home region control. It's always a string that begins with "hrc-" followed by 12 lowercase letters and numbers.
         */
        public var controlId: kotlin.String? = null
        /**
         * The AWS Region that's been set as home region. For example, "us-west-2" or "eu-central-1" are valid home regions.
         */
        public var homeRegion: kotlin.String? = null
        /**
         * A timestamp representing the time when the customer called `CreateHomeregionControl` and set the home region for the account.
         */
        public var requestedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The target parameter specifies the identifier to which the home region is applied, which is always an `ACCOUNT`. It applies the home region to the current `ACCOUNT`.
         */
        public var target: aws.sdk.kotlin.services.migrationhubconfig.model.Target? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.migrationhubconfig.model.HomeRegionControl) : this() {
            this.controlId = x.controlId
            this.homeRegion = x.homeRegion
            this.requestedTime = x.requestedTime
            this.target = x.target
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.migrationhubconfig.model.HomeRegionControl = HomeRegionControl(this)

        /**
         * construct an [aws.sdk.kotlin.services.migrationhubconfig.model.Target] inside the given [block]
         */
        public fun target(block: aws.sdk.kotlin.services.migrationhubconfig.model.Target.Builder.() -> kotlin.Unit) {
            this.target = aws.sdk.kotlin.services.migrationhubconfig.model.Target.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
