// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhub.model



class PutResourceAttributesRequest private constructor(builder: Builder) {
    /**
     * Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call.
     */
    val dryRun: kotlin.Boolean = builder.dryRun
    /**
     * Unique identifier that references the migration task. *Do not store personal data in this field.*
     */
    val migrationTaskName: kotlin.String? = builder.migrationTaskName
    /**
     * The name of the ProgressUpdateStream.
     */
    val progressUpdateStream: kotlin.String? = builder.progressUpdateStream
    /**
     * Information about the resource that is being migrated. This data will be used to map the task to a resource in the Application Discovery Service repository.
     *
     * Takes the object array of `ResourceAttribute` where the `Type` field is reserved for the following values: `IPV4_ADDRESS | IPV6_ADDRESS | MAC_ADDRESS | FQDN | VM_MANAGER_ID | VM_MANAGED_OBJECT_REFERENCE | VM_NAME | VM_PATH | BIOS_ID | MOTHERBOARD_SERIAL_NUMBER` where the identifying value can be a string up to 256 characters.
     *
     * + If any "VM" related value is set for a `ResourceAttribute` object, it is required that `VM_MANAGER_ID`, as a minimum, is always set. If `VM_MANAGER_ID` is not set, then all "VM" fields will be discarded and "VM" fields will not be used for matching the migration task to a server in Application Discovery Service repository. See the [Example](https://docs.aws.amazon.com/migrationhub/latest/ug/API_PutResourceAttributes.html#API_PutResourceAttributes_Examples) section below for a use case of specifying "VM" related values.
     * +  If a server you are trying to match has multiple IP or MAC addresses, you should provide as many as you know in separate type/value pairs passed to the `ResourceAttributeList` parameter to maximize the chances of matching.
     */
    val resourceAttributeList: List<ResourceAttribute>? = builder.resourceAttributeList

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.migrationhub.model.PutResourceAttributesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutResourceAttributesRequest(")
        append("dryRun=$dryRun,")
        append("migrationTaskName=$migrationTaskName,")
        append("progressUpdateStream=$progressUpdateStream,")
        append("resourceAttributeList=$resourceAttributeList)")
    }

    override fun hashCode(): kotlin.Int {
        var result = dryRun.hashCode()
        result = 31 * result + (migrationTaskName?.hashCode() ?: 0)
        result = 31 * result + (progressUpdateStream?.hashCode() ?: 0)
        result = 31 * result + (resourceAttributeList?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutResourceAttributesRequest

        if (dryRun != other.dryRun) return false
        if (migrationTaskName != other.migrationTaskName) return false
        if (progressUpdateStream != other.progressUpdateStream) return false
        if (resourceAttributeList != other.resourceAttributeList) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.migrationhub.model.PutResourceAttributesRequest = Builder(this).apply(block).build()

    class Builder {
        /**
         * Optional boolean flag to indicate whether any effect should take place. Used to test if the caller has permission to make the call.
         */
        var dryRun: kotlin.Boolean = false
        /**
         * Unique identifier that references the migration task. *Do not store personal data in this field.*
         */
        var migrationTaskName: kotlin.String? = null
        /**
         * The name of the ProgressUpdateStream.
         */
        var progressUpdateStream: kotlin.String? = null
        /**
         * Information about the resource that is being migrated. This data will be used to map the task to a resource in the Application Discovery Service repository.
         *
         * Takes the object array of `ResourceAttribute` where the `Type` field is reserved for the following values: `IPV4_ADDRESS | IPV6_ADDRESS | MAC_ADDRESS | FQDN | VM_MANAGER_ID | VM_MANAGED_OBJECT_REFERENCE | VM_NAME | VM_PATH | BIOS_ID | MOTHERBOARD_SERIAL_NUMBER` where the identifying value can be a string up to 256 characters.
         *
         * + If any "VM" related value is set for a `ResourceAttribute` object, it is required that `VM_MANAGER_ID`, as a minimum, is always set. If `VM_MANAGER_ID` is not set, then all "VM" fields will be discarded and "VM" fields will not be used for matching the migration task to a server in Application Discovery Service repository. See the [Example](https://docs.aws.amazon.com/migrationhub/latest/ug/API_PutResourceAttributes.html#API_PutResourceAttributes_Examples) section below for a use case of specifying "VM" related values.
         * +  If a server you are trying to match has multiple IP or MAC addresses, you should provide as many as you know in separate type/value pairs passed to the `ResourceAttributeList` parameter to maximize the chances of matching.
         */
        var resourceAttributeList: List<ResourceAttribute>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.migrationhub.model.PutResourceAttributesRequest) : this() {
            this.dryRun = x.dryRun
            this.migrationTaskName = x.migrationTaskName
            this.progressUpdateStream = x.progressUpdateStream
            this.resourceAttributeList = x.resourceAttributeList
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.migrationhub.model.PutResourceAttributesRequest = PutResourceAttributesRequest(this)
    }
}
