// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhub.paginators

import aws.sdk.kotlin.services.migrationhub.MigrationHubClient
import aws.sdk.kotlin.services.migrationhub.model.ApplicationState
import aws.sdk.kotlin.services.migrationhub.model.CreatedArtifact
import aws.sdk.kotlin.services.migrationhub.model.DiscoveredResource
import aws.sdk.kotlin.services.migrationhub.model.ListApplicationStatesRequest
import aws.sdk.kotlin.services.migrationhub.model.ListApplicationStatesResponse
import aws.sdk.kotlin.services.migrationhub.model.ListCreatedArtifactsRequest
import aws.sdk.kotlin.services.migrationhub.model.ListCreatedArtifactsResponse
import aws.sdk.kotlin.services.migrationhub.model.ListDiscoveredResourcesRequest
import aws.sdk.kotlin.services.migrationhub.model.ListDiscoveredResourcesResponse
import aws.sdk.kotlin.services.migrationhub.model.ListMigrationTasksRequest
import aws.sdk.kotlin.services.migrationhub.model.ListMigrationTasksResponse
import aws.sdk.kotlin.services.migrationhub.model.ListProgressUpdateStreamsRequest
import aws.sdk.kotlin.services.migrationhub.model.ListProgressUpdateStreamsResponse
import aws.sdk.kotlin.services.migrationhub.model.MigrationTaskSummary
import aws.sdk.kotlin.services.migrationhub.model.ProgressUpdateStreamSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListApplicationStatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListApplicationStatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationStatesResponse]
 */
fun MigrationHubClient.listApplicationStatesPaginated(initialRequest: ListApplicationStatesRequest): Flow<ListApplicationStatesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listApplicationStatesPaginated.listApplicationStates(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListApplicationStatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationStatesResponse]
 */
fun MigrationHubClient.listApplicationStatesPaginated(block: ListApplicationStatesRequest.Builder.() -> Unit): Flow<ListApplicationStatesResponse> =
    listApplicationStatesPaginated(ListApplicationStatesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listApplicationStatesPaginated]
 * to access the nested member [ApplicationState]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ApplicationState]
 */
@JvmName("listApplicationStatesResponseApplicationState")
fun Flow<ListApplicationStatesResponse>.applicationStateList(): Flow<ApplicationState> =
    transform() { response ->
        response.applicationStateList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCreatedArtifactsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCreatedArtifactsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCreatedArtifactsResponse]
 */
fun MigrationHubClient.listCreatedArtifactsPaginated(initialRequest: ListCreatedArtifactsRequest): Flow<ListCreatedArtifactsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCreatedArtifactsPaginated.listCreatedArtifacts(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListCreatedArtifactsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCreatedArtifactsResponse]
 */
fun MigrationHubClient.listCreatedArtifactsPaginated(block: ListCreatedArtifactsRequest.Builder.() -> Unit): Flow<ListCreatedArtifactsResponse> =
    listCreatedArtifactsPaginated(ListCreatedArtifactsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCreatedArtifactsPaginated]
 * to access the nested member [CreatedArtifact]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CreatedArtifact]
 */
@JvmName("listCreatedArtifactsResponseCreatedArtifact")
fun Flow<ListCreatedArtifactsResponse>.createdArtifactList(): Flow<CreatedArtifact> =
    transform() { response ->
        response.createdArtifactList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDiscoveredResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDiscoveredResourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDiscoveredResourcesResponse]
 */
fun MigrationHubClient.listDiscoveredResourcesPaginated(initialRequest: ListDiscoveredResourcesRequest): Flow<ListDiscoveredResourcesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDiscoveredResourcesPaginated.listDiscoveredResources(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListDiscoveredResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDiscoveredResourcesResponse]
 */
fun MigrationHubClient.listDiscoveredResourcesPaginated(block: ListDiscoveredResourcesRequest.Builder.() -> Unit): Flow<ListDiscoveredResourcesResponse> =
    listDiscoveredResourcesPaginated(ListDiscoveredResourcesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDiscoveredResourcesPaginated]
 * to access the nested member [DiscoveredResource]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DiscoveredResource]
 */
@JvmName("listDiscoveredResourcesResponseDiscoveredResource")
fun Flow<ListDiscoveredResourcesResponse>.discoveredResourceList(): Flow<DiscoveredResource> =
    transform() { response ->
        response.discoveredResourceList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListMigrationTasksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMigrationTasksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMigrationTasksResponse]
 */
fun MigrationHubClient.listMigrationTasksPaginated(initialRequest: ListMigrationTasksRequest): Flow<ListMigrationTasksResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMigrationTasksPaginated.listMigrationTasks(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListMigrationTasksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMigrationTasksResponse]
 */
fun MigrationHubClient.listMigrationTasksPaginated(block: ListMigrationTasksRequest.Builder.() -> Unit): Flow<ListMigrationTasksResponse> =
    listMigrationTasksPaginated(ListMigrationTasksRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listMigrationTasksPaginated]
 * to access the nested member [MigrationTaskSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [MigrationTaskSummary]
 */
@JvmName("listMigrationTasksResponseMigrationTaskSummary")
fun Flow<ListMigrationTasksResponse>.migrationTaskSummaryList(): Flow<MigrationTaskSummary> =
    transform() { response ->
        response.migrationTaskSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListProgressUpdateStreamsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListProgressUpdateStreamsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProgressUpdateStreamsResponse]
 */
fun MigrationHubClient.listProgressUpdateStreamsPaginated(initialRequest: ListProgressUpdateStreamsRequest): Flow<ListProgressUpdateStreamsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listProgressUpdateStreamsPaginated.listProgressUpdateStreams(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListProgressUpdateStreamsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProgressUpdateStreamsResponse]
 */
fun MigrationHubClient.listProgressUpdateStreamsPaginated(block: ListProgressUpdateStreamsRequest.Builder.() -> Unit): Flow<ListProgressUpdateStreamsResponse> =
    listProgressUpdateStreamsPaginated(ListProgressUpdateStreamsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listProgressUpdateStreamsPaginated]
 * to access the nested member [ProgressUpdateStreamSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ProgressUpdateStreamSummary]
 */
@JvmName("listProgressUpdateStreamsResponseProgressUpdateStreamSummary")
fun Flow<ListProgressUpdateStreamsResponse>.progressUpdateStreamSummaryList(): Flow<ProgressUpdateStreamSummary> =
    transform() { response ->
        response.progressUpdateStreamSummaryList?.forEach {
            emit(it)
        }
    }
