// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhub.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents a migration task in a migration tool.
 */
class MigrationTask private constructor(builder: Builder) {
    /**
     * Unique identifier that references the migration task. *Do not store personal data in this field.*
     */
    val migrationTaskName: kotlin.String? = builder.migrationTaskName
    /**
     * A name that identifies the vendor of the migration tool being used.
     */
    val progressUpdateStream: kotlin.String? = builder.progressUpdateStream
    /**
     * Information about the resource that is being migrated. This data will be used to map the task to a resource in the Application Discovery Service repository.
     */
    val resourceAttributeList: List<ResourceAttribute>? = builder.resourceAttributeList
    /**
     * Task object encapsulating task information.
     */
    val task: aws.sdk.kotlin.services.migrationhub.model.Task? = builder.task
    /**
     * The timestamp when the task was gathered.
     */
    val updateDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.updateDateTime

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.migrationhub.model.MigrationTask = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MigrationTask(")
        append("migrationTaskName=$migrationTaskName,")
        append("progressUpdateStream=$progressUpdateStream,")
        append("resourceAttributeList=$resourceAttributeList,")
        append("task=$task,")
        append("updateDateTime=$updateDateTime)")
    }

    override fun hashCode(): kotlin.Int {
        var result = migrationTaskName?.hashCode() ?: 0
        result = 31 * result + (progressUpdateStream?.hashCode() ?: 0)
        result = 31 * result + (resourceAttributeList?.hashCode() ?: 0)
        result = 31 * result + (task?.hashCode() ?: 0)
        result = 31 * result + (updateDateTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MigrationTask

        if (migrationTaskName != other.migrationTaskName) return false
        if (progressUpdateStream != other.progressUpdateStream) return false
        if (resourceAttributeList != other.resourceAttributeList) return false
        if (task != other.task) return false
        if (updateDateTime != other.updateDateTime) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.migrationhub.model.MigrationTask = Builder(this).apply(block).build()

    class Builder {
        /**
         * Unique identifier that references the migration task. *Do not store personal data in this field.*
         */
        var migrationTaskName: kotlin.String? = null
        /**
         * A name that identifies the vendor of the migration tool being used.
         */
        var progressUpdateStream: kotlin.String? = null
        /**
         * Information about the resource that is being migrated. This data will be used to map the task to a resource in the Application Discovery Service repository.
         */
        var resourceAttributeList: List<ResourceAttribute>? = null
        /**
         * Task object encapsulating task information.
         */
        var task: aws.sdk.kotlin.services.migrationhub.model.Task? = null
        /**
         * The timestamp when the task was gathered.
         */
        var updateDateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.migrationhub.model.MigrationTask) : this() {
            this.migrationTaskName = x.migrationTaskName
            this.progressUpdateStream = x.progressUpdateStream
            this.resourceAttributeList = x.resourceAttributeList
            this.task = x.task
            this.updateDateTime = x.updateDateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.migrationhub.model.MigrationTask = MigrationTask(this)

        /**
         * construct an [aws.sdk.kotlin.services.migrationhub.model.Task] inside the given [block]
         */
        fun task(block: aws.sdk.kotlin.services.migrationhub.model.Task.Builder.() -> kotlin.Unit) {
            this.task = aws.sdk.kotlin.services.migrationhub.model.Task.invoke(block)
        }
    }
}
