// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhub.paginators

import aws.sdk.kotlin.services.migrationhub.MigrationHubClient
import aws.sdk.kotlin.services.migrationhub.model.ApplicationState
import aws.sdk.kotlin.services.migrationhub.model.CreatedArtifact
import aws.sdk.kotlin.services.migrationhub.model.DiscoveredResource
import aws.sdk.kotlin.services.migrationhub.model.ListApplicationStatesRequest
import aws.sdk.kotlin.services.migrationhub.model.ListApplicationStatesResponse
import aws.sdk.kotlin.services.migrationhub.model.ListCreatedArtifactsRequest
import aws.sdk.kotlin.services.migrationhub.model.ListCreatedArtifactsResponse
import aws.sdk.kotlin.services.migrationhub.model.ListDiscoveredResourcesRequest
import aws.sdk.kotlin.services.migrationhub.model.ListDiscoveredResourcesResponse
import aws.sdk.kotlin.services.migrationhub.model.ListMigrationTaskUpdatesRequest
import aws.sdk.kotlin.services.migrationhub.model.ListMigrationTaskUpdatesResponse
import aws.sdk.kotlin.services.migrationhub.model.ListMigrationTasksRequest
import aws.sdk.kotlin.services.migrationhub.model.ListMigrationTasksResponse
import aws.sdk.kotlin.services.migrationhub.model.ListProgressUpdateStreamsRequest
import aws.sdk.kotlin.services.migrationhub.model.ListProgressUpdateStreamsResponse
import aws.sdk.kotlin.services.migrationhub.model.ListSourceResourcesRequest
import aws.sdk.kotlin.services.migrationhub.model.ListSourceResourcesResponse
import aws.sdk.kotlin.services.migrationhub.model.MigrationTaskSummary
import aws.sdk.kotlin.services.migrationhub.model.MigrationTaskUpdate
import aws.sdk.kotlin.services.migrationhub.model.ProgressUpdateStreamSummary
import aws.sdk.kotlin.services.migrationhub.model.SourceResource
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListApplicationStatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListApplicationStatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationStatesResponse]
 */
public fun MigrationHubClient.listApplicationStatesPaginated(initialRequest: ListApplicationStatesRequest = ListApplicationStatesRequest { }): Flow<ListApplicationStatesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listApplicationStatesPaginated.listApplicationStates(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListApplicationStatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListApplicationStatesResponse]
 */
public fun MigrationHubClient.listApplicationStatesPaginated(block: ListApplicationStatesRequest.Builder.() -> Unit): Flow<ListApplicationStatesResponse> =
    listApplicationStatesPaginated(ListApplicationStatesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listApplicationStatesPaginated]
 * to access the nested member [ApplicationState]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ApplicationState]
 */
@JvmName("listApplicationStatesResponseApplicationState")
public fun Flow<ListApplicationStatesResponse>.applicationStateList(): Flow<ApplicationState> =
    transform() { response ->
        response.applicationStateList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCreatedArtifactsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCreatedArtifactsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCreatedArtifactsResponse]
 */
public fun MigrationHubClient.listCreatedArtifactsPaginated(initialRequest: ListCreatedArtifactsRequest): Flow<ListCreatedArtifactsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCreatedArtifactsPaginated.listCreatedArtifacts(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCreatedArtifactsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCreatedArtifactsResponse]
 */
public fun MigrationHubClient.listCreatedArtifactsPaginated(block: ListCreatedArtifactsRequest.Builder.() -> Unit): Flow<ListCreatedArtifactsResponse> =
    listCreatedArtifactsPaginated(ListCreatedArtifactsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCreatedArtifactsPaginated]
 * to access the nested member [CreatedArtifact]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CreatedArtifact]
 */
@JvmName("listCreatedArtifactsResponseCreatedArtifact")
public fun Flow<ListCreatedArtifactsResponse>.createdArtifactList(): Flow<CreatedArtifact> =
    transform() { response ->
        response.createdArtifactList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDiscoveredResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDiscoveredResourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDiscoveredResourcesResponse]
 */
public fun MigrationHubClient.listDiscoveredResourcesPaginated(initialRequest: ListDiscoveredResourcesRequest): Flow<ListDiscoveredResourcesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDiscoveredResourcesPaginated.listDiscoveredResources(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDiscoveredResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDiscoveredResourcesResponse]
 */
public fun MigrationHubClient.listDiscoveredResourcesPaginated(block: ListDiscoveredResourcesRequest.Builder.() -> Unit): Flow<ListDiscoveredResourcesResponse> =
    listDiscoveredResourcesPaginated(ListDiscoveredResourcesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDiscoveredResourcesPaginated]
 * to access the nested member [DiscoveredResource]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DiscoveredResource]
 */
@JvmName("listDiscoveredResourcesResponseDiscoveredResource")
public fun Flow<ListDiscoveredResourcesResponse>.discoveredResourceList(): Flow<DiscoveredResource> =
    transform() { response ->
        response.discoveredResourceList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListMigrationTasksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMigrationTasksRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMigrationTasksResponse]
 */
public fun MigrationHubClient.listMigrationTasksPaginated(initialRequest: ListMigrationTasksRequest = ListMigrationTasksRequest { }): Flow<ListMigrationTasksResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMigrationTasksPaginated.listMigrationTasks(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListMigrationTasksResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMigrationTasksResponse]
 */
public fun MigrationHubClient.listMigrationTasksPaginated(block: ListMigrationTasksRequest.Builder.() -> Unit): Flow<ListMigrationTasksResponse> =
    listMigrationTasksPaginated(ListMigrationTasksRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listMigrationTasksPaginated]
 * to access the nested member [MigrationTaskSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [MigrationTaskSummary]
 */
@JvmName("listMigrationTasksResponseMigrationTaskSummary")
public fun Flow<ListMigrationTasksResponse>.migrationTaskSummaryList(): Flow<MigrationTaskSummary> =
    transform() { response ->
        response.migrationTaskSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListMigrationTaskUpdatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListMigrationTaskUpdatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMigrationTaskUpdatesResponse]
 */
public fun MigrationHubClient.listMigrationTaskUpdatesPaginated(initialRequest: ListMigrationTaskUpdatesRequest): Flow<ListMigrationTaskUpdatesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listMigrationTaskUpdatesPaginated.listMigrationTaskUpdates(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListMigrationTaskUpdatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListMigrationTaskUpdatesResponse]
 */
public fun MigrationHubClient.listMigrationTaskUpdatesPaginated(block: ListMigrationTaskUpdatesRequest.Builder.() -> Unit): Flow<ListMigrationTaskUpdatesResponse> =
    listMigrationTaskUpdatesPaginated(ListMigrationTaskUpdatesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listMigrationTaskUpdatesPaginated]
 * to access the nested member [MigrationTaskUpdate]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [MigrationTaskUpdate]
 */
@JvmName("listMigrationTaskUpdatesResponseMigrationTaskUpdate")
public fun Flow<ListMigrationTaskUpdatesResponse>.migrationTaskUpdateList(): Flow<MigrationTaskUpdate> =
    transform() { response ->
        response.migrationTaskUpdateList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListProgressUpdateStreamsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListProgressUpdateStreamsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProgressUpdateStreamsResponse]
 */
public fun MigrationHubClient.listProgressUpdateStreamsPaginated(initialRequest: ListProgressUpdateStreamsRequest = ListProgressUpdateStreamsRequest { }): Flow<ListProgressUpdateStreamsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listProgressUpdateStreamsPaginated.listProgressUpdateStreams(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListProgressUpdateStreamsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProgressUpdateStreamsResponse]
 */
public fun MigrationHubClient.listProgressUpdateStreamsPaginated(block: ListProgressUpdateStreamsRequest.Builder.() -> Unit): Flow<ListProgressUpdateStreamsResponse> =
    listProgressUpdateStreamsPaginated(ListProgressUpdateStreamsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listProgressUpdateStreamsPaginated]
 * to access the nested member [ProgressUpdateStreamSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ProgressUpdateStreamSummary]
 */
@JvmName("listProgressUpdateStreamsResponseProgressUpdateStreamSummary")
public fun Flow<ListProgressUpdateStreamsResponse>.progressUpdateStreamSummaryList(): Flow<ProgressUpdateStreamSummary> =
    transform() { response ->
        response.progressUpdateStreamSummaryList?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListSourceResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListSourceResourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSourceResourcesResponse]
 */
public fun MigrationHubClient.listSourceResourcesPaginated(initialRequest: ListSourceResourcesRequest): Flow<ListSourceResourcesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listSourceResourcesPaginated.listSourceResources(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListSourceResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListSourceResourcesResponse]
 */
public fun MigrationHubClient.listSourceResourcesPaginated(block: ListSourceResourcesRequest.Builder.() -> Unit): Flow<ListSourceResourcesResponse> =
    listSourceResourcesPaginated(ListSourceResourcesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listSourceResourcesPaginated]
 * to access the nested member [SourceResource]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SourceResource]
 */
@JvmName("listSourceResourcesResponseSourceResource")
public fun Flow<ListSourceResourcesResponse>.sourceResourceList(): Flow<SourceResource> =
    transform() { response ->
        response.sourceResourceList?.forEach {
            emit(it)
        }
    }
