// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.migrationhub

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.migrationhub.auth.DefaultMigrationHubAuthSchemeProvider
import aws.sdk.kotlin.services.migrationhub.auth.MigrationHubAuthSchemeProvider
import aws.sdk.kotlin.services.migrationhub.endpoints.DefaultMigrationHubEndpointProvider
import aws.sdk.kotlin.services.migrationhub.endpoints.MigrationHubEndpointParameters
import aws.sdk.kotlin.services.migrationhub.endpoints.MigrationHubEndpointProvider
import aws.sdk.kotlin.services.migrationhub.model.AssociateCreatedArtifactRequest
import aws.sdk.kotlin.services.migrationhub.model.AssociateCreatedArtifactResponse
import aws.sdk.kotlin.services.migrationhub.model.AssociateDiscoveredResourceRequest
import aws.sdk.kotlin.services.migrationhub.model.AssociateDiscoveredResourceResponse
import aws.sdk.kotlin.services.migrationhub.model.AssociateSourceResourceRequest
import aws.sdk.kotlin.services.migrationhub.model.AssociateSourceResourceResponse
import aws.sdk.kotlin.services.migrationhub.model.CreateProgressUpdateStreamRequest
import aws.sdk.kotlin.services.migrationhub.model.CreateProgressUpdateStreamResponse
import aws.sdk.kotlin.services.migrationhub.model.DeleteProgressUpdateStreamRequest
import aws.sdk.kotlin.services.migrationhub.model.DeleteProgressUpdateStreamResponse
import aws.sdk.kotlin.services.migrationhub.model.DescribeApplicationStateRequest
import aws.sdk.kotlin.services.migrationhub.model.DescribeApplicationStateResponse
import aws.sdk.kotlin.services.migrationhub.model.DescribeMigrationTaskRequest
import aws.sdk.kotlin.services.migrationhub.model.DescribeMigrationTaskResponse
import aws.sdk.kotlin.services.migrationhub.model.DisassociateCreatedArtifactRequest
import aws.sdk.kotlin.services.migrationhub.model.DisassociateCreatedArtifactResponse
import aws.sdk.kotlin.services.migrationhub.model.DisassociateDiscoveredResourceRequest
import aws.sdk.kotlin.services.migrationhub.model.DisassociateDiscoveredResourceResponse
import aws.sdk.kotlin.services.migrationhub.model.DisassociateSourceResourceRequest
import aws.sdk.kotlin.services.migrationhub.model.DisassociateSourceResourceResponse
import aws.sdk.kotlin.services.migrationhub.model.ImportMigrationTaskRequest
import aws.sdk.kotlin.services.migrationhub.model.ImportMigrationTaskResponse
import aws.sdk.kotlin.services.migrationhub.model.ListApplicationStatesRequest
import aws.sdk.kotlin.services.migrationhub.model.ListApplicationStatesResponse
import aws.sdk.kotlin.services.migrationhub.model.ListCreatedArtifactsRequest
import aws.sdk.kotlin.services.migrationhub.model.ListCreatedArtifactsResponse
import aws.sdk.kotlin.services.migrationhub.model.ListDiscoveredResourcesRequest
import aws.sdk.kotlin.services.migrationhub.model.ListDiscoveredResourcesResponse
import aws.sdk.kotlin.services.migrationhub.model.ListMigrationTaskUpdatesRequest
import aws.sdk.kotlin.services.migrationhub.model.ListMigrationTaskUpdatesResponse
import aws.sdk.kotlin.services.migrationhub.model.ListMigrationTasksRequest
import aws.sdk.kotlin.services.migrationhub.model.ListMigrationTasksResponse
import aws.sdk.kotlin.services.migrationhub.model.ListProgressUpdateStreamsRequest
import aws.sdk.kotlin.services.migrationhub.model.ListProgressUpdateStreamsResponse
import aws.sdk.kotlin.services.migrationhub.model.ListSourceResourcesRequest
import aws.sdk.kotlin.services.migrationhub.model.ListSourceResourcesResponse
import aws.sdk.kotlin.services.migrationhub.model.NotifyApplicationStateRequest
import aws.sdk.kotlin.services.migrationhub.model.NotifyApplicationStateResponse
import aws.sdk.kotlin.services.migrationhub.model.NotifyMigrationTaskStateRequest
import aws.sdk.kotlin.services.migrationhub.model.NotifyMigrationTaskStateResponse
import aws.sdk.kotlin.services.migrationhub.model.PutResourceAttributesRequest
import aws.sdk.kotlin.services.migrationhub.model.PutResourceAttributesResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "Migration Hub"
public const val SdkVersion: String = "1.5.26"
public const val ServiceApiVersion: String = "2017-05-31"

/**
 * The AWS Migration Hub API methods help to obtain server and application migration status and integrate your resource-specific migration tool by providing a programmatic interface to Migration Hub.
 *
 * Remember that you must set your AWS Migration Hub home region before you call any of these APIs, or a `HomeRegionNotSetException` error will be returned. Also, you must make the API calls while in your home region.
 */
public interface MigrationHubClient : SdkClient {
    /**
     * MigrationHubClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, MigrationHubClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "MigrationHub",
                "MIGRATION_HUB",
                "migration_hub",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, MigrationHubClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): MigrationHubClient = DefaultMigrationHubClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: MigrationHubEndpointProvider = builder.endpointProvider ?: DefaultMigrationHubEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: MigrationHubAuthSchemeProvider = builder.authSchemeProvider ?: DefaultMigrationHubAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Migration Hub"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: MigrationHubEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: MigrationHubAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Associates a created artifact of an AWS cloud resource, the target receiving the migration, with the migration task performed by a migration tool. This API has the following traits:
     * + Migration tools can call the `AssociateCreatedArtifact` operation to indicate which AWS artifact is associated with a migration task.
     * + The created artifact name must be provided in ARN (Amazon Resource Name) format which will contain information about type and region; for example: `arn:aws:ec2:us-east-1:488216288981:image/ami-6d0ba87b`.
     * + Examples of the AWS resource behind the created artifact are, AMI's, EC2 instance, or DMS endpoint, etc.
     */
    public suspend fun associateCreatedArtifact(input: AssociateCreatedArtifactRequest): AssociateCreatedArtifactResponse

    /**
     * Associates a discovered resource ID from Application Discovery Service with a migration task.
     */
    public suspend fun associateDiscoveredResource(input: AssociateDiscoveredResourceRequest): AssociateDiscoveredResourceResponse

    /**
     * Associates a source resource with a migration task. For example, the source resource can be a source server, an application, or a migration wave.
     */
    public suspend fun associateSourceResource(input: AssociateSourceResourceRequest): AssociateSourceResourceResponse

    /**
     * Creates a progress update stream which is an AWS resource used for access control as well as a namespace for migration task names that is implicitly linked to your AWS account. It must uniquely identify the migration tool as it is used for all updates made by the tool; however, it does not need to be unique for each AWS account because it is scoped to the AWS account.
     */
    public suspend fun createProgressUpdateStream(input: CreateProgressUpdateStreamRequest): CreateProgressUpdateStreamResponse

    /**
     * Deletes a progress update stream, including all of its tasks, which was previously created as an AWS resource used for access control. This API has the following traits:
     * + The only parameter needed for `DeleteProgressUpdateStream` is the stream name (same as a `CreateProgressUpdateStream` call).
     * + The call will return, and a background process will asynchronously delete the stream and all of its resources (tasks, associated resources, resource attributes, created artifacts).
     * + If the stream takes time to be deleted, it might still show up on a `ListProgressUpdateStreams` call.
     * + `CreateProgressUpdateStream`, `ImportMigrationTask`, `NotifyMigrationTaskState`, and all Associate&#91;*&#93; APIs related to the tasks belonging to the stream will throw "InvalidInputException" if the stream of the same name is in the process of being deleted.
     * + Once the stream and all of its resources are deleted, `CreateProgressUpdateStream` for a stream of the same name will succeed, and that stream will be an entirely new logical resource (without any resources associated with the old stream).
     */
    public suspend fun deleteProgressUpdateStream(input: DeleteProgressUpdateStreamRequest): DeleteProgressUpdateStreamResponse

    /**
     * Gets the migration status of an application.
     */
    public suspend fun describeApplicationState(input: DescribeApplicationStateRequest): DescribeApplicationStateResponse

    /**
     * Retrieves a list of all attributes associated with a specific migration task.
     */
    public suspend fun describeMigrationTask(input: DescribeMigrationTaskRequest): DescribeMigrationTaskResponse

    /**
     * Disassociates a created artifact of an AWS resource with a migration task performed by a migration tool that was previously associated. This API has the following traits:
     * + A migration user can call the `DisassociateCreatedArtifacts` operation to disassociate a created AWS Artifact from a migration task.
     * + The created artifact name must be provided in ARN (Amazon Resource Name) format which will contain information about type and region; for example: `arn:aws:ec2:us-east-1:488216288981:image/ami-6d0ba87b`.
     * + Examples of the AWS resource behind the created artifact are, AMI's, EC2 instance, or RDS instance, etc.
     */
    public suspend fun disassociateCreatedArtifact(input: DisassociateCreatedArtifactRequest): DisassociateCreatedArtifactResponse

    /**
     * Disassociate an Application Discovery Service discovered resource from a migration task.
     */
    public suspend fun disassociateDiscoveredResource(input: DisassociateDiscoveredResourceRequest): DisassociateDiscoveredResourceResponse

    /**
     * Removes the association between a source resource and a migration task.
     */
    public suspend fun disassociateSourceResource(input: DisassociateSourceResourceRequest): DisassociateSourceResourceResponse

    /**
     * Registers a new migration task which represents a server, database, etc., being migrated to AWS by a migration tool.
     *
     * This API is a prerequisite to calling the `NotifyMigrationTaskState` API as the migration tool must first register the migration task with Migration Hub.
     */
    public suspend fun importMigrationTask(input: ImportMigrationTaskRequest): ImportMigrationTaskResponse

    /**
     * Lists all the migration statuses for your applications. If you use the optional `ApplicationIds` parameter, only the migration statuses for those applications will be returned.
     */
    public suspend fun listApplicationStates(input: ListApplicationStatesRequest = ListApplicationStatesRequest { }): ListApplicationStatesResponse

    /**
     * Lists the created artifacts attached to a given migration task in an update stream. This API has the following traits:
     * + Gets the list of the created artifacts while migration is taking place.
     * + Shows the artifacts created by the migration tool that was associated by the `AssociateCreatedArtifact` API.
     * + Lists created artifacts in a paginated interface.
     */
    public suspend fun listCreatedArtifacts(input: ListCreatedArtifactsRequest): ListCreatedArtifactsResponse

    /**
     * Lists discovered resources associated with the given `MigrationTask`.
     */
    public suspend fun listDiscoveredResources(input: ListDiscoveredResourcesRequest): ListDiscoveredResourcesResponse

    /**
     * This is a paginated API that returns all the migration-task states for the specified `MigrationTaskName` and `ProgressUpdateStream`.
     */
    public suspend fun listMigrationTaskUpdates(input: ListMigrationTaskUpdatesRequest): ListMigrationTaskUpdatesResponse

    /**
     * Lists all, or filtered by resource name, migration tasks associated with the user account making this call. This API has the following traits:
     * + Can show a summary list of the most recent migration tasks.
     * + Can show a summary list of migration tasks associated with a given discovered resource.
     * + Lists migration tasks in a paginated interface.
     */
    public suspend fun listMigrationTasks(input: ListMigrationTasksRequest = ListMigrationTasksRequest { }): ListMigrationTasksResponse

    /**
     * Lists progress update streams associated with the user account making this call.
     */
    public suspend fun listProgressUpdateStreams(input: ListProgressUpdateStreamsRequest = ListProgressUpdateStreamsRequest { }): ListProgressUpdateStreamsResponse

    /**
     * Lists all the source resource that are associated with the specified `MigrationTaskName` and `ProgressUpdateStream`.
     */
    public suspend fun listSourceResources(input: ListSourceResourcesRequest): ListSourceResourcesResponse

    /**
     * Sets the migration state of an application. For a given application identified by the value passed to `ApplicationId`, its status is set or updated by passing one of three values to `Status`: `NOT_STARTED | IN_PROGRESS | COMPLETED`.
     */
    public suspend fun notifyApplicationState(input: NotifyApplicationStateRequest): NotifyApplicationStateResponse

    /**
     * Notifies Migration Hub of the current status, progress, or other detail regarding a migration task. This API has the following traits:
     * + Migration tools will call the `NotifyMigrationTaskState` API to share the latest progress and status.
     * + `MigrationTaskName` is used for addressing updates to the correct target.
     * + `ProgressUpdateStream` is used for access control and to provide a namespace for each migration tool.
     */
    public suspend fun notifyMigrationTaskState(input: NotifyMigrationTaskStateRequest): NotifyMigrationTaskStateResponse

    /**
     * Provides identifying details of the resource being migrated so that it can be associated in the Application Discovery Service repository. This association occurs asynchronously after `PutResourceAttributes` returns.
     *
     * + Keep in mind that subsequent calls to PutResourceAttributes will override previously stored attributes. For example, if it is first called with a MAC address, but later, it is desired to *add* an IP address, it will then be required to call it with *both* the IP and MAC addresses to prevent overriding the MAC address.
     * + Note the instructions regarding the special use case of the `ResourceAttributeList`[](https://docs.aws.amazon.com/migrationhub/latest/ug/API_PutResourceAttributes.html#migrationhub-PutResourceAttributes-request-ResourceAttributeList) parameter when specifying any "VM" related value.
     * Because this is an asynchronous call, it will always return 200, whether an association occurs or not. To confirm if an association was found based on the provided details, call `ListDiscoveredResources`.
     */
    public suspend fun putResourceAttributes(input: PutResourceAttributesRequest): PutResourceAttributesResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun MigrationHubClient.withConfig(block: MigrationHubClient.Config.Builder.() -> Unit): MigrationHubClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultMigrationHubClient(newConfig)
}

/**
 * Associates a created artifact of an AWS cloud resource, the target receiving the migration, with the migration task performed by a migration tool. This API has the following traits:
 * + Migration tools can call the `AssociateCreatedArtifact` operation to indicate which AWS artifact is associated with a migration task.
 * + The created artifact name must be provided in ARN (Amazon Resource Name) format which will contain information about type and region; for example: `arn:aws:ec2:us-east-1:488216288981:image/ami-6d0ba87b`.
 * + Examples of the AWS resource behind the created artifact are, AMI's, EC2 instance, or DMS endpoint, etc.
 */
public suspend inline fun MigrationHubClient.associateCreatedArtifact(crossinline block: AssociateCreatedArtifactRequest.Builder.() -> Unit): AssociateCreatedArtifactResponse = associateCreatedArtifact(AssociateCreatedArtifactRequest.Builder().apply(block).build())

/**
 * Associates a discovered resource ID from Application Discovery Service with a migration task.
 */
public suspend inline fun MigrationHubClient.associateDiscoveredResource(crossinline block: AssociateDiscoveredResourceRequest.Builder.() -> Unit): AssociateDiscoveredResourceResponse = associateDiscoveredResource(AssociateDiscoveredResourceRequest.Builder().apply(block).build())

/**
 * Associates a source resource with a migration task. For example, the source resource can be a source server, an application, or a migration wave.
 */
public suspend inline fun MigrationHubClient.associateSourceResource(crossinline block: AssociateSourceResourceRequest.Builder.() -> Unit): AssociateSourceResourceResponse = associateSourceResource(AssociateSourceResourceRequest.Builder().apply(block).build())

/**
 * Creates a progress update stream which is an AWS resource used for access control as well as a namespace for migration task names that is implicitly linked to your AWS account. It must uniquely identify the migration tool as it is used for all updates made by the tool; however, it does not need to be unique for each AWS account because it is scoped to the AWS account.
 */
public suspend inline fun MigrationHubClient.createProgressUpdateStream(crossinline block: CreateProgressUpdateStreamRequest.Builder.() -> Unit): CreateProgressUpdateStreamResponse = createProgressUpdateStream(CreateProgressUpdateStreamRequest.Builder().apply(block).build())

/**
 * Deletes a progress update stream, including all of its tasks, which was previously created as an AWS resource used for access control. This API has the following traits:
 * + The only parameter needed for `DeleteProgressUpdateStream` is the stream name (same as a `CreateProgressUpdateStream` call).
 * + The call will return, and a background process will asynchronously delete the stream and all of its resources (tasks, associated resources, resource attributes, created artifacts).
 * + If the stream takes time to be deleted, it might still show up on a `ListProgressUpdateStreams` call.
 * + `CreateProgressUpdateStream`, `ImportMigrationTask`, `NotifyMigrationTaskState`, and all Associate&#91;*&#93; APIs related to the tasks belonging to the stream will throw "InvalidInputException" if the stream of the same name is in the process of being deleted.
 * + Once the stream and all of its resources are deleted, `CreateProgressUpdateStream` for a stream of the same name will succeed, and that stream will be an entirely new logical resource (without any resources associated with the old stream).
 */
public suspend inline fun MigrationHubClient.deleteProgressUpdateStream(crossinline block: DeleteProgressUpdateStreamRequest.Builder.() -> Unit): DeleteProgressUpdateStreamResponse = deleteProgressUpdateStream(DeleteProgressUpdateStreamRequest.Builder().apply(block).build())

/**
 * Gets the migration status of an application.
 */
public suspend inline fun MigrationHubClient.describeApplicationState(crossinline block: DescribeApplicationStateRequest.Builder.() -> Unit): DescribeApplicationStateResponse = describeApplicationState(DescribeApplicationStateRequest.Builder().apply(block).build())

/**
 * Retrieves a list of all attributes associated with a specific migration task.
 */
public suspend inline fun MigrationHubClient.describeMigrationTask(crossinline block: DescribeMigrationTaskRequest.Builder.() -> Unit): DescribeMigrationTaskResponse = describeMigrationTask(DescribeMigrationTaskRequest.Builder().apply(block).build())

/**
 * Disassociates a created artifact of an AWS resource with a migration task performed by a migration tool that was previously associated. This API has the following traits:
 * + A migration user can call the `DisassociateCreatedArtifacts` operation to disassociate a created AWS Artifact from a migration task.
 * + The created artifact name must be provided in ARN (Amazon Resource Name) format which will contain information about type and region; for example: `arn:aws:ec2:us-east-1:488216288981:image/ami-6d0ba87b`.
 * + Examples of the AWS resource behind the created artifact are, AMI's, EC2 instance, or RDS instance, etc.
 */
public suspend inline fun MigrationHubClient.disassociateCreatedArtifact(crossinline block: DisassociateCreatedArtifactRequest.Builder.() -> Unit): DisassociateCreatedArtifactResponse = disassociateCreatedArtifact(DisassociateCreatedArtifactRequest.Builder().apply(block).build())

/**
 * Disassociate an Application Discovery Service discovered resource from a migration task.
 */
public suspend inline fun MigrationHubClient.disassociateDiscoveredResource(crossinline block: DisassociateDiscoveredResourceRequest.Builder.() -> Unit): DisassociateDiscoveredResourceResponse = disassociateDiscoveredResource(DisassociateDiscoveredResourceRequest.Builder().apply(block).build())

/**
 * Removes the association between a source resource and a migration task.
 */
public suspend inline fun MigrationHubClient.disassociateSourceResource(crossinline block: DisassociateSourceResourceRequest.Builder.() -> Unit): DisassociateSourceResourceResponse = disassociateSourceResource(DisassociateSourceResourceRequest.Builder().apply(block).build())

/**
 * Registers a new migration task which represents a server, database, etc., being migrated to AWS by a migration tool.
 *
 * This API is a prerequisite to calling the `NotifyMigrationTaskState` API as the migration tool must first register the migration task with Migration Hub.
 */
public suspend inline fun MigrationHubClient.importMigrationTask(crossinline block: ImportMigrationTaskRequest.Builder.() -> Unit): ImportMigrationTaskResponse = importMigrationTask(ImportMigrationTaskRequest.Builder().apply(block).build())

/**
 * Lists all the migration statuses for your applications. If you use the optional `ApplicationIds` parameter, only the migration statuses for those applications will be returned.
 */
public suspend inline fun MigrationHubClient.listApplicationStates(crossinline block: ListApplicationStatesRequest.Builder.() -> Unit): ListApplicationStatesResponse = listApplicationStates(ListApplicationStatesRequest.Builder().apply(block).build())

/**
 * Lists the created artifacts attached to a given migration task in an update stream. This API has the following traits:
 * + Gets the list of the created artifacts while migration is taking place.
 * + Shows the artifacts created by the migration tool that was associated by the `AssociateCreatedArtifact` API.
 * + Lists created artifacts in a paginated interface.
 */
public suspend inline fun MigrationHubClient.listCreatedArtifacts(crossinline block: ListCreatedArtifactsRequest.Builder.() -> Unit): ListCreatedArtifactsResponse = listCreatedArtifacts(ListCreatedArtifactsRequest.Builder().apply(block).build())

/**
 * Lists discovered resources associated with the given `MigrationTask`.
 */
public suspend inline fun MigrationHubClient.listDiscoveredResources(crossinline block: ListDiscoveredResourcesRequest.Builder.() -> Unit): ListDiscoveredResourcesResponse = listDiscoveredResources(ListDiscoveredResourcesRequest.Builder().apply(block).build())

/**
 * This is a paginated API that returns all the migration-task states for the specified `MigrationTaskName` and `ProgressUpdateStream`.
 */
public suspend inline fun MigrationHubClient.listMigrationTaskUpdates(crossinline block: ListMigrationTaskUpdatesRequest.Builder.() -> Unit): ListMigrationTaskUpdatesResponse = listMigrationTaskUpdates(ListMigrationTaskUpdatesRequest.Builder().apply(block).build())

/**
 * Lists all, or filtered by resource name, migration tasks associated with the user account making this call. This API has the following traits:
 * + Can show a summary list of the most recent migration tasks.
 * + Can show a summary list of migration tasks associated with a given discovered resource.
 * + Lists migration tasks in a paginated interface.
 */
public suspend inline fun MigrationHubClient.listMigrationTasks(crossinline block: ListMigrationTasksRequest.Builder.() -> Unit): ListMigrationTasksResponse = listMigrationTasks(ListMigrationTasksRequest.Builder().apply(block).build())

/**
 * Lists progress update streams associated with the user account making this call.
 */
public suspend inline fun MigrationHubClient.listProgressUpdateStreams(crossinline block: ListProgressUpdateStreamsRequest.Builder.() -> Unit): ListProgressUpdateStreamsResponse = listProgressUpdateStreams(ListProgressUpdateStreamsRequest.Builder().apply(block).build())

/**
 * Lists all the source resource that are associated with the specified `MigrationTaskName` and `ProgressUpdateStream`.
 */
public suspend inline fun MigrationHubClient.listSourceResources(crossinline block: ListSourceResourcesRequest.Builder.() -> Unit): ListSourceResourcesResponse = listSourceResources(ListSourceResourcesRequest.Builder().apply(block).build())

/**
 * Sets the migration state of an application. For a given application identified by the value passed to `ApplicationId`, its status is set or updated by passing one of three values to `Status`: `NOT_STARTED | IN_PROGRESS | COMPLETED`.
 */
public suspend inline fun MigrationHubClient.notifyApplicationState(crossinline block: NotifyApplicationStateRequest.Builder.() -> Unit): NotifyApplicationStateResponse = notifyApplicationState(NotifyApplicationStateRequest.Builder().apply(block).build())

/**
 * Notifies Migration Hub of the current status, progress, or other detail regarding a migration task. This API has the following traits:
 * + Migration tools will call the `NotifyMigrationTaskState` API to share the latest progress and status.
 * + `MigrationTaskName` is used for addressing updates to the correct target.
 * + `ProgressUpdateStream` is used for access control and to provide a namespace for each migration tool.
 */
public suspend inline fun MigrationHubClient.notifyMigrationTaskState(crossinline block: NotifyMigrationTaskStateRequest.Builder.() -> Unit): NotifyMigrationTaskStateResponse = notifyMigrationTaskState(NotifyMigrationTaskStateRequest.Builder().apply(block).build())

/**
 * Provides identifying details of the resource being migrated so that it can be associated in the Application Discovery Service repository. This association occurs asynchronously after `PutResourceAttributes` returns.
 *
 * + Keep in mind that subsequent calls to PutResourceAttributes will override previously stored attributes. For example, if it is first called with a MAC address, but later, it is desired to *add* an IP address, it will then be required to call it with *both* the IP and MAC addresses to prevent overriding the MAC address.
 * + Note the instructions regarding the special use case of the `ResourceAttributeList`[](https://docs.aws.amazon.com/migrationhub/latest/ug/API_PutResourceAttributes.html#migrationhub-PutResourceAttributes-request-ResourceAttributeList) parameter when specifying any "VM" related value.
 * Because this is an asynchronous call, it will always return 200, whether an association occurs or not. To confirm if an association was found based on the provided details, call `ListDiscoveredResources`.
 */
public suspend inline fun MigrationHubClient.putResourceAttributes(crossinline block: PutResourceAttributesRequest.Builder.() -> Unit): PutResourceAttributesResponse = putResourceAttributes(PutResourceAttributesRequest.Builder().apply(block).build())
