// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.memorydb.serde

import aws.sdk.kotlin.services.memorydb.model.ReplicaConfigurationRequest
import aws.sdk.kotlin.services.memorydb.model.ShardConfigurationRequest
import aws.sdk.kotlin.services.memorydb.model.UpdateClusterRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateClusterOperationSerializer: HttpSerializer.NonStreaming<UpdateClusterRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateClusterRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeUpdateClusterOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-amz-json-1.1")
        }
        return builder
    }
}

private fun serializeUpdateClusterOperationBody(context: ExecutionContext, input: UpdateClusterRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACLNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ACLName"))
    val CLUSTERNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ClusterName"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Description"))
    val ENGINEVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EngineVersion"))
    val MAINTENANCEWINDOW_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("MaintenanceWindow"))
    val NODETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NodeType"))
    val PARAMETERGROUPNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ParameterGroupName"))
    val REPLICACONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ReplicaConfiguration"))
    val SECURITYGROUPIDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SecurityGroupIds"))
    val SHARDCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ShardConfiguration"))
    val SNAPSHOTRETENTIONLIMIT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("SnapshotRetentionLimit"))
    val SNAPSHOTWINDOW_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SnapshotWindow"))
    val SNSTOPICARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SnsTopicArn"))
    val SNSTOPICSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("SnsTopicStatus"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACLNAME_DESCRIPTOR)
        field(CLUSTERNAME_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENGINEVERSION_DESCRIPTOR)
        field(MAINTENANCEWINDOW_DESCRIPTOR)
        field(NODETYPE_DESCRIPTOR)
        field(PARAMETERGROUPNAME_DESCRIPTOR)
        field(REPLICACONFIGURATION_DESCRIPTOR)
        field(SECURITYGROUPIDS_DESCRIPTOR)
        field(SHARDCONFIGURATION_DESCRIPTOR)
        field(SNAPSHOTRETENTIONLIMIT_DESCRIPTOR)
        field(SNAPSHOTWINDOW_DESCRIPTOR)
        field(SNSTOPICARN_DESCRIPTOR)
        field(SNSTOPICSTATUS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.aclName?.let { field(ACLNAME_DESCRIPTOR, it) }
        input.clusterName?.let { field(CLUSTERNAME_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.engineVersion?.let { field(ENGINEVERSION_DESCRIPTOR, it) }
        input.maintenanceWindow?.let { field(MAINTENANCEWINDOW_DESCRIPTOR, it) }
        input.nodeType?.let { field(NODETYPE_DESCRIPTOR, it) }
        input.parameterGroupName?.let { field(PARAMETERGROUPNAME_DESCRIPTOR, it) }
        input.replicaConfiguration?.let { field(REPLICACONFIGURATION_DESCRIPTOR, it, ::serializeReplicaConfigurationRequestDocument) }
        if (input.securityGroupIds != null) {
            listField(SECURITYGROUPIDS_DESCRIPTOR) {
                for (el0 in input.securityGroupIds) {
                    serializeString(el0)
                }
            }
        }
        input.shardConfiguration?.let { field(SHARDCONFIGURATION_DESCRIPTOR, it, ::serializeShardConfigurationRequestDocument) }
        input.snapshotRetentionLimit?.let { field(SNAPSHOTRETENTIONLIMIT_DESCRIPTOR, it) }
        input.snapshotWindow?.let { field(SNAPSHOTWINDOW_DESCRIPTOR, it) }
        input.snsTopicArn?.let { field(SNSTOPICARN_DESCRIPTOR, it) }
        input.snsTopicStatus?.let { field(SNSTOPICSTATUS_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
