// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.memorydb.serde

import aws.sdk.kotlin.services.memorydb.model.Cluster
import aws.sdk.kotlin.services.memorydb.model.MemoryDbException
import aws.sdk.kotlin.services.memorydb.model.UpdateClusterResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateClusterOperationDeserializer: HttpDeserializer.NonStreaming<UpdateClusterResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateClusterResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateClusterError(context, call, payload)
        }
        val builder = UpdateClusterResponse.Builder()

        if (payload != null) {
            deserializeUpdateClusterOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateClusterError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MemoryDbException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterCombinationException" -> InvalidParameterCombinationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ClusterQuotaForCustomerExceededFault" -> ClusterQuotaForCustomerExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidNodeStateFault" -> InvalidNodeStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ACLNotFoundFault" -> AclNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceLinkedRoleNotFoundFault" -> ServiceLinkedRoleNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "NodeQuotaForClusterExceededFault" -> NodeQuotaForClusterExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidClusterStateFault" -> InvalidClusterStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ShardsPerClusterQuotaExceededFault" -> ShardsPerClusterQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ParameterGroupNotFoundFault" -> ParameterGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ClusterNotFoundFault" -> ClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidKMSKeyFault" -> InvalidKmsKeyFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidVPCNetworkStateFault" -> InvalidVpcNetworkStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "NodeQuotaForCustomerExceededFault" -> NodeQuotaForCustomerExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "NoOperationFault" -> NoOperationFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidACLStateFault" -> InvalidAclStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> MemoryDbException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateClusterOperationBody(builder: UpdateClusterResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CLUSTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Cluster"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLUSTER_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CLUSTER_DESCRIPTOR.index -> builder.cluster = deserializeClusterDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
