// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.memorydb.serde

import aws.sdk.kotlin.services.memorydb.model.ListTagsResponse
import aws.sdk.kotlin.services.memorydb.model.MemoryDbException
import aws.sdk.kotlin.services.memorydb.model.Tag
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListTagsOperationDeserializer: HttpDeserializer.NonStreaming<ListTagsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ListTagsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListTagsError(context, call, payload)
        }
        val builder = ListTagsResponse.Builder()

        if (payload != null) {
            deserializeListTagsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwListTagsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MemoryDbException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "SnapshotNotFoundFault" -> SnapshotNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ClusterNotFoundFault" -> ClusterNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ACLNotFoundFault" -> AclNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceLinkedRoleNotFoundFault" -> ServiceLinkedRoleNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "SubnetGroupNotFoundFault" -> SubnetGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "UserNotFoundFault" -> UserNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidClusterStateFault" -> InvalidClusterStateFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidARNFault" -> InvalidArnFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ParameterGroupNotFoundFault" -> ParameterGroupNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        else -> MemoryDbException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListTagsOperationBody(builder: ListTagsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val TAGLIST_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("TagList"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(TAGLIST_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                TAGLIST_DESCRIPTOR.index -> builder.tagList =
                    deserializer.deserializeList(TAGLIST_DESCRIPTOR) {
                        val col0 = mutableListOf<Tag>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTagDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
