// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.memorydb.serde

import aws.sdk.kotlin.services.memorydb.model.Acl
import aws.sdk.kotlin.services.memorydb.model.CreateAclResponse
import aws.sdk.kotlin.services.memorydb.model.MemoryDbException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateACLOperationDeserializer: HttpDeserializer.NonStreaming<CreateAclResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateAclResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateAclError(context, call, payload)
        }
        val builder = CreateAclResponse.Builder()

        if (payload != null) {
            deserializeCreateACLOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateAclError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MemoryDbException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ACLQuotaExceededFault" -> AclQuotaExceededFaultDeserializer().deserialize(context, wrappedCall, payload)
        "DuplicateUserNameFault" -> DuplicateUserNameFaultDeserializer().deserialize(context, wrappedCall, payload)
        "TagQuotaPerResourceExceeded" -> TagQuotaPerResourceExceededDeserializer().deserialize(context, wrappedCall, payload)
        "DefaultUserRequired" -> DefaultUserRequiredDeserializer().deserialize(context, wrappedCall, payload)
        "UserNotFoundFault" -> UserNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "ACLAlreadyExistsFault" -> AclAlreadyExistsFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> MemoryDbException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateACLOperationBody(builder: CreateAclResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ACL"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACL_DESCRIPTOR.index -> builder.acl = deserializeAclDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
