// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.memorydb.serde

import aws.sdk.kotlin.services.memorydb.model.BatchUpdateClusterResponse
import aws.sdk.kotlin.services.memorydb.model.Cluster
import aws.sdk.kotlin.services.memorydb.model.MemoryDbException
import aws.sdk.kotlin.services.memorydb.model.UnprocessedCluster
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class BatchUpdateClusterOperationDeserializer: HttpDeserializer.NonStreaming<BatchUpdateClusterResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): BatchUpdateClusterResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwBatchUpdateClusterError(context, call, payload)
        }
        val builder = BatchUpdateClusterResponse.Builder()

        if (payload != null) {
            deserializeBatchUpdateClusterOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwBatchUpdateClusterError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw MemoryDbException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ServiceUpdateNotFoundFault" -> ServiceUpdateNotFoundFaultDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> MemoryDbException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchUpdateClusterOperationBody(builder: BatchUpdateClusterResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PROCESSEDCLUSTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ProcessedClusters"))
    val UNPROCESSEDCLUSTERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("UnprocessedClusters"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PROCESSEDCLUSTERS_DESCRIPTOR)
        field(UNPROCESSEDCLUSTERS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PROCESSEDCLUSTERS_DESCRIPTOR.index -> builder.processedClusters =
                    deserializer.deserializeList(PROCESSEDCLUSTERS_DESCRIPTOR) {
                        val col0 = mutableListOf<Cluster>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeClusterDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                UNPROCESSEDCLUSTERS_DESCRIPTOR.index -> builder.unprocessedClusters =
                    deserializer.deserializeList(UNPROCESSEDCLUSTERS_DESCRIPTOR) {
                        val col0 = mutableListOf<UnprocessedCluster>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeUnprocessedClusterDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
