// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.memorydb.paginators

import aws.sdk.kotlin.services.memorydb.MemoryDbClient
import aws.sdk.kotlin.services.memorydb.model.Acl
import aws.sdk.kotlin.services.memorydb.model.Cluster
import aws.sdk.kotlin.services.memorydb.model.DescribeAclsRequest
import aws.sdk.kotlin.services.memorydb.model.DescribeAclsResponse
import aws.sdk.kotlin.services.memorydb.model.DescribeClustersRequest
import aws.sdk.kotlin.services.memorydb.model.DescribeClustersResponse
import aws.sdk.kotlin.services.memorydb.model.DescribeEngineVersionsRequest
import aws.sdk.kotlin.services.memorydb.model.DescribeEngineVersionsResponse
import aws.sdk.kotlin.services.memorydb.model.DescribeEventsRequest
import aws.sdk.kotlin.services.memorydb.model.DescribeEventsResponse
import aws.sdk.kotlin.services.memorydb.model.DescribeParameterGroupsRequest
import aws.sdk.kotlin.services.memorydb.model.DescribeParameterGroupsResponse
import aws.sdk.kotlin.services.memorydb.model.DescribeParametersRequest
import aws.sdk.kotlin.services.memorydb.model.DescribeParametersResponse
import aws.sdk.kotlin.services.memorydb.model.DescribeReservedNodesOfferingsRequest
import aws.sdk.kotlin.services.memorydb.model.DescribeReservedNodesOfferingsResponse
import aws.sdk.kotlin.services.memorydb.model.DescribeReservedNodesRequest
import aws.sdk.kotlin.services.memorydb.model.DescribeReservedNodesResponse
import aws.sdk.kotlin.services.memorydb.model.DescribeServiceUpdatesRequest
import aws.sdk.kotlin.services.memorydb.model.DescribeServiceUpdatesResponse
import aws.sdk.kotlin.services.memorydb.model.DescribeSnapshotsRequest
import aws.sdk.kotlin.services.memorydb.model.DescribeSnapshotsResponse
import aws.sdk.kotlin.services.memorydb.model.DescribeSubnetGroupsRequest
import aws.sdk.kotlin.services.memorydb.model.DescribeSubnetGroupsResponse
import aws.sdk.kotlin.services.memorydb.model.DescribeUsersRequest
import aws.sdk.kotlin.services.memorydb.model.DescribeUsersResponse
import aws.sdk.kotlin.services.memorydb.model.EngineVersionInfo
import aws.sdk.kotlin.services.memorydb.model.Event
import aws.sdk.kotlin.services.memorydb.model.Parameter
import aws.sdk.kotlin.services.memorydb.model.ParameterGroup
import aws.sdk.kotlin.services.memorydb.model.ReservedNode
import aws.sdk.kotlin.services.memorydb.model.ReservedNodesOffering
import aws.sdk.kotlin.services.memorydb.model.ServiceUpdate
import aws.sdk.kotlin.services.memorydb.model.Snapshot
import aws.sdk.kotlin.services.memorydb.model.SubnetGroup
import aws.sdk.kotlin.services.memorydb.model.User
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [DescribeAclsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeAclsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAclsResponse]
 */
public fun MemoryDbClient.describeAclsPaginated(initialRequest: DescribeAclsRequest = DescribeAclsRequest { }): Flow<DescribeAclsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeAclsPaginated.describeAcls(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeAclsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeAclsResponse]
 */
public fun MemoryDbClient.describeAclsPaginated(block: DescribeAclsRequest.Builder.() -> Unit): Flow<DescribeAclsResponse> =
    describeAclsPaginated(DescribeAclsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeAclsPaginated]
 * to access the nested member [Acl]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Acl]
 */
@JvmName("describeAclsResponseAcl")
public fun Flow<DescribeAclsResponse>.acls(): Flow<Acl> =
    transform() { response ->
        response.acls?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeClustersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeClustersResponse]
 */
public fun MemoryDbClient.describeClustersPaginated(initialRequest: DescribeClustersRequest = DescribeClustersRequest { }): Flow<DescribeClustersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeClustersPaginated.describeClusters(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeClustersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeClustersResponse]
 */
public fun MemoryDbClient.describeClustersPaginated(block: DescribeClustersRequest.Builder.() -> Unit): Flow<DescribeClustersResponse> =
    describeClustersPaginated(DescribeClustersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeClustersPaginated]
 * to access the nested member [Cluster]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Cluster]
 */
@JvmName("describeClustersResponseCluster")
public fun Flow<DescribeClustersResponse>.clusters(): Flow<Cluster> =
    transform() { response ->
        response.clusters?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeEngineVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeEngineVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEngineVersionsResponse]
 */
public fun MemoryDbClient.describeEngineVersionsPaginated(initialRequest: DescribeEngineVersionsRequest = DescribeEngineVersionsRequest { }): Flow<DescribeEngineVersionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeEngineVersionsPaginated.describeEngineVersions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeEngineVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEngineVersionsResponse]
 */
public fun MemoryDbClient.describeEngineVersionsPaginated(block: DescribeEngineVersionsRequest.Builder.() -> Unit): Flow<DescribeEngineVersionsResponse> =
    describeEngineVersionsPaginated(DescribeEngineVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeEngineVersionsPaginated]
 * to access the nested member [EngineVersionInfo]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EngineVersionInfo]
 */
@JvmName("describeEngineVersionsResponseEngineVersionInfo")
public fun Flow<DescribeEngineVersionsResponse>.engineVersions(): Flow<EngineVersionInfo> =
    transform() { response ->
        response.engineVersions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeEventsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEventsResponse]
 */
public fun MemoryDbClient.describeEventsPaginated(initialRequest: DescribeEventsRequest = DescribeEventsRequest { }): Flow<DescribeEventsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeEventsPaginated.describeEvents(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeEventsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeEventsResponse]
 */
public fun MemoryDbClient.describeEventsPaginated(block: DescribeEventsRequest.Builder.() -> Unit): Flow<DescribeEventsResponse> =
    describeEventsPaginated(DescribeEventsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeEventsPaginated]
 * to access the nested member [Event]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Event]
 */
@JvmName("describeEventsResponseEvent")
public fun Flow<DescribeEventsResponse>.events(): Flow<Event> =
    transform() { response ->
        response.events?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeParameterGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeParameterGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeParameterGroupsResponse]
 */
public fun MemoryDbClient.describeParameterGroupsPaginated(initialRequest: DescribeParameterGroupsRequest = DescribeParameterGroupsRequest { }): Flow<DescribeParameterGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeParameterGroupsPaginated.describeParameterGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeParameterGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeParameterGroupsResponse]
 */
public fun MemoryDbClient.describeParameterGroupsPaginated(block: DescribeParameterGroupsRequest.Builder.() -> Unit): Flow<DescribeParameterGroupsResponse> =
    describeParameterGroupsPaginated(DescribeParameterGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeParameterGroupsPaginated]
 * to access the nested member [ParameterGroup]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ParameterGroup]
 */
@JvmName("describeParameterGroupsResponseParameterGroup")
public fun Flow<DescribeParameterGroupsResponse>.parameterGroups(): Flow<ParameterGroup> =
    transform() { response ->
        response.parameterGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeParametersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeParametersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeParametersResponse]
 */
public fun MemoryDbClient.describeParametersPaginated(initialRequest: DescribeParametersRequest): Flow<DescribeParametersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeParametersPaginated.describeParameters(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeParametersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeParametersResponse]
 */
public fun MemoryDbClient.describeParametersPaginated(block: DescribeParametersRequest.Builder.() -> Unit): Flow<DescribeParametersResponse> =
    describeParametersPaginated(DescribeParametersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeParametersPaginated]
 * to access the nested member [Parameter]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Parameter]
 */
@JvmName("describeParametersResponseParameter")
public fun Flow<DescribeParametersResponse>.parameters(): Flow<Parameter> =
    transform() { response ->
        response.parameters?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeReservedNodesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeReservedNodesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeReservedNodesResponse]
 */
public fun MemoryDbClient.describeReservedNodesPaginated(initialRequest: DescribeReservedNodesRequest = DescribeReservedNodesRequest { }): Flow<DescribeReservedNodesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeReservedNodesPaginated.describeReservedNodes(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeReservedNodesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeReservedNodesResponse]
 */
public fun MemoryDbClient.describeReservedNodesPaginated(block: DescribeReservedNodesRequest.Builder.() -> Unit): Flow<DescribeReservedNodesResponse> =
    describeReservedNodesPaginated(DescribeReservedNodesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeReservedNodesPaginated]
 * to access the nested member [ReservedNode]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ReservedNode]
 */
@JvmName("describeReservedNodesResponseReservedNode")
public fun Flow<DescribeReservedNodesResponse>.reservedNodes(): Flow<ReservedNode> =
    transform() { response ->
        response.reservedNodes?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeReservedNodesOfferingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeReservedNodesOfferingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeReservedNodesOfferingsResponse]
 */
public fun MemoryDbClient.describeReservedNodesOfferingsPaginated(initialRequest: DescribeReservedNodesOfferingsRequest = DescribeReservedNodesOfferingsRequest { }): Flow<DescribeReservedNodesOfferingsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeReservedNodesOfferingsPaginated.describeReservedNodesOfferings(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeReservedNodesOfferingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeReservedNodesOfferingsResponse]
 */
public fun MemoryDbClient.describeReservedNodesOfferingsPaginated(block: DescribeReservedNodesOfferingsRequest.Builder.() -> Unit): Flow<DescribeReservedNodesOfferingsResponse> =
    describeReservedNodesOfferingsPaginated(DescribeReservedNodesOfferingsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeReservedNodesOfferingsPaginated]
 * to access the nested member [ReservedNodesOffering]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ReservedNodesOffering]
 */
@JvmName("describeReservedNodesOfferingsResponseReservedNodesOffering")
public fun Flow<DescribeReservedNodesOfferingsResponse>.reservedNodesOfferings(): Flow<ReservedNodesOffering> =
    transform() { response ->
        response.reservedNodesOfferings?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeServiceUpdatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeServiceUpdatesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeServiceUpdatesResponse]
 */
public fun MemoryDbClient.describeServiceUpdatesPaginated(initialRequest: DescribeServiceUpdatesRequest = DescribeServiceUpdatesRequest { }): Flow<DescribeServiceUpdatesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeServiceUpdatesPaginated.describeServiceUpdates(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeServiceUpdatesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeServiceUpdatesResponse]
 */
public fun MemoryDbClient.describeServiceUpdatesPaginated(block: DescribeServiceUpdatesRequest.Builder.() -> Unit): Flow<DescribeServiceUpdatesResponse> =
    describeServiceUpdatesPaginated(DescribeServiceUpdatesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeServiceUpdatesPaginated]
 * to access the nested member [ServiceUpdate]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ServiceUpdate]
 */
@JvmName("describeServiceUpdatesResponseServiceUpdate")
public fun Flow<DescribeServiceUpdatesResponse>.serviceUpdates(): Flow<ServiceUpdate> =
    transform() { response ->
        response.serviceUpdates?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeSnapshotsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeSnapshotsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeSnapshotsResponse]
 */
public fun MemoryDbClient.describeSnapshotsPaginated(initialRequest: DescribeSnapshotsRequest = DescribeSnapshotsRequest { }): Flow<DescribeSnapshotsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeSnapshotsPaginated.describeSnapshots(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeSnapshotsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeSnapshotsResponse]
 */
public fun MemoryDbClient.describeSnapshotsPaginated(block: DescribeSnapshotsRequest.Builder.() -> Unit): Flow<DescribeSnapshotsResponse> =
    describeSnapshotsPaginated(DescribeSnapshotsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeSnapshotsPaginated]
 * to access the nested member [Snapshot]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Snapshot]
 */
@JvmName("describeSnapshotsResponseSnapshot")
public fun Flow<DescribeSnapshotsResponse>.snapshots(): Flow<Snapshot> =
    transform() { response ->
        response.snapshots?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeSubnetGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeSubnetGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeSubnetGroupsResponse]
 */
public fun MemoryDbClient.describeSubnetGroupsPaginated(initialRequest: DescribeSubnetGroupsRequest = DescribeSubnetGroupsRequest { }): Flow<DescribeSubnetGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeSubnetGroupsPaginated.describeSubnetGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeSubnetGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeSubnetGroupsResponse]
 */
public fun MemoryDbClient.describeSubnetGroupsPaginated(block: DescribeSubnetGroupsRequest.Builder.() -> Unit): Flow<DescribeSubnetGroupsResponse> =
    describeSubnetGroupsPaginated(DescribeSubnetGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeSubnetGroupsPaginated]
 * to access the nested member [SubnetGroup]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SubnetGroup]
 */
@JvmName("describeSubnetGroupsResponseSubnetGroup")
public fun Flow<DescribeSubnetGroupsResponse>.subnetGroups(): Flow<SubnetGroup> =
    transform() { response ->
        response.subnetGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [DescribeUsersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [DescribeUsersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeUsersResponse]
 */
public fun MemoryDbClient.describeUsersPaginated(initialRequest: DescribeUsersRequest = DescribeUsersRequest { }): Flow<DescribeUsersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@describeUsersPaginated.describeUsers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [DescribeUsersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DescribeUsersResponse]
 */
public fun MemoryDbClient.describeUsersPaginated(block: DescribeUsersRequest.Builder.() -> Unit): Flow<DescribeUsersResponse> =
    describeUsersPaginated(DescribeUsersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [describeUsersPaginated]
 * to access the nested member [User]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [User]
 */
@JvmName("describeUsersResponseUser")
public fun Flow<DescribeUsersResponse>.users(): Flow<User> =
    transform() { response ->
        response.users?.forEach {
            emit(it)
        }
    }
