// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.memorydb.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Represents the output of one of the following operations:
 * + CreateSubnetGroup
 * + UpdateSubnetGroup
 *
 * A subnet group is a collection of subnets (typically private) that you can designate for your clusters running in an Amazon Virtual Private Cloud (VPC) environment.
 */
public class SubnetGroup private constructor(builder: Builder) {
    /**
     * The ARN (Amazon Resource Name) of the subnet group.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * A description of the subnet group
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the subnet group
     */
    public val name: kotlin.String? = builder.name
    /**
     * A list of subnets associated with the subnet group.
     */
    public val subnets: List<Subnet>? = builder.subnets
    /**
     * The Amazon Virtual Private Cloud identifier (VPC ID) of the subnet group.
     */
    public val vpcId: kotlin.String? = builder.vpcId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.memorydb.model.SubnetGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SubnetGroup(")
        append("arn=$arn,")
        append("description=$description,")
        append("name=$name,")
        append("subnets=$subnets,")
        append("vpcId=$vpcId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (subnets?.hashCode() ?: 0)
        result = 31 * result + (vpcId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SubnetGroup

        if (arn != other.arn) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (subnets != other.subnets) return false
        if (vpcId != other.vpcId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.memorydb.model.SubnetGroup = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN (Amazon Resource Name) of the subnet group.
         */
        public var arn: kotlin.String? = null
        /**
         * A description of the subnet group
         */
        public var description: kotlin.String? = null
        /**
         * The name of the subnet group
         */
        public var name: kotlin.String? = null
        /**
         * A list of subnets associated with the subnet group.
         */
        public var subnets: List<Subnet>? = null
        /**
         * The Amazon Virtual Private Cloud identifier (VPC ID) of the subnet group.
         */
        public var vpcId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.memorydb.model.SubnetGroup) : this() {
            this.arn = x.arn
            this.description = x.description
            this.name = x.name
            this.subnets = x.subnets
            this.vpcId = x.vpcId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.memorydb.model.SubnetGroup = SubnetGroup(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
