// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.memorydb.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents a single occurrence of something interesting within the system. Some examples of events are creating a cluster or adding or removing a node.
 */
public class Event private constructor(builder: Builder) {
    /**
     * The date and time when the event occurred.
     */
    public val date: aws.smithy.kotlin.runtime.time.Instant? = builder.date
    /**
     * The text of the event.
     */
    public val message: kotlin.String? = builder.message
    /**
     * The name for the source of the event. For example, if the event occurred at the cluster level, the identifier would be the name of the cluster.
     */
    public val sourceName: kotlin.String? = builder.sourceName
    /**
     * Specifies the origin of this event - a cluster, a parameter group, a security group, etc.
     */
    public val sourceType: aws.sdk.kotlin.services.memorydb.model.SourceType? = builder.sourceType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.memorydb.model.Event = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Event(")
        append("date=$date,")
        append("message=$message,")
        append("sourceName=$sourceName,")
        append("sourceType=$sourceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = date?.hashCode() ?: 0
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (sourceName?.hashCode() ?: 0)
        result = 31 * result + (sourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Event

        if (date != other.date) return false
        if (message != other.message) return false
        if (sourceName != other.sourceName) return false
        if (sourceType != other.sourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.memorydb.model.Event = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The date and time when the event occurred.
         */
        public var date: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The text of the event.
         */
        public var message: kotlin.String? = null
        /**
         * The name for the source of the event. For example, if the event occurred at the cluster level, the identifier would be the name of the cluster.
         */
        public var sourceName: kotlin.String? = null
        /**
         * Specifies the origin of this event - a cluster, a parameter group, a security group, etc.
         */
        public var sourceType: aws.sdk.kotlin.services.memorydb.model.SourceType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.memorydb.model.Event) : this() {
            this.date = x.date
            this.message = x.message
            this.sourceName = x.sourceName
            this.sourceType = x.sourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.memorydb.model.Event = Event(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
