// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.memorydb.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DescribeReservedNodesRequest private constructor(builder: Builder) {
    /**
     * The duration filter value, specified in years or seconds. Use this parameter to show only reservations for this duration.
     */
    public val duration: kotlin.String? = builder.duration
    /**
     * The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * The node type filter value. Use this parameter to show only those reservations matching the specified node type. For more information, see [Supported node types](https://docs.aws.amazon.com/memorydb/latest/devguide/nodes.reserved.html#reserved-nodes-supported).
     */
    public val nodeType: kotlin.String? = builder.nodeType
    /**
     * The offering type filter value. Use this parameter to show only the available offerings matching the specified offering type. Valid values: "All Upfront"|"Partial Upfront"| "No Upfront"
     */
    public val offeringType: kotlin.String? = builder.offeringType
    /**
     * The reserved node identifier filter value. Use this parameter to show only the reservation that matches the specified reservation ID.
     */
    public val reservationId: kotlin.String? = builder.reservationId
    /**
     * The offering identifier filter value. Use this parameter to show only purchased reservations matching the specified offering identifier.
     */
    public val reservedNodesOfferingId: kotlin.String? = builder.reservedNodesOfferingId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.memorydb.model.DescribeReservedNodesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeReservedNodesRequest(")
        append("duration=$duration,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("nodeType=$nodeType,")
        append("offeringType=$offeringType,")
        append("reservationId=$reservationId,")
        append("reservedNodesOfferingId=$reservedNodesOfferingId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = duration?.hashCode() ?: 0
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (nodeType?.hashCode() ?: 0)
        result = 31 * result + (offeringType?.hashCode() ?: 0)
        result = 31 * result + (reservationId?.hashCode() ?: 0)
        result = 31 * result + (reservedNodesOfferingId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeReservedNodesRequest

        if (duration != other.duration) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (nodeType != other.nodeType) return false
        if (offeringType != other.offeringType) return false
        if (reservationId != other.reservationId) return false
        if (reservedNodesOfferingId != other.reservedNodesOfferingId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.memorydb.model.DescribeReservedNodesRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The duration filter value, specified in years or seconds. Use this parameter to show only reservations for this duration.
         */
        public var duration: kotlin.String? = null
        /**
         * The maximum number of records to include in the response. If more records exist than the specified MaxRecords value, a marker is included in the response so that the remaining results can be retrieved.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * An optional marker returned from a prior request. Use this marker for pagination of results from this operation. If this parameter is specified, the response includes only records beyond the marker, up to the value specified by MaxRecords.
         */
        public var nextToken: kotlin.String? = null
        /**
         * The node type filter value. Use this parameter to show only those reservations matching the specified node type. For more information, see [Supported node types](https://docs.aws.amazon.com/memorydb/latest/devguide/nodes.reserved.html#reserved-nodes-supported).
         */
        public var nodeType: kotlin.String? = null
        /**
         * The offering type filter value. Use this parameter to show only the available offerings matching the specified offering type. Valid values: "All Upfront"|"Partial Upfront"| "No Upfront"
         */
        public var offeringType: kotlin.String? = null
        /**
         * The reserved node identifier filter value. Use this parameter to show only the reservation that matches the specified reservation ID.
         */
        public var reservationId: kotlin.String? = null
        /**
         * The offering identifier filter value. Use this parameter to show only purchased reservations matching the specified offering identifier.
         */
        public var reservedNodesOfferingId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.memorydb.model.DescribeReservedNodesRequest) : this() {
            this.duration = x.duration
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.nodeType = x.nodeType
            this.offeringType = x.offeringType
            this.reservationId = x.reservationId
            this.reservedNodesOfferingId = x.reservedNodesOfferingId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.memorydb.model.DescribeReservedNodesRequest = DescribeReservedNodesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
