// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.memorydb.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An Access Control List. You can authenticate users with Access Contol Lists. ACLs enable you to control cluster access by grouping users. These Access control lists are designed as a way to organize access to clusters.
 */
public class Acl private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the ACL
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * A list of clusters associated with the ACL.
     */
    public val clusters: List<String>? = builder.clusters
    /**
     * The minimum engine version supported for the ACL
     */
    public val minimumEngineVersion: kotlin.String? = builder.minimumEngineVersion
    /**
     * The name of the Access Control List
     */
    public val name: kotlin.String? = builder.name
    /**
     * A list of updates being applied to the ACL.
     */
    public val pendingChanges: aws.sdk.kotlin.services.memorydb.model.AclPendingChanges? = builder.pendingChanges
    /**
     * Indicates ACL status. Can be "creating", "active", "modifying", "deleting".
     */
    public val status: kotlin.String? = builder.status
    /**
     * The list of user names that belong to the ACL.
     */
    public val userNames: List<String>? = builder.userNames

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.memorydb.model.Acl = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Acl(")
        append("arn=$arn,")
        append("clusters=$clusters,")
        append("minimumEngineVersion=$minimumEngineVersion,")
        append("name=$name,")
        append("pendingChanges=$pendingChanges,")
        append("status=$status,")
        append("userNames=$userNames")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (clusters?.hashCode() ?: 0)
        result = 31 * result + (minimumEngineVersion?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (pendingChanges?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (userNames?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Acl

        if (arn != other.arn) return false
        if (clusters != other.clusters) return false
        if (minimumEngineVersion != other.minimumEngineVersion) return false
        if (name != other.name) return false
        if (pendingChanges != other.pendingChanges) return false
        if (status != other.status) return false
        if (userNames != other.userNames) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.memorydb.model.Acl = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the ACL
         */
        public var arn: kotlin.String? = null
        /**
         * A list of clusters associated with the ACL.
         */
        public var clusters: List<String>? = null
        /**
         * The minimum engine version supported for the ACL
         */
        public var minimumEngineVersion: kotlin.String? = null
        /**
         * The name of the Access Control List
         */
        public var name: kotlin.String? = null
        /**
         * A list of updates being applied to the ACL.
         */
        public var pendingChanges: aws.sdk.kotlin.services.memorydb.model.AclPendingChanges? = null
        /**
         * Indicates ACL status. Can be "creating", "active", "modifying", "deleting".
         */
        public var status: kotlin.String? = null
        /**
         * The list of user names that belong to the ACL.
         */
        public var userNames: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.memorydb.model.Acl) : this() {
            this.arn = x.arn
            this.clusters = x.clusters
            this.minimumEngineVersion = x.minimumEngineVersion
            this.name = x.name
            this.pendingChanges = x.pendingChanges
            this.status = x.status
            this.userNames = x.userNames
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.memorydb.model.Acl = Acl(this)

        /**
         * construct an [aws.sdk.kotlin.services.memorydb.model.AclPendingChanges] inside the given [block]
         */
        public fun pendingChanges(block: aws.sdk.kotlin.services.memorydb.model.AclPendingChanges.Builder.() -> kotlin.Unit) {
            this.pendingChanges = aws.sdk.kotlin.services.memorydb.model.AclPendingChanges.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
