// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.memorydb.endpoints

import aws.sdk.kotlin.services.memorydb.endpoints.internal.partition
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.client.endpoints.EndpointProviderException
import aws.smithy.kotlin.runtime.client.endpoints.SigningContextAttributeKey
import aws.smithy.kotlin.runtime.collections.attributesOf
import aws.smithy.kotlin.runtime.http.auth.sigV4
import aws.smithy.kotlin.runtime.net.url.Url

/**
 * The default endpoint provider as specified by the service model.
 */
public class DefaultMemoryDbEndpointProvider: MemoryDbEndpointProvider {
    public override suspend fun resolveEndpoint(params: MemoryDbEndpointParameters): Endpoint {
        if (
            params.endpoint != null
        ) {
            if (
                params.useFips == true
            ) {
                throw EndpointProviderException("Invalid Configuration: FIPS and custom endpoint are not supported")
            }
            if (
                params.useDualStack == true
            ) {
                throw EndpointProviderException("Invalid Configuration: Dualstack and custom endpoint are not supported")
            }
            return Endpoint(
                Url.parse(params.endpoint),
            )
        }
        if (
            params.region != null
        ) {
            run {
                val partitionResult = partition(params.region)
                if (
                    partitionResult != null
                ) {
                    if (
                        params.useFips == true &&
                        params.useDualStack == true
                    ) {
                        if (
                            true == partitionResult?.supportsFIPS &&
                            true == partitionResult?.supportsDualStack
                        ) {
                            return Endpoint(
                                Url.parse("https://memory-db-fips.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                            )
                        }
                        throw EndpointProviderException("FIPS and DualStack are enabled, but this partition does not support one or both")
                    }
                    if (
                        params.useFips == true
                    ) {
                        if (
                            partitionResult?.supportsFIPS == true
                        ) {
                            return Endpoint(
                                Url.parse("https://memory-db-fips.${params.region}.${partitionResult?.dnsSuffix}"),
                            )
                        }
                        throw EndpointProviderException("FIPS is enabled but this partition does not support FIPS")
                    }
                    if (
                        params.useDualStack == true
                    ) {
                        if (
                            true == partitionResult?.supportsDualStack
                        ) {
                            return Endpoint(
                                Url.parse("https://memory-db.${params.region}.${partitionResult?.dualStackDnsSuffix}"),
                            )
                        }
                        throw EndpointProviderException("DualStack is enabled but this partition does not support DualStack")
                    }
                    if (
                        params.region == "fips"
                    ) {
                        return Endpoint(
                            Url.parse("https://memory-db-fips.us-west-1.amazonaws.com"),
                            attributes = attributesOf {
                                SigningContextAttributeKey to listOf(
                                    sigV4(
                                        serviceName = "memorydb",
                                        disableDoubleUriEncode = false,
                                        signingRegion = "us-west-1",
                                    ),
                                )
                            },
                        )
                    }
                    return Endpoint(
                        Url.parse("https://memory-db.${params.region}.${partitionResult?.dnsSuffix}"),
                    )
                }
            }
        }
        throw EndpointProviderException("Invalid Configuration: Missing Region")

        throw EndpointProviderException("endpoint rules were exhausted without a match")
    }
}
