// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.mediatailor.serde

import aws.sdk.kotlin.services.mediatailor.model.AccessConfiguration
import aws.sdk.kotlin.services.mediatailor.model.DefaultSegmentDeliveryConfiguration
import aws.sdk.kotlin.services.mediatailor.model.HttpConfiguration
import aws.sdk.kotlin.services.mediatailor.model.SegmentDeliveryConfiguration
import aws.sdk.kotlin.services.mediatailor.model.UpdateSourceLocationRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateSourceLocationOperationSerializer: HttpSerializer.NonStreaming<UpdateSourceLocationRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateSourceLocationRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            path.encodedSegments {
                add(PercentEncoding.Path.encode("sourceLocation"))
                add(PercentEncoding.SmithyLabel.encode(input.sourceLocationName))
            }
        }

        val payload = serializeUpdateSourceLocationOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateSourceLocationOperationBody(context: ExecutionContext, input: UpdateSourceLocationRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACCESSCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AccessConfiguration"))
    val DEFAULTSEGMENTDELIVERYCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DefaultSegmentDeliveryConfiguration"))
    val HTTPCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("HttpConfiguration"))
    val SEGMENTDELIVERYCONFIGURATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("SegmentDeliveryConfigurations"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCESSCONFIGURATION_DESCRIPTOR)
        field(DEFAULTSEGMENTDELIVERYCONFIGURATION_DESCRIPTOR)
        field(HTTPCONFIGURATION_DESCRIPTOR)
        field(SEGMENTDELIVERYCONFIGURATIONS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.accessConfiguration?.let { field(ACCESSCONFIGURATION_DESCRIPTOR, it, ::serializeAccessConfigurationDocument) }
        input.defaultSegmentDeliveryConfiguration?.let { field(DEFAULTSEGMENTDELIVERYCONFIGURATION_DESCRIPTOR, it, ::serializeDefaultSegmentDeliveryConfigurationDocument) }
        input.httpConfiguration?.let { field(HTTPCONFIGURATION_DESCRIPTOR, it, ::serializeHttpConfigurationDocument) }
        if (input.segmentDeliveryConfigurations != null) {
            listField(SEGMENTDELIVERYCONFIGURATIONS_DESCRIPTOR) {
                for (el0 in input.segmentDeliveryConfigurations) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeSegmentDeliveryConfigurationDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
